# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BaseOutput(object):
    """
    Base output.
    """

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "ARRAY"
    TYPE_ARRAY = "ARRAY"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "BOOLEAN"
    TYPE_BOOLEAN = "BOOLEAN"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "NUMBER"
    TYPE_NUMBER = "NUMBER"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "STRING"
    TYPE_STRING = "STRING"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "COPYABLESTRING"
    TYPE_COPYABLESTRING = "COPYABLESTRING"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "MAP"
    TYPE_MAP = "MAP"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "LIST"
    TYPE_LIST = "LIST"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "JSON"
    TYPE_JSON = "JSON"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "CSV"
    TYPE_CSV = "CSV"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "LINK"
    TYPE_LINK = "LINK"

    #: A constant which can be used with the type property of a BaseOutput.
    #: This constant has a value of "OCID"
    TYPE_OCID = "OCID"

    def __init__(self, **kwargs):
        """
        Initializes a new BaseOutput object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.ListOutput`
        * :class:`~oci.fleet_apps_management.models.OcidOutput`
        * :class:`~oci.fleet_apps_management.models.CsvOutput`
        * :class:`~oci.fleet_apps_management.models.CopyableStringOutput`
        * :class:`~oci.fleet_apps_management.models.JsonOutput`
        * :class:`~oci.fleet_apps_management.models.NumberOutput`
        * :class:`~oci.fleet_apps_management.models.StringOutput`
        * :class:`~oci.fleet_apps_management.models.MapOutput`
        * :class:`~oci.fleet_apps_management.models.LinkOutput`
        * :class:`~oci.fleet_apps_management.models.BoolOutput`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this BaseOutput.
            Allowed values for this property are: "ARRAY", "BOOLEAN", "NUMBER", "STRING", "COPYABLESTRING", "MAP", "LIST", "JSON", "CSV", "LINK", "OCID", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param title:
            The value to assign to the title property of this BaseOutput.
        :type title: str

        :param description:
            The value to assign to the description property of this BaseOutput.
        :type description: str

        :param is_sensitive:
            The value to assign to the is_sensitive property of this BaseOutput.
        :type is_sensitive: bool

        :param format:
            The value to assign to the format property of this BaseOutput.
        :type format: str

        :param visible:
            The value to assign to the visible property of this BaseOutput.
        :type visible: str

        """
        self.swagger_types = {
            'type': 'str',
            'title': 'str',
            'description': 'str',
            'is_sensitive': 'bool',
            'format': 'str',
            'visible': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'title': 'title',
            'description': 'description',
            'is_sensitive': 'isSensitive',
            'format': 'format',
            'visible': 'visible'
        }
        self._type = None
        self._title = None
        self._description = None
        self._is_sensitive = None
        self._format = None
        self._visible = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'LIST':
            return 'ListOutput'

        if type == 'OCID':
            return 'OcidOutput'

        if type == 'CSV':
            return 'CsvOutput'

        if type == 'COPYABLESTRING':
            return 'CopyableStringOutput'

        if type == 'JSON':
            return 'JsonOutput'

        if type == 'NUMBER':
            return 'NumberOutput'

        if type == 'STRING':
            return 'StringOutput'

        if type == 'MAP':
            return 'MapOutput'

        if type == 'LINK':
            return 'LinkOutput'

        if type == 'boolean':
            return 'BoolOutput'
        else:
            return 'BaseOutput'

    @property
    def type(self):
        """
        Gets the type of this BaseOutput.
        Data type of the output value (such as STRING, NUMBER, OCID, etc).

        Allowed values for this property are: "ARRAY", "BOOLEAN", "NUMBER", "STRING", "COPYABLESTRING", "MAP", "LIST", "JSON", "CSV", "LINK", "OCID", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this BaseOutput.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this BaseOutput.
        Data type of the output value (such as STRING, NUMBER, OCID, etc).


        :param type: The type of this BaseOutput.
        :type: str
        """
        allowed_values = ["ARRAY", "BOOLEAN", "NUMBER", "STRING", "COPYABLESTRING", "MAP", "LIST", "JSON", "CSV", "LINK", "OCID"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def title(self):
        """
        Gets the title of this BaseOutput.
        Output label shown to the user.


        :return: The title of this BaseOutput.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this BaseOutput.
        Output label shown to the user.


        :param title: The title of this BaseOutput.
        :type: str
        """
        self._title = title

    @property
    def description(self):
        """
        Gets the description of this BaseOutput.
        Extended help or summary for understanding output.


        :return: The description of this BaseOutput.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BaseOutput.
        Extended help or summary for understanding output.


        :param description: The description of this BaseOutput.
        :type: str
        """
        self._description = description

    @property
    def is_sensitive(self):
        """
        Gets the is_sensitive of this BaseOutput.
        If true, marks this output as sensitive.


        :return: The is_sensitive of this BaseOutput.
        :rtype: bool
        """
        return self._is_sensitive

    @is_sensitive.setter
    def is_sensitive(self, is_sensitive):
        """
        Sets the is_sensitive of this BaseOutput.
        If true, marks this output as sensitive.


        :param is_sensitive: The is_sensitive of this BaseOutput.
        :type: bool
        """
        self._is_sensitive = is_sensitive

    @property
    def format(self):
        """
        Gets the format of this BaseOutput.
        Hint about formatting or rendering the output value.


        :return: The format of this BaseOutput.
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """
        Sets the format of this BaseOutput.
        Hint about formatting or rendering the output value.


        :param format: The format of this BaseOutput.
        :type: str
        """
        self._format = format

    @property
    def visible(self):
        """
        Gets the visible of this BaseOutput.
        Expression to show/hide this output.


        :return: The visible of this BaseOutput.
        :rtype: str
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Sets the visible of this BaseOutput.
        Expression to show/hide this output.


        :param visible: The visible of this BaseOutput.
        :type: str
        """
        self._visible = visible

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
