# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20170907


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateEmailIpPoolDetails(object):
    """
    The configuration details required to create a new IpPool which will be used to route emails.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateEmailIpPoolDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateEmailIpPoolDetails.
        :type name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateEmailIpPoolDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CreateEmailIpPoolDetails.
        :type description: str

        :param outbound_ips:
            The value to assign to the outbound_ips property of this CreateEmailIpPoolDetails.
        :type outbound_ips: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateEmailIpPoolDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateEmailIpPoolDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'outbound_ips': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'name': 'name',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'outbound_ips': 'outboundIps',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._name = None
        self._compartment_id = None
        self._description = None
        self._outbound_ips = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateEmailIpPoolDetails.
        The name of the IpPool. The name must be unique within a region.
        The name is case sensitive and supported characters include alphanumeric, hyphens (\"-\") and underscore (\"_\") characters.

        Example: green_pool-1


        :return: The name of this CreateEmailIpPoolDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateEmailIpPoolDetails.
        The name of the IpPool. The name must be unique within a region.
        The name is case sensitive and supported characters include alphanumeric, hyphens (\"-\") and underscore (\"_\") characters.

        Example: green_pool-1


        :param name: The name of this CreateEmailIpPoolDetails.
        :type: str
        """
        self._name = name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateEmailIpPoolDetails.
        The `OCID`__ of the compartment for this IpPool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateEmailIpPoolDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateEmailIpPoolDetails.
        The `OCID`__ of the compartment for this IpPool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateEmailIpPoolDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CreateEmailIpPoolDetails.
        The description of the IpPool. Avoid entering confidential information.


        :return: The description of this CreateEmailIpPoolDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateEmailIpPoolDetails.
        The description of the IpPool. Avoid entering confidential information.


        :param description: The description of this CreateEmailIpPoolDetails.
        :type: str
        """
        self._description = description

    @property
    def outbound_ips(self):
        """
        **[Required]** Gets the outbound_ips of this CreateEmailIpPoolDetails.
        A list of outbound public IPs for assignment to the IpPool. These IPs must be in the AVAILABLE state to be eligible for assignment.


        :return: The outbound_ips of this CreateEmailIpPoolDetails.
        :rtype: list[str]
        """
        return self._outbound_ips

    @outbound_ips.setter
    def outbound_ips(self, outbound_ips):
        """
        Sets the outbound_ips of this CreateEmailIpPoolDetails.
        A list of outbound public IPs for assignment to the IpPool. These IPs must be in the AVAILABLE state to be eligible for assignment.


        :param outbound_ips: The outbound_ips of this CreateEmailIpPoolDetails.
        :type: list[str]
        """
        self._outbound_ips = outbound_ips

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateEmailIpPoolDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateEmailIpPoolDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateEmailIpPoolDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateEmailIpPoolDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateEmailIpPoolDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateEmailIpPoolDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateEmailIpPoolDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateEmailIpPoolDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
