# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateStackDetails(object):
    """
    Details to create a Stack.
    """

    #: A constant which can be used with the stack_templates property of a CreateStackDetails.
    #: This constant has a value of "DATALAKE"
    STACK_TEMPLATES_DATALAKE = "DATALAKE"

    #: A constant which can be used with the stack_templates property of a CreateStackDetails.
    #: This constant has a value of "DATAPIPELINE"
    STACK_TEMPLATES_DATAPIPELINE = "DATAPIPELINE"

    #: A constant which can be used with the stack_templates property of a CreateStackDetails.
    #: This constant has a value of "AISERVICES"
    STACK_TEMPLATES_AISERVICES = "AISERVICES"

    #: A constant which can be used with the stack_templates property of a CreateStackDetails.
    #: This constant has a value of "DATATRANSFORMATION"
    STACK_TEMPLATES_DATATRANSFORMATION = "DATATRANSFORMATION"

    #: A constant which can be used with the services property of a CreateStackDetails.
    #: This constant has a value of "ADB"
    SERVICES_ADB = "ADB"

    #: A constant which can be used with the services property of a CreateStackDetails.
    #: This constant has a value of "GGCS"
    SERVICES_GGCS = "GGCS"

    #: A constant which can be used with the services property of a CreateStackDetails.
    #: This constant has a value of "OBJECTSTORAGE"
    SERVICES_OBJECTSTORAGE = "OBJECTSTORAGE"

    #: A constant which can be used with the services property of a CreateStackDetails.
    #: This constant has a value of "GENAI"
    SERVICES_GENAI = "GENAI"

    #: A constant which can be used with the services property of a CreateStackDetails.
    #: This constant has a value of "DATAFLOW"
    SERVICES_DATAFLOW = "DATAFLOW"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateStackDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateStackDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateStackDetails.
        :type compartment_id: str

        :param notification_email:
            The value to assign to the notification_email property of this CreateStackDetails.
        :type notification_email: str

        :param stack_templates:
            The value to assign to the stack_templates property of this CreateStackDetails.
            Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"
        :type stack_templates: list[str]

        :param services:
            The value to assign to the services property of this CreateStackDetails.
            Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"
        :type services: list[str]

        :param adb:
            The value to assign to the adb property of this CreateStackDetails.
        :type adb: list[oci.dif.models.AdbDetail]

        :param ggcs:
            The value to assign to the ggcs property of this CreateStackDetails.
        :type ggcs: list[oci.dif.models.GgcsDetail]

        :param dataflow:
            The value to assign to the dataflow property of this CreateStackDetails.
        :type dataflow: list[oci.dif.models.DataflowDetail]

        :param objectstorage:
            The value to assign to the objectstorage property of this CreateStackDetails.
        :type objectstorage: list[oci.dif.models.ObjectStorageDetail]

        :param genai:
            The value to assign to the genai property of this CreateStackDetails.
        :type genai: list[oci.dif.models.GenAiDetail]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateStackDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateStackDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'notification_email': 'str',
            'stack_templates': 'list[str]',
            'services': 'list[str]',
            'adb': 'list[AdbDetail]',
            'ggcs': 'list[GgcsDetail]',
            'dataflow': 'list[DataflowDetail]',
            'objectstorage': 'list[ObjectStorageDetail]',
            'genai': 'list[GenAiDetail]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'notification_email': 'notificationEmail',
            'stack_templates': 'stackTemplates',
            'services': 'services',
            'adb': 'adb',
            'ggcs': 'ggcs',
            'dataflow': 'dataflow',
            'objectstorage': 'objectstorage',
            'genai': 'genai',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._notification_email = None
        self._stack_templates = None
        self._services = None
        self._adb = None
        self._ggcs = None
        self._dataflow = None
        self._objectstorage = None
        self._genai = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateStackDetails.
        A user-friendly name. Should be unique per compartment. Avoid entering confidential information.


        :return: The display_name of this CreateStackDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateStackDetails.
        A user-friendly name. Should be unique per compartment. Avoid entering confidential information.


        :param display_name: The display_name of this CreateStackDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateStackDetails.
        The `OCID`__ of the compartment to create the Stack in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateStackDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateStackDetails.
        The `OCID`__ of the compartment to create the Stack in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateStackDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def notification_email(self):
        """
        Gets the notification_email of this CreateStackDetails.
        email id to which the stack notifications would be sent.


        :return: The notification_email of this CreateStackDetails.
        :rtype: str
        """
        return self._notification_email

    @notification_email.setter
    def notification_email(self, notification_email):
        """
        Sets the notification_email of this CreateStackDetails.
        email id to which the stack notifications would be sent.


        :param notification_email: The notification_email of this CreateStackDetails.
        :type: str
        """
        self._notification_email = notification_email

    @property
    def stack_templates(self):
        """
        **[Required]** Gets the stack_templates of this CreateStackDetails.
        List of templates to be onboarded for the stack.

        Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"


        :return: The stack_templates of this CreateStackDetails.
        :rtype: list[str]
        """
        return self._stack_templates

    @stack_templates.setter
    def stack_templates(self, stack_templates):
        """
        Sets the stack_templates of this CreateStackDetails.
        List of templates to be onboarded for the stack.


        :param stack_templates: The stack_templates of this CreateStackDetails.
        :type: list[str]
        """
        allowed_values = ["DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"]

        if stack_templates and stack_templates is not NONE_SENTINEL:
            for value in stack_templates:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `stack_templates`, must be None or one of {allowed_values}"
                    )
        self._stack_templates = stack_templates

    @property
    def services(self):
        """
        **[Required]** Gets the services of this CreateStackDetails.
        List of services to be onboarded for the stack.

        Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"


        :return: The services of this CreateStackDetails.
        :rtype: list[str]
        """
        return self._services

    @services.setter
    def services(self, services):
        """
        Sets the services of this CreateStackDetails.
        List of services to be onboarded for the stack.


        :param services: The services of this CreateStackDetails.
        :type: list[str]
        """
        allowed_values = ["ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"]

        if services and services is not NONE_SENTINEL:
            for value in services:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `services`, must be None or one of {allowed_values}"
                    )
        self._services = services

    @property
    def adb(self):
        """
        Gets the adb of this CreateStackDetails.
        ADB details if adb is included in the services.


        :return: The adb of this CreateStackDetails.
        :rtype: list[oci.dif.models.AdbDetail]
        """
        return self._adb

    @adb.setter
    def adb(self, adb):
        """
        Sets the adb of this CreateStackDetails.
        ADB details if adb is included in the services.


        :param adb: The adb of this CreateStackDetails.
        :type: list[oci.dif.models.AdbDetail]
        """
        self._adb = adb

    @property
    def ggcs(self):
        """
        Gets the ggcs of this CreateStackDetails.
        GGCS details if ggcs is included in the services.


        :return: The ggcs of this CreateStackDetails.
        :rtype: list[oci.dif.models.GgcsDetail]
        """
        return self._ggcs

    @ggcs.setter
    def ggcs(self, ggcs):
        """
        Sets the ggcs of this CreateStackDetails.
        GGCS details if ggcs is included in the services.


        :param ggcs: The ggcs of this CreateStackDetails.
        :type: list[oci.dif.models.GgcsDetail]
        """
        self._ggcs = ggcs

    @property
    def dataflow(self):
        """
        Gets the dataflow of this CreateStackDetails.
        DATAFLOW details if dataflow is included in the services.


        :return: The dataflow of this CreateStackDetails.
        :rtype: list[oci.dif.models.DataflowDetail]
        """
        return self._dataflow

    @dataflow.setter
    def dataflow(self, dataflow):
        """
        Sets the dataflow of this CreateStackDetails.
        DATAFLOW details if dataflow is included in the services.


        :param dataflow: The dataflow of this CreateStackDetails.
        :type: list[oci.dif.models.DataflowDetail]
        """
        self._dataflow = dataflow

    @property
    def objectstorage(self):
        """
        Gets the objectstorage of this CreateStackDetails.
        Object Storage Details if object storage is included in services.


        :return: The objectstorage of this CreateStackDetails.
        :rtype: list[oci.dif.models.ObjectStorageDetail]
        """
        return self._objectstorage

    @objectstorage.setter
    def objectstorage(self, objectstorage):
        """
        Sets the objectstorage of this CreateStackDetails.
        Object Storage Details if object storage is included in services.


        :param objectstorage: The objectstorage of this CreateStackDetails.
        :type: list[oci.dif.models.ObjectStorageDetail]
        """
        self._objectstorage = objectstorage

    @property
    def genai(self):
        """
        Gets the genai of this CreateStackDetails.
        GenAi Details if genai is included in services.


        :return: The genai of this CreateStackDetails.
        :rtype: list[oci.dif.models.GenAiDetail]
        """
        return self._genai

    @genai.setter
    def genai(self, genai):
        """
        Sets the genai of this CreateStackDetails.
        GenAi Details if genai is included in services.


        :param genai: The genai of this CreateStackDetails.
        :type: list[oci.dif.models.GenAiDetail]
        """
        self._genai = genai

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateStackDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateStackDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateStackDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateStackDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateStackDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateStackDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateStackDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateStackDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
