# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SyncRepositoryDetails(object):
    """
    Details required for syncing a repository with its upstream.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SyncRepositoryDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_branch:
            The value to assign to the source_branch property of this SyncRepositoryDetails.
        :type source_branch: str

        :param destination_branch:
            The value to assign to the destination_branch property of this SyncRepositoryDetails.
        :type destination_branch: str

        """
        self.swagger_types = {
            'source_branch': 'str',
            'destination_branch': 'str'
        }
        self.attribute_map = {
            'source_branch': 'sourceBranch',
            'destination_branch': 'destinationBranch'
        }
        self._source_branch = None
        self._destination_branch = None

    @property
    def source_branch(self):
        """
        **[Required]** Gets the source_branch of this SyncRepositoryDetails.
        The branch in the upstream repository we want to sync from.


        :return: The source_branch of this SyncRepositoryDetails.
        :rtype: str
        """
        return self._source_branch

    @source_branch.setter
    def source_branch(self, source_branch):
        """
        Sets the source_branch of this SyncRepositoryDetails.
        The branch in the upstream repository we want to sync from.


        :param source_branch: The source_branch of this SyncRepositoryDetails.
        :type: str
        """
        self._source_branch = source_branch

    @property
    def destination_branch(self):
        """
        **[Required]** Gets the destination_branch of this SyncRepositoryDetails.
        The branch in the repository we want to be updated with changes from the upstream.


        :return: The destination_branch of this SyncRepositoryDetails.
        :rtype: str
        """
        return self._destination_branch

    @destination_branch.setter
    def destination_branch(self, destination_branch):
        """
        Sets the destination_branch of this SyncRepositoryDetails.
        The branch in the repository we want to be updated with changes from the upstream.


        :param destination_branch: The destination_branch of this SyncRepositoryDetails.
        :type: str
        """
        self._destination_branch = destination_branch

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
