# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOrUpdateProtectedBranchDetails(object):
    """
    Information to create a protected branch
    """

    #: A constant which can be used with the protection_levels property of a CreateOrUpdateProtectedBranchDetails.
    #: This constant has a value of "READ_ONLY"
    PROTECTION_LEVELS_READ_ONLY = "READ_ONLY"

    #: A constant which can be used with the protection_levels property of a CreateOrUpdateProtectedBranchDetails.
    #: This constant has a value of "PULL_REQUEST_MERGE_ONLY"
    PROTECTION_LEVELS_PULL_REQUEST_MERGE_ONLY = "PULL_REQUEST_MERGE_ONLY"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOrUpdateProtectedBranchDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param branch_name:
            The value to assign to the branch_name property of this CreateOrUpdateProtectedBranchDetails.
        :type branch_name: str

        :param protection_levels:
            The value to assign to the protection_levels property of this CreateOrUpdateProtectedBranchDetails.
            Allowed values for items in this list are: "READ_ONLY", "PULL_REQUEST_MERGE_ONLY"
        :type protection_levels: list[str]

        """
        self.swagger_types = {
            'branch_name': 'str',
            'protection_levels': 'list[str]'
        }
        self.attribute_map = {
            'branch_name': 'branchName',
            'protection_levels': 'protectionLevels'
        }
        self._branch_name = None
        self._protection_levels = None

    @property
    def branch_name(self):
        """
        **[Required]** Gets the branch_name of this CreateOrUpdateProtectedBranchDetails.
        The branchName can either be exact branch name or branch pattern.


        :return: The branch_name of this CreateOrUpdateProtectedBranchDetails.
        :rtype: str
        """
        return self._branch_name

    @branch_name.setter
    def branch_name(self, branch_name):
        """
        Sets the branch_name of this CreateOrUpdateProtectedBranchDetails.
        The branchName can either be exact branch name or branch pattern.


        :param branch_name: The branch_name of this CreateOrUpdateProtectedBranchDetails.
        :type: str
        """
        self._branch_name = branch_name

    @property
    def protection_levels(self):
        """
        Gets the protection_levels of this CreateOrUpdateProtectedBranchDetails.
        Level of protection to add on a branch.

        Allowed values for items in this list are: "READ_ONLY", "PULL_REQUEST_MERGE_ONLY"


        :return: The protection_levels of this CreateOrUpdateProtectedBranchDetails.
        :rtype: list[str]
        """
        return self._protection_levels

    @protection_levels.setter
    def protection_levels(self, protection_levels):
        """
        Sets the protection_levels of this CreateOrUpdateProtectedBranchDetails.
        Level of protection to add on a branch.


        :param protection_levels: The protection_levels of this CreateOrUpdateProtectedBranchDetails.
        :type: list[str]
        """
        allowed_values = ["READ_ONLY", "PULL_REQUEST_MERGE_ONLY"]

        if protection_levels and protection_levels is not NONE_SENTINEL:
            for value in protection_levels:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `protection_levels`, must be None or one of {allowed_values}"
                    )
        self._protection_levels = protection_levels

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
