# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConnectionSummary(object):
    """
    Summary information for a connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConnectionSummary object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.devops.models.BitbucketCloudAppPasswordConnectionSummary`
        * :class:`~oci.devops.models.VbsAccessTokenConnectionSummary`
        * :class:`~oci.devops.models.GithubAccessTokenConnectionSummary`
        * :class:`~oci.devops.models.GitlabAccessTokenConnectionSummary`
        * :class:`~oci.devops.models.BitbucketServerTokenConnectionSummary`
        * :class:`~oci.devops.models.GitlabServerAccessTokenConnectionSummary`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ConnectionSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ConnectionSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this ConnectionSummary.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ConnectionSummary.
        :type compartment_id: str

        :param project_id:
            The value to assign to the project_id property of this ConnectionSummary.
        :type project_id: str

        :param connection_type:
            The value to assign to the connection_type property of this ConnectionSummary.
        :type connection_type: str

        :param time_created:
            The value to assign to the time_created property of this ConnectionSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ConnectionSummary.
        :type time_updated: datetime

        :param last_connection_validation_result:
            The value to assign to the last_connection_validation_result property of this ConnectionSummary.
        :type last_connection_validation_result: oci.devops.models.ConnectionValidationResult

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ConnectionSummary.
        :type lifecycle_details: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ConnectionSummary.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ConnectionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ConnectionSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ConnectionSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'project_id': 'str',
            'connection_type': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'last_connection_validation_result': 'ConnectionValidationResult',
            'lifecycle_details': 'str',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'project_id': 'projectId',
            'connection_type': 'connectionType',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'last_connection_validation_result': 'lastConnectionValidationResult',
            'lifecycle_details': 'lifecycleDetails',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._project_id = None
        self._connection_type = None
        self._time_created = None
        self._time_updated = None
        self._last_connection_validation_result = None
        self._lifecycle_details = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['connectionType']

        if type == 'BITBUCKET_CLOUD_APP_PASSWORD':
            return 'BitbucketCloudAppPasswordConnectionSummary'

        if type == 'VBS_ACCESS_TOKEN':
            return 'VbsAccessTokenConnectionSummary'

        if type == 'GITHUB_ACCESS_TOKEN':
            return 'GithubAccessTokenConnectionSummary'

        if type == 'GITLAB_ACCESS_TOKEN':
            return 'GitlabAccessTokenConnectionSummary'

        if type == 'BITBUCKET_SERVER_ACCESS_TOKEN':
            return 'BitbucketServerTokenConnectionSummary'

        if type == 'GITLAB_SERVER_ACCESS_TOKEN':
            return 'GitlabServerAccessTokenConnectionSummary'
        else:
            return 'ConnectionSummary'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ConnectionSummary.
        Unique identifier that is immutable on creation.


        :return: The id of this ConnectionSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ConnectionSummary.
        Unique identifier that is immutable on creation.


        :param id: The id of this ConnectionSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this ConnectionSummary.
        Connection display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.


        :return: The display_name of this ConnectionSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ConnectionSummary.
        Connection display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.


        :param display_name: The display_name of this ConnectionSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this ConnectionSummary.
        Optional description about the connection.


        :return: The description of this ConnectionSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ConnectionSummary.
        Optional description about the connection.


        :param description: The description of this ConnectionSummary.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ConnectionSummary.
        The OCID of the compartment containing the connection.


        :return: The compartment_id of this ConnectionSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ConnectionSummary.
        The OCID of the compartment containing the connection.


        :param compartment_id: The compartment_id of this ConnectionSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this ConnectionSummary.
        The OCID of the DevOps project.


        :return: The project_id of this ConnectionSummary.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this ConnectionSummary.
        The OCID of the DevOps project.


        :param project_id: The project_id of this ConnectionSummary.
        :type: str
        """
        self._project_id = project_id

    @property
    def connection_type(self):
        """
        **[Required]** Gets the connection_type of this ConnectionSummary.
        The type of connection.


        :return: The connection_type of this ConnectionSummary.
        :rtype: str
        """
        return self._connection_type

    @connection_type.setter
    def connection_type(self, connection_type):
        """
        Sets the connection_type of this ConnectionSummary.
        The type of connection.


        :param connection_type: The connection_type of this ConnectionSummary.
        :type: str
        """
        self._connection_type = connection_type

    @property
    def time_created(self):
        """
        Gets the time_created of this ConnectionSummary.
        The time the connection was created. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this ConnectionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ConnectionSummary.
        The time the connection was created. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this ConnectionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ConnectionSummary.
        The time the connection was updated. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_updated of this ConnectionSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ConnectionSummary.
        The time the connection was updated. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_updated: The time_updated of this ConnectionSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def last_connection_validation_result(self):
        """
        Gets the last_connection_validation_result of this ConnectionSummary.

        :return: The last_connection_validation_result of this ConnectionSummary.
        :rtype: oci.devops.models.ConnectionValidationResult
        """
        return self._last_connection_validation_result

    @last_connection_validation_result.setter
    def last_connection_validation_result(self, last_connection_validation_result):
        """
        Sets the last_connection_validation_result of this ConnectionSummary.

        :param last_connection_validation_result: The last_connection_validation_result of this ConnectionSummary.
        :type: oci.devops.models.ConnectionValidationResult
        """
        self._last_connection_validation_result = last_connection_validation_result

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ConnectionSummary.
        A detailed message describing the current state. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this ConnectionSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ConnectionSummary.
        A detailed message describing the current state. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this ConnectionSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ConnectionSummary.
        The current state of the connection.


        :return: The lifecycle_state of this ConnectionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ConnectionSummary.
        The current state of the connection.


        :param lifecycle_state: The lifecycle_state of this ConnectionSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ConnectionSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ConnectionSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ConnectionSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ConnectionSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ConnectionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ConnectionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ConnectionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ConnectionSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ConnectionSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces. See `Resource Tags`__. Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this ConnectionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ConnectionSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces. See `Resource Tags`__. Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this ConnectionSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
