# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleDbAwsIdentityConnectorSummary(object):
    """
    Oracle DB AWS Identity Connector resource summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OracleDbAwsIdentityConnectorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OracleDbAwsIdentityConnectorSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this OracleDbAwsIdentityConnectorSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleDbAwsIdentityConnectorSummary.
        :type compartment_id: str

        :param resource_id:
            The value to assign to the resource_id property of this OracleDbAwsIdentityConnectorSummary.
        :type resource_id: str

        :param issuer_url:
            The value to assign to the issuer_url property of this OracleDbAwsIdentityConnectorSummary.
        :type issuer_url: str

        :param oidc_scope:
            The value to assign to the oidc_scope property of this OracleDbAwsIdentityConnectorSummary.
        :type oidc_scope: str

        :param service_role_details:
            The value to assign to the service_role_details property of this OracleDbAwsIdentityConnectorSummary.
        :type service_role_details: list[oci.dbmulticloud.models.ServiceRoleDetails]

        :param aws_location:
            The value to assign to the aws_location property of this OracleDbAwsIdentityConnectorSummary.
        :type aws_location: str

        :param aws_sts_private_endpoint:
            The value to assign to the aws_sts_private_endpoint property of this OracleDbAwsIdentityConnectorSummary.
        :type aws_sts_private_endpoint: str

        :param aws_account_id:
            The value to assign to the aws_account_id property of this OracleDbAwsIdentityConnectorSummary.
        :type aws_account_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OracleDbAwsIdentityConnectorSummary.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this OracleDbAwsIdentityConnectorSummary.
        :type lifecycle_state_details: str

        :param time_created:
            The value to assign to the time_created property of this OracleDbAwsIdentityConnectorSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OracleDbAwsIdentityConnectorSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleDbAwsIdentityConnectorSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleDbAwsIdentityConnectorSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OracleDbAwsIdentityConnectorSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'resource_id': 'str',
            'issuer_url': 'str',
            'oidc_scope': 'str',
            'service_role_details': 'list[ServiceRoleDetails]',
            'aws_location': 'str',
            'aws_sts_private_endpoint': 'str',
            'aws_account_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'resource_id': 'resourceId',
            'issuer_url': 'issuerUrl',
            'oidc_scope': 'oidcScope',
            'service_role_details': 'serviceRoleDetails',
            'aws_location': 'awsLocation',
            'aws_sts_private_endpoint': 'awsStsPrivateEndpoint',
            'aws_account_id': 'awsAccountId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._resource_id = None
        self._issuer_url = None
        self._oidc_scope = None
        self._service_role_details = None
        self._aws_location = None
        self._aws_sts_private_endpoint = None
        self._aws_account_id = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        Gets the id of this OracleDbAwsIdentityConnectorSummary.
        The `OCID`__ of the Oracle DB AWS Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OracleDbAwsIdentityConnectorSummary.
        The `OCID`__ of the Oracle DB AWS Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this OracleDbAwsIdentityConnectorSummary.
        Oracle DB AWS Identity Connector resource name.


        :return: The display_name of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OracleDbAwsIdentityConnectorSummary.
        Oracle DB AWS Identity Connector resource name.


        :param display_name: The display_name of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this OracleDbAwsIdentityConnectorSummary.
        The `OCID`__ of the compartment that contains Oracle DB Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OracleDbAwsIdentityConnectorSummary.
        The `OCID`__ of the compartment that contains Oracle DB Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_id(self):
        """
        Gets the resource_id of this OracleDbAwsIdentityConnectorSummary.
        The `OCID`__ of the AWS VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this OracleDbAwsIdentityConnectorSummary.
        The `OCID`__ of the AWS VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def issuer_url(self):
        """
        Gets the issuer_url of this OracleDbAwsIdentityConnectorSummary.
        OIDC token issuer Url.


        :return: The issuer_url of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._issuer_url

    @issuer_url.setter
    def issuer_url(self, issuer_url):
        """
        Sets the issuer_url of this OracleDbAwsIdentityConnectorSummary.
        OIDC token issuer Url.


        :param issuer_url: The issuer_url of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._issuer_url = issuer_url

    @property
    def oidc_scope(self):
        """
        Gets the oidc_scope of this OracleDbAwsIdentityConnectorSummary.
        OCI IAM Domain scope for issuer URL.


        :return: The oidc_scope of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._oidc_scope

    @oidc_scope.setter
    def oidc_scope(self, oidc_scope):
        """
        Sets the oidc_scope of this OracleDbAwsIdentityConnectorSummary.
        OCI IAM Domain scope for issuer URL.


        :param oidc_scope: The oidc_scope of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._oidc_scope = oidc_scope

    @property
    def service_role_details(self):
        """
        Gets the service_role_details of this OracleDbAwsIdentityConnectorSummary.
        Service role details and respective Amazon resource nam of Role.


        :return: The service_role_details of this OracleDbAwsIdentityConnectorSummary.
        :rtype: list[oci.dbmulticloud.models.ServiceRoleDetails]
        """
        return self._service_role_details

    @service_role_details.setter
    def service_role_details(self, service_role_details):
        """
        Sets the service_role_details of this OracleDbAwsIdentityConnectorSummary.
        Service role details and respective Amazon resource nam of Role.


        :param service_role_details: The service_role_details of this OracleDbAwsIdentityConnectorSummary.
        :type: list[oci.dbmulticloud.models.ServiceRoleDetails]
        """
        self._service_role_details = service_role_details

    @property
    def aws_location(self):
        """
        Gets the aws_location of this OracleDbAwsIdentityConnectorSummary.
        AWS resource location.


        :return: The aws_location of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._aws_location

    @aws_location.setter
    def aws_location(self, aws_location):
        """
        Sets the aws_location of this OracleDbAwsIdentityConnectorSummary.
        AWS resource location.


        :param aws_location: The aws_location of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._aws_location = aws_location

    @property
    def aws_sts_private_endpoint(self):
        """
        Gets the aws_sts_private_endpoint of this OracleDbAwsIdentityConnectorSummary.
        Private endpoint of AWS Security Token Service.


        :return: The aws_sts_private_endpoint of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._aws_sts_private_endpoint

    @aws_sts_private_endpoint.setter
    def aws_sts_private_endpoint(self, aws_sts_private_endpoint):
        """
        Sets the aws_sts_private_endpoint of this OracleDbAwsIdentityConnectorSummary.
        Private endpoint of AWS Security Token Service.


        :param aws_sts_private_endpoint: The aws_sts_private_endpoint of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._aws_sts_private_endpoint = aws_sts_private_endpoint

    @property
    def aws_account_id(self):
        """
        Gets the aws_account_id of this OracleDbAwsIdentityConnectorSummary.
        AWS Account ID.


        :return: The aws_account_id of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._aws_account_id

    @aws_account_id.setter
    def aws_account_id(self, aws_account_id):
        """
        Sets the aws_account_id of this OracleDbAwsIdentityConnectorSummary.
        AWS Account ID.


        :param aws_account_id: The aws_account_id of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._aws_account_id = aws_account_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this OracleDbAwsIdentityConnectorSummary.
        The current lifecycle state of the AWS Identity Connector resource.


        :return: The lifecycle_state of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OracleDbAwsIdentityConnectorSummary.
        The current lifecycle state of the AWS Identity Connector resource.


        :param lifecycle_state: The lifecycle_state of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this OracleDbAwsIdentityConnectorSummary.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this OracleDbAwsIdentityConnectorSummary.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this OracleDbAwsIdentityConnectorSummary.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this OracleDbAwsIdentityConnectorSummary.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def time_created(self):
        """
        Gets the time_created of this OracleDbAwsIdentityConnectorSummary.
        Time when the Oracle DB AWS Identity Connector resource was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this OracleDbAwsIdentityConnectorSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OracleDbAwsIdentityConnectorSummary.
        Time when the Oracle DB AWS Identity Connector resource was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this OracleDbAwsIdentityConnectorSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this OracleDbAwsIdentityConnectorSummary.
        Time when the Oracle DB AWS Identity Connector resource was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this OracleDbAwsIdentityConnectorSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OracleDbAwsIdentityConnectorSummary.
        Time when the Oracle DB AWS Identity Connector resource was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this OracleDbAwsIdentityConnectorSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OracleDbAwsIdentityConnectorSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this OracleDbAwsIdentityConnectorSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OracleDbAwsIdentityConnectorSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this OracleDbAwsIdentityConnectorSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OracleDbAwsIdentityConnectorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this OracleDbAwsIdentityConnectorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OracleDbAwsIdentityConnectorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this OracleDbAwsIdentityConnectorSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OracleDbAwsIdentityConnectorSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OracleDbAwsIdentityConnectorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OracleDbAwsIdentityConnectorSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OracleDbAwsIdentityConnectorSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
