# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdditionalPatches(object):
    """
    Summary of patch recommendations for image.
    """

    #: A constant which can be used with the category property of a AdditionalPatches.
    #: This constant has a value of "RECOMMENDED"
    CATEGORY_RECOMMENDED = "RECOMMENDED"

    #: A constant which can be used with the category property of a AdditionalPatches.
    #: This constant has a value of "ADDITIONAL_PATCH"
    CATEGORY_ADDITIONAL_PATCH = "ADDITIONAL_PATCH"

    def __init__(self, **kwargs):
        """
        Initializes a new AdditionalPatches object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param patch_id:
            The value to assign to the patch_id property of this AdditionalPatches.
        :type patch_id: int

        :param patch_name:
            The value to assign to the patch_name property of this AdditionalPatches.
        :type patch_name: str

        :param description:
            The value to assign to the description property of this AdditionalPatches.
        :type description: str

        :param category:
            The value to assign to the category property of this AdditionalPatches.
            Allowed values for this property are: "RECOMMENDED", "ADDITIONAL_PATCH", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type category: str

        """
        self.swagger_types = {
            'patch_id': 'int',
            'patch_name': 'str',
            'description': 'str',
            'category': 'str'
        }
        self.attribute_map = {
            'patch_id': 'patchId',
            'patch_name': 'patchName',
            'description': 'description',
            'category': 'category'
        }
        self._patch_id = None
        self._patch_name = None
        self._description = None
        self._category = None

    @property
    def patch_id(self):
        """
        Gets the patch_id of this AdditionalPatches.
        Id for the patch recommendation.


        :return: The patch_id of this AdditionalPatches.
        :rtype: int
        """
        return self._patch_id

    @patch_id.setter
    def patch_id(self, patch_id):
        """
        Sets the patch_id of this AdditionalPatches.
        Id for the patch recommendation.


        :param patch_id: The patch_id of this AdditionalPatches.
        :type: int
        """
        self._patch_id = patch_id

    @property
    def patch_name(self):
        """
        Gets the patch_name of this AdditionalPatches.
        Name for the patch recommendation.


        :return: The patch_name of this AdditionalPatches.
        :rtype: str
        """
        return self._patch_name

    @patch_name.setter
    def patch_name(self, patch_name):
        """
        Sets the patch_name of this AdditionalPatches.
        Name for the patch recommendation.


        :param patch_name: The patch_name of this AdditionalPatches.
        :type: str
        """
        self._patch_name = patch_name

    @property
    def description(self):
        """
        Gets the description of this AdditionalPatches.
        Description of the patch recommendation.


        :return: The description of this AdditionalPatches.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AdditionalPatches.
        Description of the patch recommendation.


        :param description: The description of this AdditionalPatches.
        :type: str
        """
        self._description = description

    @property
    def category(self):
        """
        Gets the category of this AdditionalPatches.
        Shows if patch is recommended or is an additional patch from an existing database.

        Allowed values for this property are: "RECOMMENDED", "ADDITIONAL_PATCH", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The category of this AdditionalPatches.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this AdditionalPatches.
        Shows if patch is recommended or is an additional patch from an existing database.


        :param category: The category of this AdditionalPatches.
        :type: str
        """
        allowed_values = ["RECOMMENDED", "ADDITIONAL_PATCH"]
        if not value_allowed_none_or_none_sentinel(category, allowed_values):
            category = 'UNKNOWN_ENUM_VALUE'
        self._category = category

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
