# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDatabaseToolsIdentityDetails(object):
    """
    Details for the new Database Tools identity.
    """

    #: A constant which can be used with the type property of a CreateDatabaseToolsIdentityDetails.
    #: This constant has a value of "ORACLE_DATABASE_RESOURCE_PRINCIPAL"
    TYPE_ORACLE_DATABASE_RESOURCE_PRINCIPAL = "ORACLE_DATABASE_RESOURCE_PRINCIPAL"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDatabaseToolsIdentityDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_tools.models.CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CreateDatabaseToolsIdentityDetails.
            Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL"
        :type type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDatabaseToolsIdentityDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateDatabaseToolsIdentityDetails.
        :type display_name: str

        :param database_tools_connection_id:
            The value to assign to the database_tools_connection_id property of this CreateDatabaseToolsIdentityDetails.
        :type database_tools_connection_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDatabaseToolsIdentityDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDatabaseToolsIdentityDetails.
        :type freeform_tags: dict(str, str)

        :param locks:
            The value to assign to the locks property of this CreateDatabaseToolsIdentityDetails.
        :type locks: list[oci.database_tools.models.ResourceLock]

        """
        self.swagger_types = {
            'type': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'database_tools_connection_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'locks': 'list[ResourceLock]'
        }
        self.attribute_map = {
            'type': 'type',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'database_tools_connection_id': 'databaseToolsConnectionId',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'locks': 'locks'
        }
        self._type = None
        self._compartment_id = None
        self._display_name = None
        self._database_tools_connection_id = None
        self._defined_tags = None
        self._freeform_tags = None
        self._locks = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'ORACLE_DATABASE_RESOURCE_PRINCIPAL':
            return 'CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails'
        else:
            return 'CreateDatabaseToolsIdentityDetails'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateDatabaseToolsIdentityDetails.
        The Database Tools identity type.

        Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL"


        :return: The type of this CreateDatabaseToolsIdentityDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateDatabaseToolsIdentityDetails.
        The Database Tools identity type.


        :param type: The type of this CreateDatabaseToolsIdentityDetails.
        :type: str
        """
        allowed_values = ["ORACLE_DATABASE_RESOURCE_PRINCIPAL"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDatabaseToolsIdentityDetails.
        The `OCID`__ of the compartment containing the Database Tools identity.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateDatabaseToolsIdentityDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDatabaseToolsIdentityDetails.
        The `OCID`__ of the compartment containing the Database Tools identity.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateDatabaseToolsIdentityDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateDatabaseToolsIdentityDetails.
        A user-friendly name. Does not have to be unique and can be updated. Avoid entering confidential information.


        :return: The display_name of this CreateDatabaseToolsIdentityDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDatabaseToolsIdentityDetails.
        A user-friendly name. Does not have to be unique and can be updated. Avoid entering confidential information.


        :param display_name: The display_name of this CreateDatabaseToolsIdentityDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def database_tools_connection_id(self):
        """
        **[Required]** Gets the database_tools_connection_id of this CreateDatabaseToolsIdentityDetails.
        The `OCID`__ of the related Database Tools connection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The database_tools_connection_id of this CreateDatabaseToolsIdentityDetails.
        :rtype: str
        """
        return self._database_tools_connection_id

    @database_tools_connection_id.setter
    def database_tools_connection_id(self, database_tools_connection_id):
        """
        Sets the database_tools_connection_id of this CreateDatabaseToolsIdentityDetails.
        The `OCID`__ of the related Database Tools connection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param database_tools_connection_id: The database_tools_connection_id of this CreateDatabaseToolsIdentityDetails.
        :type: str
        """
        self._database_tools_connection_id = database_tools_connection_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDatabaseToolsIdentityDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateDatabaseToolsIdentityDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDatabaseToolsIdentityDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateDatabaseToolsIdentityDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDatabaseToolsIdentityDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateDatabaseToolsIdentityDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDatabaseToolsIdentityDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateDatabaseToolsIdentityDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def locks(self):
        """
        Gets the locks of this CreateDatabaseToolsIdentityDetails.
        Locks associated with this resource.


        :return: The locks of this CreateDatabaseToolsIdentityDetails.
        :rtype: list[oci.database_tools.models.ResourceLock]
        """
        return self._locks

    @locks.setter
    def locks(self, locks):
        """
        Sets the locks of this CreateDatabaseToolsIdentityDetails.
        Locks associated with this resource.


        :param locks: The locks of this CreateDatabaseToolsIdentityDetails.
        :type: list[oci.database_tools.models.ResourceLock]
        """
        self._locks = locks

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
