# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlFleetByCategory(object):
    """
    The number of MySQL Databases in the fleet, grouped by database type and sub type.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlFleetByCategory object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_type:
            The value to assign to the database_type property of this MySqlFleetByCategory.
        :type database_type: str

        :param mds_deployment_type:
            The value to assign to the mds_deployment_type property of this MySqlFleetByCategory.
        :type mds_deployment_type: str

        :param inventory_count:
            The value to assign to the inventory_count property of this MySqlFleetByCategory.
        :type inventory_count: int

        """
        self.swagger_types = {
            'database_type': 'str',
            'mds_deployment_type': 'str',
            'inventory_count': 'int'
        }
        self.attribute_map = {
            'database_type': 'databaseType',
            'mds_deployment_type': 'mdsDeploymentType',
            'inventory_count': 'inventoryCount'
        }
        self._database_type = None
        self._mds_deployment_type = None
        self._inventory_count = None

    @property
    def database_type(self):
        """
        **[Required]** Gets the database_type of this MySqlFleetByCategory.
        The type of the MySQL Database. Indicates whether the database is on premises or Oracle Cloud. Allowed values are: MDS and ONPREMISE


        :return: The database_type of this MySqlFleetByCategory.
        :rtype: str
        """
        return self._database_type

    @database_type.setter
    def database_type(self, database_type):
        """
        Sets the database_type of this MySqlFleetByCategory.
        The type of the MySQL Database. Indicates whether the database is on premises or Oracle Cloud. Allowed values are: MDS and ONPREMISE


        :param database_type: The database_type of this MySqlFleetByCategory.
        :type: str
        """
        self._database_type = database_type

    @property
    def mds_deployment_type(self):
        """
        **[Required]** Gets the mds_deployment_type of this MySqlFleetByCategory.
        The type of MySQL Database installation. Allowed values are: STANDALONE, HEATWAVE and HA


        :return: The mds_deployment_type of this MySqlFleetByCategory.
        :rtype: str
        """
        return self._mds_deployment_type

    @mds_deployment_type.setter
    def mds_deployment_type(self, mds_deployment_type):
        """
        Sets the mds_deployment_type of this MySqlFleetByCategory.
        The type of MySQL Database installation. Allowed values are: STANDALONE, HEATWAVE and HA


        :param mds_deployment_type: The mds_deployment_type of this MySqlFleetByCategory.
        :type: str
        """
        self._mds_deployment_type = mds_deployment_type

    @property
    def inventory_count(self):
        """
        **[Required]** Gets the inventory_count of this MySqlFleetByCategory.
        The number of MySQL Databases.


        :return: The inventory_count of this MySqlFleetByCategory.
        :rtype: int
        """
        return self._inventory_count

    @inventory_count.setter
    def inventory_count(self, inventory_count):
        """
        Sets the inventory_count of this MySqlFleetByCategory.
        The number of MySQL Databases.


        :param inventory_count: The inventory_count of this MySqlFleetByCategory.
        :type: int
        """
        self._inventory_count = inventory_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
