# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalMySqlDatabaseSummary(object):
    """
    External database summary record.
    """

    #: A constant which can be used with the deployment_type property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "ONPREMISE"
    DEPLOYMENT_TYPE_ONPREMISE = "ONPREMISE"

    #: A constant which can be used with the deployment_type property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "MDS"
    DEPLOYMENT_TYPE_MDS = "MDS"

    #: A constant which can be used with the management_state property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "ENABLED"
    MANAGEMENT_STATE_ENABLED = "ENABLED"

    #: A constant which can be used with the management_state property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "DISABLED"
    MANAGEMENT_STATE_DISABLED = "DISABLED"

    #: A constant which can be used with the lifecycle_state property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ExternalMySqlDatabaseSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalMySqlDatabaseSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this ExternalMySqlDatabaseSummary.
        :type compartment_id: str

        :param external_database_id:
            The value to assign to the external_database_id property of this ExternalMySqlDatabaseSummary.
        :type external_database_id: str

        :param connector_id:
            The value to assign to the connector_id property of this ExternalMySqlDatabaseSummary.
        :type connector_id: str

        :param db_name:
            The value to assign to the db_name property of this ExternalMySqlDatabaseSummary.
        :type db_name: str

        :param deployment_type:
            The value to assign to the deployment_type property of this ExternalMySqlDatabaseSummary.
            Allowed values for this property are: "ONPREMISE", "MDS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type deployment_type: str

        :param management_state:
            The value to assign to the management_state property of this ExternalMySqlDatabaseSummary.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type management_state: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ExternalMySqlDatabaseSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param system_tags:
            The value to assign to the system_tags property of this ExternalMySqlDatabaseSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'external_database_id': 'str',
            'connector_id': 'str',
            'db_name': 'str',
            'deployment_type': 'str',
            'management_state': 'str',
            'lifecycle_state': 'str',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'external_database_id': 'externalDatabaseId',
            'connector_id': 'connectorId',
            'db_name': 'dbName',
            'deployment_type': 'deploymentType',
            'management_state': 'managementState',
            'lifecycle_state': 'lifecycleState',
            'system_tags': 'systemTags'
        }
        self._compartment_id = None
        self._external_database_id = None
        self._connector_id = None
        self._db_name = None
        self._deployment_type = None
        self._management_state = None
        self._lifecycle_state = None
        self._system_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ExternalMySqlDatabaseSummary.
        OCID of compartment for the External MySQL Database.


        :return: The compartment_id of this ExternalMySqlDatabaseSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ExternalMySqlDatabaseSummary.
        OCID of compartment for the External MySQL Database.


        :param compartment_id: The compartment_id of this ExternalMySqlDatabaseSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def external_database_id(self):
        """
        Gets the external_database_id of this ExternalMySqlDatabaseSummary.
        OCID of External MySQL Database.


        :return: The external_database_id of this ExternalMySqlDatabaseSummary.
        :rtype: str
        """
        return self._external_database_id

    @external_database_id.setter
    def external_database_id(self, external_database_id):
        """
        Sets the external_database_id of this ExternalMySqlDatabaseSummary.
        OCID of External MySQL Database.


        :param external_database_id: The external_database_id of this ExternalMySqlDatabaseSummary.
        :type: str
        """
        self._external_database_id = external_database_id

    @property
    def connector_id(self):
        """
        Gets the connector_id of this ExternalMySqlDatabaseSummary.
        The OCID of the enabled MySQL Database Connector.


        :return: The connector_id of this ExternalMySqlDatabaseSummary.
        :rtype: str
        """
        return self._connector_id

    @connector_id.setter
    def connector_id(self, connector_id):
        """
        Sets the connector_id of this ExternalMySqlDatabaseSummary.
        The OCID of the enabled MySQL Database Connector.


        :param connector_id: The connector_id of this ExternalMySqlDatabaseSummary.
        :type: str
        """
        self._connector_id = connector_id

    @property
    def db_name(self):
        """
        **[Required]** Gets the db_name of this ExternalMySqlDatabaseSummary.
        Display name of the External MySQL Database.


        :return: The db_name of this ExternalMySqlDatabaseSummary.
        :rtype: str
        """
        return self._db_name

    @db_name.setter
    def db_name(self, db_name):
        """
        Sets the db_name of this ExternalMySqlDatabaseSummary.
        Display name of the External MySQL Database.


        :param db_name: The db_name of this ExternalMySqlDatabaseSummary.
        :type: str
        """
        self._db_name = db_name

    @property
    def deployment_type(self):
        """
        Gets the deployment_type of this ExternalMySqlDatabaseSummary.
        The deployment type of the Mysql Database.

        Allowed values for this property are: "ONPREMISE", "MDS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The deployment_type of this ExternalMySqlDatabaseSummary.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this ExternalMySqlDatabaseSummary.
        The deployment type of the Mysql Database.


        :param deployment_type: The deployment_type of this ExternalMySqlDatabaseSummary.
        :type: str
        """
        allowed_values = ["ONPREMISE", "MDS"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            deployment_type = 'UNKNOWN_ENUM_VALUE'
        self._deployment_type = deployment_type

    @property
    def management_state(self):
        """
        Gets the management_state of this ExternalMySqlDatabaseSummary.
        Indicates database management state.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The management_state of this ExternalMySqlDatabaseSummary.
        :rtype: str
        """
        return self._management_state

    @management_state.setter
    def management_state(self, management_state):
        """
        Sets the management_state of this ExternalMySqlDatabaseSummary.
        Indicates database management state.


        :param management_state: The management_state of this ExternalMySqlDatabaseSummary.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(management_state, allowed_values):
            management_state = 'UNKNOWN_ENUM_VALUE'
        self._management_state = management_state

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ExternalMySqlDatabaseSummary.
        Indicates lifecycle  state of the resource.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ExternalMySqlDatabaseSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ExternalMySqlDatabaseSummary.
        Indicates lifecycle  state of the resource.


        :param lifecycle_state: The lifecycle_state of this ExternalMySqlDatabaseSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ExternalMySqlDatabaseSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this ExternalMySqlDatabaseSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ExternalMySqlDatabaseSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this ExternalMySqlDatabaseSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
