# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseFleetDataguardMetrics(object):
    """
    The list of Oracle Data Guard-enabled databases in the fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseFleetDataguardMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param dataguard_metrics:
            The value to assign to the dataguard_metrics property of this DatabaseFleetDataguardMetrics.
        :type dataguard_metrics: list[oci.database_management.models.DataguardMetrics]

        """
        self.swagger_types = {
            'dataguard_metrics': 'list[DataguardMetrics]'
        }
        self.attribute_map = {
            'dataguard_metrics': 'dataguardMetrics'
        }
        self._dataguard_metrics = None

    @property
    def dataguard_metrics(self):
        """
        **[Required]** Gets the dataguard_metrics of this DatabaseFleetDataguardMetrics.
        The Data Guard usage metrics for the Oracle Data Guard-enabled databases.


        :return: The dataguard_metrics of this DatabaseFleetDataguardMetrics.
        :rtype: list[oci.database_management.models.DataguardMetrics]
        """
        return self._dataguard_metrics

    @dataguard_metrics.setter
    def dataguard_metrics(self, dataguard_metrics):
        """
        Sets the dataguard_metrics of this DatabaseFleetDataguardMetrics.
        The Data Guard usage metrics for the Oracle Data Guard-enabled databases.


        :param dataguard_metrics: The dataguard_metrics of this DatabaseFleetDataguardMetrics.
        :type: list[oci.database_management.models.DataguardMetrics]
        """
        self._dataguard_metrics = dataguard_metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
