# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MountPointDetails(object):
    """
    Details of the Mount Point.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MountPointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this MountPointDetails.
        :type name: str

        :param db_node_id:
            The value to assign to the db_node_id property of this MountPointDetails.
        :type db_node_id: str

        """
        self.swagger_types = {
            'name': 'str',
            'db_node_id': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'db_node_id': 'dbNodeId'
        }
        self._name = None
        self._db_node_id = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this MountPointDetails.
        Mount Point Name


        :return: The name of this MountPointDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MountPointDetails.
        Mount Point Name


        :param name: The name of this MountPointDetails.
        :type: str
        """
        self._name = name

    @property
    def db_node_id(self):
        """
        **[Required]** Gets the db_node_id of this MountPointDetails.
        The `OCID`__ of the Exadata Database Node where snapshot was mounted.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_node_id of this MountPointDetails.
        :rtype: str
        """
        return self._db_node_id

    @db_node_id.setter
    def db_node_id(self, db_node_id):
        """
        Sets the db_node_id of this MountPointDetails.
        The `OCID`__ of the Exadata Database Node where snapshot was mounted.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_node_id: The db_node_id of this MountPointDetails.
        :type: str
        """
        self._db_node_id = db_node_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
