# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaintenanceRunHistorySummary(object):
    """
    Details of a maintenance run history.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MaintenanceRunHistorySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MaintenanceRunHistorySummary.
        :type id: str

        :param maintenance_run_details:
            The value to assign to the maintenance_run_details property of this MaintenanceRunHistorySummary.
        :type maintenance_run_details: oci.database.models.MaintenanceRunSummary

        :param db_servers_history_details:
            The value to assign to the db_servers_history_details property of this MaintenanceRunHistorySummary.
        :type db_servers_history_details: list[oci.database.models.DbServerHistorySummary]

        :param current_execution_window:
            The value to assign to the current_execution_window property of this MaintenanceRunHistorySummary.
        :type current_execution_window: str

        :param granular_maintenance_history:
            The value to assign to the granular_maintenance_history property of this MaintenanceRunHistorySummary.
        :type granular_maintenance_history: list[oci.database.models.GranularMaintenanceHistoryDetails]

        :param system_tags:
            The value to assign to the system_tags property of this MaintenanceRunHistorySummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'maintenance_run_details': 'MaintenanceRunSummary',
            'db_servers_history_details': 'list[DbServerHistorySummary]',
            'current_execution_window': 'str',
            'granular_maintenance_history': 'list[GranularMaintenanceHistoryDetails]',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'maintenance_run_details': 'maintenanceRunDetails',
            'db_servers_history_details': 'dbServersHistoryDetails',
            'current_execution_window': 'currentExecutionWindow',
            'granular_maintenance_history': 'granularMaintenanceHistory',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._maintenance_run_details = None
        self._db_servers_history_details = None
        self._current_execution_window = None
        self._granular_maintenance_history = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this MaintenanceRunHistorySummary.
        The OCID of the maintenance run history.


        :return: The id of this MaintenanceRunHistorySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MaintenanceRunHistorySummary.
        The OCID of the maintenance run history.


        :param id: The id of this MaintenanceRunHistorySummary.
        :type: str
        """
        self._id = id

    @property
    def maintenance_run_details(self):
        """
        Gets the maintenance_run_details of this MaintenanceRunHistorySummary.

        :return: The maintenance_run_details of this MaintenanceRunHistorySummary.
        :rtype: oci.database.models.MaintenanceRunSummary
        """
        return self._maintenance_run_details

    @maintenance_run_details.setter
    def maintenance_run_details(self, maintenance_run_details):
        """
        Sets the maintenance_run_details of this MaintenanceRunHistorySummary.

        :param maintenance_run_details: The maintenance_run_details of this MaintenanceRunHistorySummary.
        :type: oci.database.models.MaintenanceRunSummary
        """
        self._maintenance_run_details = maintenance_run_details

    @property
    def db_servers_history_details(self):
        """
        Gets the db_servers_history_details of this MaintenanceRunHistorySummary.
        List of database server history details.


        :return: The db_servers_history_details of this MaintenanceRunHistorySummary.
        :rtype: list[oci.database.models.DbServerHistorySummary]
        """
        return self._db_servers_history_details

    @db_servers_history_details.setter
    def db_servers_history_details(self, db_servers_history_details):
        """
        Sets the db_servers_history_details of this MaintenanceRunHistorySummary.
        List of database server history details.


        :param db_servers_history_details: The db_servers_history_details of this MaintenanceRunHistorySummary.
        :type: list[oci.database.models.DbServerHistorySummary]
        """
        self._db_servers_history_details = db_servers_history_details

    @property
    def current_execution_window(self):
        """
        Gets the current_execution_window of this MaintenanceRunHistorySummary.
        The OCID of the current execution window.


        :return: The current_execution_window of this MaintenanceRunHistorySummary.
        :rtype: str
        """
        return self._current_execution_window

    @current_execution_window.setter
    def current_execution_window(self, current_execution_window):
        """
        Sets the current_execution_window of this MaintenanceRunHistorySummary.
        The OCID of the current execution window.


        :param current_execution_window: The current_execution_window of this MaintenanceRunHistorySummary.
        :type: str
        """
        self._current_execution_window = current_execution_window

    @property
    def granular_maintenance_history(self):
        """
        Gets the granular_maintenance_history of this MaintenanceRunHistorySummary.
        The list of granular maintenance history details.


        :return: The granular_maintenance_history of this MaintenanceRunHistorySummary.
        :rtype: list[oci.database.models.GranularMaintenanceHistoryDetails]
        """
        return self._granular_maintenance_history

    @granular_maintenance_history.setter
    def granular_maintenance_history(self, granular_maintenance_history):
        """
        Sets the granular_maintenance_history of this MaintenanceRunHistorySummary.
        The list of granular maintenance history details.


        :param granular_maintenance_history: The granular_maintenance_history of this MaintenanceRunHistorySummary.
        :type: list[oci.database.models.GranularMaintenanceHistoryDetails]
        """
        self._granular_maintenance_history = granular_maintenance_history

    @property
    def system_tags(self):
        """
        Gets the system_tags of this MaintenanceRunHistorySummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this MaintenanceRunHistorySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this MaintenanceRunHistorySummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this MaintenanceRunHistorySummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
