# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefinedFileSystemConfiguration(object):
    """
    Details of the file system configuration of the Exadata infrastructure.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DefinedFileSystemConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param mount_point:
            The value to assign to the mount_point property of this DefinedFileSystemConfiguration.
        :type mount_point: str

        :param min_size_gb:
            The value to assign to the min_size_gb property of this DefinedFileSystemConfiguration.
        :type min_size_gb: int

        :param is_resizable:
            The value to assign to the is_resizable property of this DefinedFileSystemConfiguration.
        :type is_resizable: bool

        :param is_backup_partition:
            The value to assign to the is_backup_partition property of this DefinedFileSystemConfiguration.
        :type is_backup_partition: bool

        """
        self.swagger_types = {
            'mount_point': 'str',
            'min_size_gb': 'int',
            'is_resizable': 'bool',
            'is_backup_partition': 'bool'
        }
        self.attribute_map = {
            'mount_point': 'mountPoint',
            'min_size_gb': 'minSizeGb',
            'is_resizable': 'isResizable',
            'is_backup_partition': 'isBackupPartition'
        }
        self._mount_point = None
        self._min_size_gb = None
        self._is_resizable = None
        self._is_backup_partition = None

    @property
    def mount_point(self):
        """
        Gets the mount_point of this DefinedFileSystemConfiguration.
        The mount point of file system.


        :return: The mount_point of this DefinedFileSystemConfiguration.
        :rtype: str
        """
        return self._mount_point

    @mount_point.setter
    def mount_point(self, mount_point):
        """
        Sets the mount_point of this DefinedFileSystemConfiguration.
        The mount point of file system.


        :param mount_point: The mount_point of this DefinedFileSystemConfiguration.
        :type: str
        """
        self._mount_point = mount_point

    @property
    def min_size_gb(self):
        """
        Gets the min_size_gb of this DefinedFileSystemConfiguration.
        The minimum size of file system.


        :return: The min_size_gb of this DefinedFileSystemConfiguration.
        :rtype: int
        """
        return self._min_size_gb

    @min_size_gb.setter
    def min_size_gb(self, min_size_gb):
        """
        Sets the min_size_gb of this DefinedFileSystemConfiguration.
        The minimum size of file system.


        :param min_size_gb: The min_size_gb of this DefinedFileSystemConfiguration.
        :type: int
        """
        self._min_size_gb = min_size_gb

    @property
    def is_resizable(self):
        """
        Gets the is_resizable of this DefinedFileSystemConfiguration.
        If true, the file system resize is allowed for the Exadata Infrastructure cluster. If false, the file system resize is not allowed.


        :return: The is_resizable of this DefinedFileSystemConfiguration.
        :rtype: bool
        """
        return self._is_resizable

    @is_resizable.setter
    def is_resizable(self, is_resizable):
        """
        Sets the is_resizable of this DefinedFileSystemConfiguration.
        If true, the file system resize is allowed for the Exadata Infrastructure cluster. If false, the file system resize is not allowed.


        :param is_resizable: The is_resizable of this DefinedFileSystemConfiguration.
        :type: bool
        """
        self._is_resizable = is_resizable

    @property
    def is_backup_partition(self):
        """
        Gets the is_backup_partition of this DefinedFileSystemConfiguration.
        If true, the file system is used to create a backup prior to Exadata VM OS update.


        :return: The is_backup_partition of this DefinedFileSystemConfiguration.
        :rtype: bool
        """
        return self._is_backup_partition

    @is_backup_partition.setter
    def is_backup_partition(self, is_backup_partition):
        """
        Sets the is_backup_partition of this DefinedFileSystemConfiguration.
        If true, the file system is used to create a backup prior to Exadata VM OS update.


        :param is_backup_partition: The is_backup_partition of this DefinedFileSystemConfiguration.
        :type: bool
        """
        self._is_backup_partition = is_backup_partition

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
