# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConvertToRegularPluggableDatabaseDetails(object):
    """
    Parameters for converting Refreshable Clone Pluggable Database into Regular Pluggable Database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConvertToRegularPluggableDatabaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param should_create_pdb_backup:
            The value to assign to the should_create_pdb_backup property of this ConvertToRegularPluggableDatabaseDetails.
        :type should_create_pdb_backup: bool

        :param container_database_admin_password:
            The value to assign to the container_database_admin_password property of this ConvertToRegularPluggableDatabaseDetails.
        :type container_database_admin_password: str

        :param tde_wallet_password:
            The value to assign to the tde_wallet_password property of this ConvertToRegularPluggableDatabaseDetails.
        :type tde_wallet_password: str

        """
        self.swagger_types = {
            'should_create_pdb_backup': 'bool',
            'container_database_admin_password': 'str',
            'tde_wallet_password': 'str'
        }
        self.attribute_map = {
            'should_create_pdb_backup': 'shouldCreatePdbBackup',
            'container_database_admin_password': 'containerDatabaseAdminPassword',
            'tde_wallet_password': 'tdeWalletPassword'
        }
        self._should_create_pdb_backup = None
        self._container_database_admin_password = None
        self._tde_wallet_password = None

    @property
    def should_create_pdb_backup(self):
        """
        Gets the should_create_pdb_backup of this ConvertToRegularPluggableDatabaseDetails.
        Indicates whether to take Pluggable Database Backup after the operation.


        :return: The should_create_pdb_backup of this ConvertToRegularPluggableDatabaseDetails.
        :rtype: bool
        """
        return self._should_create_pdb_backup

    @should_create_pdb_backup.setter
    def should_create_pdb_backup(self, should_create_pdb_backup):
        """
        Sets the should_create_pdb_backup of this ConvertToRegularPluggableDatabaseDetails.
        Indicates whether to take Pluggable Database Backup after the operation.


        :param should_create_pdb_backup: The should_create_pdb_backup of this ConvertToRegularPluggableDatabaseDetails.
        :type: bool
        """
        self._should_create_pdb_backup = should_create_pdb_backup

    @property
    def container_database_admin_password(self):
        """
        Gets the container_database_admin_password of this ConvertToRegularPluggableDatabaseDetails.
        The DB system administrator password of the Container Database.


        :return: The container_database_admin_password of this ConvertToRegularPluggableDatabaseDetails.
        :rtype: str
        """
        return self._container_database_admin_password

    @container_database_admin_password.setter
    def container_database_admin_password(self, container_database_admin_password):
        """
        Sets the container_database_admin_password of this ConvertToRegularPluggableDatabaseDetails.
        The DB system administrator password of the Container Database.


        :param container_database_admin_password: The container_database_admin_password of this ConvertToRegularPluggableDatabaseDetails.
        :type: str
        """
        self._container_database_admin_password = container_database_admin_password

    @property
    def tde_wallet_password(self):
        """
        Gets the tde_wallet_password of this ConvertToRegularPluggableDatabaseDetails.
        The existing TDE wallet password of the Container Database.


        :return: The tde_wallet_password of this ConvertToRegularPluggableDatabaseDetails.
        :rtype: str
        """
        return self._tde_wallet_password

    @tde_wallet_password.setter
    def tde_wallet_password(self, tde_wallet_password):
        """
        Sets the tde_wallet_password of this ConvertToRegularPluggableDatabaseDetails.
        The existing TDE wallet password of the Container Database.


        :param tde_wallet_password: The tde_wallet_password of this ConvertToRegularPluggableDatabaseDetails.
        :type: str
        """
        self._tde_wallet_password = tde_wallet_password

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
