# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .schedule_trigger import ScheduleTrigger
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScheduleCronTrigger(ScheduleTrigger):
    """
    The scheduled UNIX cron definition.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ScheduleCronTrigger object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.ScheduleCronTrigger.trigger_type` attribute
        of this class is ``CRON`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param trigger_type:
            The value to assign to the trigger_type property of this ScheduleCronTrigger.
            Allowed values for this property are: "CRON", "INTERVAL", "ICAL"
        :type trigger_type: str

        :param time_start:
            The value to assign to the time_start property of this ScheduleCronTrigger.
        :type time_start: datetime

        :param time_end:
            The value to assign to the time_end property of this ScheduleCronTrigger.
        :type time_end: datetime

        :param cron_expression:
            The value to assign to the cron_expression property of this ScheduleCronTrigger.
        :type cron_expression: str

        """
        self.swagger_types = {
            'trigger_type': 'str',
            'time_start': 'datetime',
            'time_end': 'datetime',
            'cron_expression': 'str'
        }
        self.attribute_map = {
            'trigger_type': 'triggerType',
            'time_start': 'timeStart',
            'time_end': 'timeEnd',
            'cron_expression': 'cronExpression'
        }
        self._trigger_type = None
        self._time_start = None
        self._time_end = None
        self._cron_expression = None
        self._trigger_type = 'CRON'

    @property
    def cron_expression(self):
        """
        **[Required]** Gets the cron_expression of this ScheduleCronTrigger.
        Schedule cron expression


        :return: The cron_expression of this ScheduleCronTrigger.
        :rtype: str
        """
        return self._cron_expression

    @cron_expression.setter
    def cron_expression(self, cron_expression):
        """
        Sets the cron_expression of this ScheduleCronTrigger.
        Schedule cron expression


        :param cron_expression: The cron_expression of this ScheduleCronTrigger.
        :type: str
        """
        self._cron_expression = cron_expression

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
