# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateSqlFirewallConfigDetails(object):
    """
    Details to update the SQL Firewall config.
    """

    #: A constant which can be used with the status property of a UpdateSqlFirewallConfigDetails.
    #: This constant has a value of "ENABLED"
    STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the status property of a UpdateSqlFirewallConfigDetails.
    #: This constant has a value of "DISABLED"
    STATUS_DISABLED = "DISABLED"

    #: A constant which can be used with the violation_log_auto_purge property of a UpdateSqlFirewallConfigDetails.
    #: This constant has a value of "ENABLED"
    VIOLATION_LOG_AUTO_PURGE_ENABLED = "ENABLED"

    #: A constant which can be used with the violation_log_auto_purge property of a UpdateSqlFirewallConfigDetails.
    #: This constant has a value of "DISABLED"
    VIOLATION_LOG_AUTO_PURGE_DISABLED = "DISABLED"

    #: A constant which can be used with the exclude_job property of a UpdateSqlFirewallConfigDetails.
    #: This constant has a value of "EXCLUDED"
    EXCLUDE_JOB_EXCLUDED = "EXCLUDED"

    #: A constant which can be used with the exclude_job property of a UpdateSqlFirewallConfigDetails.
    #: This constant has a value of "INCLUDED"
    EXCLUDE_JOB_INCLUDED = "INCLUDED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateSqlFirewallConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param status:
            The value to assign to the status property of this UpdateSqlFirewallConfigDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type status: str

        :param violation_log_auto_purge:
            The value to assign to the violation_log_auto_purge property of this UpdateSqlFirewallConfigDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type violation_log_auto_purge: str

        :param exclude_job:
            The value to assign to the exclude_job property of this UpdateSqlFirewallConfigDetails.
            Allowed values for this property are: "EXCLUDED", "INCLUDED"
        :type exclude_job: str

        """
        self.swagger_types = {
            'status': 'str',
            'violation_log_auto_purge': 'str',
            'exclude_job': 'str'
        }
        self.attribute_map = {
            'status': 'status',
            'violation_log_auto_purge': 'violationLogAutoPurge',
            'exclude_job': 'excludeJob'
        }
        self._status = None
        self._violation_log_auto_purge = None
        self._exclude_job = None

    @property
    def status(self):
        """
        Gets the status of this UpdateSqlFirewallConfigDetails.
        Specifies whether the firewall is enabled or disabled on the target database.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The status of this UpdateSqlFirewallConfigDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this UpdateSqlFirewallConfigDetails.
        Specifies whether the firewall is enabled or disabled on the target database.


        :param status: The status of this UpdateSqlFirewallConfigDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            raise ValueError(
                f"Invalid value for `status`, must be None or one of {allowed_values}"
            )
        self._status = status

    @property
    def violation_log_auto_purge(self):
        """
        Gets the violation_log_auto_purge of this UpdateSqlFirewallConfigDetails.
        Specifies whether Data Safe should automatically purge the violation logs
        from the database after collecting the violation logs and persisting on Data Safe.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The violation_log_auto_purge of this UpdateSqlFirewallConfigDetails.
        :rtype: str
        """
        return self._violation_log_auto_purge

    @violation_log_auto_purge.setter
    def violation_log_auto_purge(self, violation_log_auto_purge):
        """
        Sets the violation_log_auto_purge of this UpdateSqlFirewallConfigDetails.
        Specifies whether Data Safe should automatically purge the violation logs
        from the database after collecting the violation logs and persisting on Data Safe.


        :param violation_log_auto_purge: The violation_log_auto_purge of this UpdateSqlFirewallConfigDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(violation_log_auto_purge, allowed_values):
            raise ValueError(
                f"Invalid value for `violation_log_auto_purge`, must be None or one of {allowed_values}"
            )
        self._violation_log_auto_purge = violation_log_auto_purge

    @property
    def exclude_job(self):
        """
        Gets the exclude_job of this UpdateSqlFirewallConfigDetails.
        Specifies whether the firewall should include or exclude the database internal job activities.

        Allowed values for this property are: "EXCLUDED", "INCLUDED"


        :return: The exclude_job of this UpdateSqlFirewallConfigDetails.
        :rtype: str
        """
        return self._exclude_job

    @exclude_job.setter
    def exclude_job(self, exclude_job):
        """
        Sets the exclude_job of this UpdateSqlFirewallConfigDetails.
        Specifies whether the firewall should include or exclude the database internal job activities.


        :param exclude_job: The exclude_job of this UpdateSqlFirewallConfigDetails.
        :type: str
        """
        allowed_values = ["EXCLUDED", "INCLUDED"]
        if not value_allowed_none_or_none_sentinel(exclude_job, allowed_values):
            raise ValueError(
                f"Invalid value for `exclude_job`, must be None or one of {allowed_values}"
            )
        self._exclude_job = exclude_job

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
