# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAuditPolicyConfigDetails(object):
    """
    The unified audit policy related configurations.
    """

    #: A constant which can be used with the exclude_datasafe_user property of a UnifiedAuditPolicyConfigDetails.
    #: This constant has a value of "ENABLED"
    EXCLUDE_DATASAFE_USER_ENABLED = "ENABLED"

    #: A constant which can be used with the exclude_datasafe_user property of a UnifiedAuditPolicyConfigDetails.
    #: This constant has a value of "DISABLED"
    EXCLUDE_DATASAFE_USER_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAuditPolicyConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param exclude_datasafe_user:
            The value to assign to the exclude_datasafe_user property of this UnifiedAuditPolicyConfigDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type exclude_datasafe_user: str

        """
        self.swagger_types = {
            'exclude_datasafe_user': 'str'
        }
        self.attribute_map = {
            'exclude_datasafe_user': 'excludeDatasafeUser'
        }
        self._exclude_datasafe_user = None

    @property
    def exclude_datasafe_user(self):
        """
        Gets the exclude_datasafe_user of this UnifiedAuditPolicyConfigDetails.
        Specifies whether the Data Safe service account on the target database should be excluded in the unified audit policy.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The exclude_datasafe_user of this UnifiedAuditPolicyConfigDetails.
        :rtype: str
        """
        return self._exclude_datasafe_user

    @exclude_datasafe_user.setter
    def exclude_datasafe_user(self, exclude_datasafe_user):
        """
        Sets the exclude_datasafe_user of this UnifiedAuditPolicyConfigDetails.
        Specifies whether the Data Safe service account on the target database should be excluded in the unified audit policy.


        :param exclude_datasafe_user: The exclude_datasafe_user of this UnifiedAuditPolicyConfigDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(exclude_datasafe_user, allowed_values):
            raise ValueError(
                f"Invalid value for `exclude_datasafe_user`, must be None or one of {allowed_values}"
            )
        self._exclude_datasafe_user = exclude_datasafe_user

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
