# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201

from .selection_details import SelectionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScimQuerySelectionMode(SelectionDetails):
    """
    Indicates that the selection is a scimQuery.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ScimQuerySelectionMode object with values from keyword arguments. The default value of the :py:attr:`~oci.data_safe.models.ScimQuerySelectionMode.selection_mode` attribute
        of this class is ``SCIM_QUERY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param selection_mode:
            The value to assign to the selection_mode property of this ScimQuerySelectionMode.
            Allowed values for this property are: "LIST", "SCIM_QUERY"
        :type selection_mode: str

        :param scim_query:
            The value to assign to the scim_query property of this ScimQuerySelectionMode.
        :type scim_query: str

        """
        self.swagger_types = {
            'selection_mode': 'str',
            'scim_query': 'str'
        }
        self.attribute_map = {
            'selection_mode': 'selectionMode',
            'scim_query': 'scimQuery'
        }
        self._selection_mode = None
        self._scim_query = None
        self._selection_mode = 'SCIM_QUERY'

    @property
    def scim_query(self):
        """
        **[Required]** Gets the scim_query of this ScimQuerySelectionMode.
        The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2
        of the System for Cross-Domain Identity Management (SCIM) specification, which is available
        at `RFC3339`__. In SCIM filtering expressions,
        text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format.
        (Numeric and boolean values should not be quoted.)

        **Example:** query=(dbUserName eq \"PAY_APP\")

        __ https://tools.ietf.org/html/draft-ietf-scim-api-12


        :return: The scim_query of this ScimQuerySelectionMode.
        :rtype: str
        """
        return self._scim_query

    @scim_query.setter
    def scim_query(self, scim_query):
        """
        Sets the scim_query of this ScimQuerySelectionMode.
        The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2
        of the System for Cross-Domain Identity Management (SCIM) specification, which is available
        at `RFC3339`__. In SCIM filtering expressions,
        text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format.
        (Numeric and boolean values should not be quoted.)

        **Example:** query=(dbUserName eq \"PAY_APP\")

        __ https://tools.ietf.org/html/draft-ietf-scim-api-12


        :param scim_query: The scim_query of this ScimQuerySelectionMode.
        :type: str
        """
        self._scim_query = scim_query

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
