# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SupportedCapabilities(object):
    """
    Specifies the capabilities that the Dedicated Virtual Machine Host (DVMH) Shape or Virtual Machine Instance Shape could support.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SupportedCapabilities object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_memory_encryption_supported:
            The value to assign to the is_memory_encryption_supported property of this SupportedCapabilities.
        :type is_memory_encryption_supported: bool

        """
        self.swagger_types = {
            'is_memory_encryption_supported': 'bool'
        }
        self.attribute_map = {
            'is_memory_encryption_supported': 'isMemoryEncryptionSupported'
        }
        self._is_memory_encryption_supported = None

    @property
    def is_memory_encryption_supported(self):
        """
        **[Required]** Gets the is_memory_encryption_supported of this SupportedCapabilities.
        Whether the DVMH shape could support confidential VMs or the VM instance shape could be confidential.


        :return: The is_memory_encryption_supported of this SupportedCapabilities.
        :rtype: bool
        """
        return self._is_memory_encryption_supported

    @is_memory_encryption_supported.setter
    def is_memory_encryption_supported(self, is_memory_encryption_supported):
        """
        Sets the is_memory_encryption_supported of this SupportedCapabilities.
        Whether the DVMH shape could support confidential VMs or the VM instance shape could be confidential.


        :param is_memory_encryption_supported: The is_memory_encryption_supported of this SupportedCapabilities.
        :type: bool
        """
        self._is_memory_encryption_supported = is_memory_encryption_supported

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
