# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceConfigurationLaunchInstanceShapeConfigDetails(object):
    """
    The shape configuration requested for the instance.

    If the parameter is provided, the instance is created
    with the resources that you specify. If some properties are missing or
    the entire parameter is not provided, the instance is created with the default
    configuration values for the `shape` that you specify.

    Each shape only supports certain configurable values. If the values that you provide are not valid for the
    specified `shape`, an error is returned.
    """

    #: A constant which can be used with the baseline_ocpu_utilization property of a InstanceConfigurationLaunchInstanceShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_8"
    BASELINE_OCPU_UTILIZATION_BASELINE_1_8 = "BASELINE_1_8"

    #: A constant which can be used with the baseline_ocpu_utilization property of a InstanceConfigurationLaunchInstanceShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_2"
    BASELINE_OCPU_UTILIZATION_BASELINE_1_2 = "BASELINE_1_2"

    #: A constant which can be used with the baseline_ocpu_utilization property of a InstanceConfigurationLaunchInstanceShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_1"
    BASELINE_OCPU_UTILIZATION_BASELINE_1_1 = "BASELINE_1_1"

    #: A constant which can be used with the resource_management property of a InstanceConfigurationLaunchInstanceShapeConfigDetails.
    #: This constant has a value of "DYNAMIC"
    RESOURCE_MANAGEMENT_DYNAMIC = "DYNAMIC"

    #: A constant which can be used with the resource_management property of a InstanceConfigurationLaunchInstanceShapeConfigDetails.
    #: This constant has a value of "STATIC"
    RESOURCE_MANAGEMENT_STATIC = "STATIC"

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceConfigurationLaunchInstanceShapeConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ocpus:
            The value to assign to the ocpus property of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type ocpus: float

        :param vcpus:
            The value to assign to the vcpus property of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type vcpus: int

        :param memory_in_gbs:
            The value to assign to the memory_in_gbs property of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type memory_in_gbs: float

        :param baseline_ocpu_utilization:
            The value to assign to the baseline_ocpu_utilization property of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
            Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type baseline_ocpu_utilization: str

        :param nvmes:
            The value to assign to the nvmes property of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type nvmes: int

        :param resource_management:
            The value to assign to the resource_management property of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
            Allowed values for this property are: "DYNAMIC", "STATIC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type resource_management: str

        """
        self.swagger_types = {
            'ocpus': 'float',
            'vcpus': 'int',
            'memory_in_gbs': 'float',
            'baseline_ocpu_utilization': 'str',
            'nvmes': 'int',
            'resource_management': 'str'
        }
        self.attribute_map = {
            'ocpus': 'ocpus',
            'vcpus': 'vcpus',
            'memory_in_gbs': 'memoryInGBs',
            'baseline_ocpu_utilization': 'baselineOcpuUtilization',
            'nvmes': 'nvmes',
            'resource_management': 'resourceManagement'
        }
        self._ocpus = None
        self._vcpus = None
        self._memory_in_gbs = None
        self._baseline_ocpu_utilization = None
        self._nvmes = None
        self._resource_management = None

    @property
    def ocpus(self):
        """
        Gets the ocpus of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The total number of OCPUs available to the instance.


        :return: The ocpus of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :rtype: float
        """
        return self._ocpus

    @ocpus.setter
    def ocpus(self, ocpus):
        """
        Sets the ocpus of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The total number of OCPUs available to the instance.


        :param ocpus: The ocpus of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type: float
        """
        self._ocpus = ocpus

    @property
    def vcpus(self):
        """
        Gets the vcpus of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The total number of VCPUs available to the instance. This can be used instead of OCPUs,
        in which case the actual number of OCPUs will be calculated based on this value
        and the actual hardware. This must be a multiple of 2.


        :return: The vcpus of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :rtype: int
        """
        return self._vcpus

    @vcpus.setter
    def vcpus(self, vcpus):
        """
        Sets the vcpus of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The total number of VCPUs available to the instance. This can be used instead of OCPUs,
        in which case the actual number of OCPUs will be calculated based on this value
        and the actual hardware. This must be a multiple of 2.


        :param vcpus: The vcpus of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type: int
        """
        self._vcpus = vcpus

    @property
    def memory_in_gbs(self):
        """
        Gets the memory_in_gbs of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The total amount of memory available to the instance, in gigabytes.


        :return: The memory_in_gbs of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :rtype: float
        """
        return self._memory_in_gbs

    @memory_in_gbs.setter
    def memory_in_gbs(self, memory_in_gbs):
        """
        Sets the memory_in_gbs of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The total amount of memory available to the instance, in gigabytes.


        :param memory_in_gbs: The memory_in_gbs of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type: float
        """
        self._memory_in_gbs = memory_in_gbs

    @property
    def baseline_ocpu_utilization(self):
        """
        Gets the baseline_ocpu_utilization of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The baseline OCPU utilization for a subcore burstable VM instance. Leave this attribute blank for a
        non-burstable instance, or explicitly specify non-burstable with `BASELINE_1_1`.

        The following values are supported:
        - `BASELINE_1_8` - baseline usage is 1/8 of an OCPU.
        - `BASELINE_1_2` - baseline usage is 1/2 of an OCPU.
        - `BASELINE_1_1` - baseline usage is an entire OCPU. This represents a non-burstable instance.

        Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The baseline_ocpu_utilization of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :rtype: str
        """
        return self._baseline_ocpu_utilization

    @baseline_ocpu_utilization.setter
    def baseline_ocpu_utilization(self, baseline_ocpu_utilization):
        """
        Sets the baseline_ocpu_utilization of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The baseline OCPU utilization for a subcore burstable VM instance. Leave this attribute blank for a
        non-burstable instance, or explicitly specify non-burstable with `BASELINE_1_1`.

        The following values are supported:
        - `BASELINE_1_8` - baseline usage is 1/8 of an OCPU.
        - `BASELINE_1_2` - baseline usage is 1/2 of an OCPU.
        - `BASELINE_1_1` - baseline usage is an entire OCPU. This represents a non-burstable instance.


        :param baseline_ocpu_utilization: The baseline_ocpu_utilization of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type: str
        """
        allowed_values = ["BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1"]
        if not value_allowed_none_or_none_sentinel(baseline_ocpu_utilization, allowed_values):
            baseline_ocpu_utilization = 'UNKNOWN_ENUM_VALUE'
        self._baseline_ocpu_utilization = baseline_ocpu_utilization

    @property
    def nvmes(self):
        """
        Gets the nvmes of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The number of NVMe drives to be used for storage. A single drive has 6.8 TB available.


        :return: The nvmes of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :rtype: int
        """
        return self._nvmes

    @nvmes.setter
    def nvmes(self, nvmes):
        """
        Sets the nvmes of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        The number of NVMe drives to be used for storage. A single drive has 6.8 TB available.


        :param nvmes: The nvmes of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type: int
        """
        self._nvmes = nvmes

    @property
    def resource_management(self):
        """
        Gets the resource_management of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        This field is reserved for internal use.

        Allowed values for this property are: "DYNAMIC", "STATIC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The resource_management of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :rtype: str
        """
        return self._resource_management

    @resource_management.setter
    def resource_management(self, resource_management):
        """
        Sets the resource_management of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        This field is reserved for internal use.


        :param resource_management: The resource_management of this InstanceConfigurationLaunchInstanceShapeConfigDetails.
        :type: str
        """
        allowed_values = ["DYNAMIC", "STATIC"]
        if not value_allowed_none_or_none_sentinel(resource_management, allowed_values):
            resource_management = 'UNKNOWN_ENUM_VALUE'
        self._resource_management = resource_management

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
