# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstancePrivateIpAddress(object):
    """
    Describes a private IPv4 address.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstancePrivateIpAddress object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param association:
            The value to assign to the association property of this InstancePrivateIpAddress.
        :type association: oci.cloud_bridge.models.InstanceNetworkInterfaceAssociation

        :param is_primary:
            The value to assign to the is_primary property of this InstancePrivateIpAddress.
        :type is_primary: bool

        :param private_dns_name:
            The value to assign to the private_dns_name property of this InstancePrivateIpAddress.
        :type private_dns_name: str

        :param private_ip_address:
            The value to assign to the private_ip_address property of this InstancePrivateIpAddress.
        :type private_ip_address: str

        """
        self.swagger_types = {
            'association': 'InstanceNetworkInterfaceAssociation',
            'is_primary': 'bool',
            'private_dns_name': 'str',
            'private_ip_address': 'str'
        }
        self.attribute_map = {
            'association': 'association',
            'is_primary': 'isPrimary',
            'private_dns_name': 'privateDnsName',
            'private_ip_address': 'privateIpAddress'
        }
        self._association = None
        self._is_primary = None
        self._private_dns_name = None
        self._private_ip_address = None

    @property
    def association(self):
        """
        Gets the association of this InstancePrivateIpAddress.

        :return: The association of this InstancePrivateIpAddress.
        :rtype: oci.cloud_bridge.models.InstanceNetworkInterfaceAssociation
        """
        return self._association

    @association.setter
    def association(self, association):
        """
        Sets the association of this InstancePrivateIpAddress.

        :param association: The association of this InstancePrivateIpAddress.
        :type: oci.cloud_bridge.models.InstanceNetworkInterfaceAssociation
        """
        self._association = association

    @property
    def is_primary(self):
        """
        Gets the is_primary of this InstancePrivateIpAddress.
        Indicates whether this IPv4 address is the primary private IP address of the network interface.


        :return: The is_primary of this InstancePrivateIpAddress.
        :rtype: bool
        """
        return self._is_primary

    @is_primary.setter
    def is_primary(self, is_primary):
        """
        Sets the is_primary of this InstancePrivateIpAddress.
        Indicates whether this IPv4 address is the primary private IP address of the network interface.


        :param is_primary: The is_primary of this InstancePrivateIpAddress.
        :type: bool
        """
        self._is_primary = is_primary

    @property
    def private_dns_name(self):
        """
        Gets the private_dns_name of this InstancePrivateIpAddress.
        The private IPv4 DNS name.


        :return: The private_dns_name of this InstancePrivateIpAddress.
        :rtype: str
        """
        return self._private_dns_name

    @private_dns_name.setter
    def private_dns_name(self, private_dns_name):
        """
        Sets the private_dns_name of this InstancePrivateIpAddress.
        The private IPv4 DNS name.


        :param private_dns_name: The private_dns_name of this InstancePrivateIpAddress.
        :type: str
        """
        self._private_dns_name = private_dns_name

    @property
    def private_ip_address(self):
        """
        Gets the private_ip_address of this InstancePrivateIpAddress.
        The private IPv4 address of the network interface.


        :return: The private_ip_address of this InstancePrivateIpAddress.
        :rtype: str
        """
        return self._private_ip_address

    @private_ip_address.setter
    def private_ip_address(self, private_ip_address):
        """
        Sets the private_ip_address of this InstancePrivateIpAddress.
        The private IPv4 address of the network interface.


        :param private_ip_address: The private_ip_address of this InstancePrivateIpAddress.
        :type: str
        """
        self._private_ip_address = private_ip_address

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
