# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccmDemandSignalResourcePropertyOptionSummary(object):
    """
    A summary model for the Occm demand signal resource property option. To support range of the options for a property
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OccmDemandSignalResourcePropertyOptionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param option_key:
            The value to assign to the option_key property of this OccmDemandSignalResourcePropertyOptionSummary.
        :type option_key: str

        :param option_value:
            The value to assign to the option_value property of this OccmDemandSignalResourcePropertyOptionSummary.
        :type option_value: str

        """
        self.swagger_types = {
            'option_key': 'str',
            'option_value': 'str'
        }
        self.attribute_map = {
            'option_key': 'optionKey',
            'option_value': 'optionValue'
        }
        self._option_key = None
        self._option_value = None

    @property
    def option_key(self):
        """
        **[Required]** Gets the option_key of this OccmDemandSignalResourcePropertyOptionSummary.
        key of a property option like memoryValue, ocpuValue.


        :return: The option_key of this OccmDemandSignalResourcePropertyOptionSummary.
        :rtype: str
        """
        return self._option_key

    @option_key.setter
    def option_key(self, option_key):
        """
        Sets the option_key of this OccmDemandSignalResourcePropertyOptionSummary.
        key of a property option like memoryValue, ocpuValue.


        :param option_key: The option_key of this OccmDemandSignalResourcePropertyOptionSummary.
        :type: str
        """
        self._option_key = option_key

    @property
    def option_value(self):
        """
        **[Required]** Gets the option_value of this OccmDemandSignalResourcePropertyOptionSummary.
        value of a property option like 64, 2 fastconnect etc.


        :return: The option_value of this OccmDemandSignalResourcePropertyOptionSummary.
        :rtype: str
        """
        return self._option_value

    @option_value.setter
    def option_value(self, option_value):
        """
        Sets the option_value of this OccmDemandSignalResourcePropertyOptionSummary.
        value of a property option like 64, 2 fastconnect etc.


        :param option_value: The option_value of this OccmDemandSignalResourcePropertyOptionSummary.
        :type: str
        """
        self._option_value = option_value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
