# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccHandoverResourceBlockDetailSummary(object):
    """
    Detailed information about a particular occHandoverResourceBlock.
    For compute namespace this information includes host serial, host ocid etc.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OccHandoverResourceBlockDetailSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param occ_resource_handover_block_id:
            The value to assign to the occ_resource_handover_block_id property of this OccHandoverResourceBlockDetailSummary.
        :type occ_resource_handover_block_id: str

        :param details:
            The value to assign to the details property of this OccHandoverResourceBlockDetailSummary.
        :type details: dict(str, str)

        """
        self.swagger_types = {
            'occ_resource_handover_block_id': 'str',
            'details': 'dict(str, str)'
        }
        self.attribute_map = {
            'occ_resource_handover_block_id': 'occResourceHandoverBlockId',
            'details': 'details'
        }
        self._occ_resource_handover_block_id = None
        self._details = None

    @property
    def occ_resource_handover_block_id(self):
        """
        **[Required]** Gets the occ_resource_handover_block_id of this OccHandoverResourceBlockDetailSummary.
        The OCID of the occResourceHandoverBlock.


        :return: The occ_resource_handover_block_id of this OccHandoverResourceBlockDetailSummary.
        :rtype: str
        """
        return self._occ_resource_handover_block_id

    @occ_resource_handover_block_id.setter
    def occ_resource_handover_block_id(self, occ_resource_handover_block_id):
        """
        Sets the occ_resource_handover_block_id of this OccHandoverResourceBlockDetailSummary.
        The OCID of the occResourceHandoverBlock.


        :param occ_resource_handover_block_id: The occ_resource_handover_block_id of this OccHandoverResourceBlockDetailSummary.
        :type: str
        """
        self._occ_resource_handover_block_id = occ_resource_handover_block_id

    @property
    def details(self):
        """
        **[Required]** Gets the details of this OccHandoverResourceBlockDetailSummary.
        A map that contains additional details for a given handover resource. For example for compute namespace this includes host ocid, host serial etc.


        :return: The details of this OccHandoverResourceBlockDetailSummary.
        :rtype: dict(str, str)
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this OccHandoverResourceBlockDetailSummary.
        A map that contains additional details for a given handover resource. For example for compute namespace this includes host ocid, host serial etc.


        :param details: The details of this OccHandoverResourceBlockDetailSummary.
        :type: dict(str, str)
        """
        self._details = details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
