# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NodeBackupSummary(object):
    """
    The information about the nodeBackupSummary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NodeBackupSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this NodeBackupSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this NodeBackupSummary.
        :type display_name: str

        :param node_instance_id:
            The value to assign to the node_instance_id property of this NodeBackupSummary.
        :type node_instance_id: str

        :param node_host_name:
            The value to assign to the node_host_name property of this NodeBackupSummary.
        :type node_host_name: str

        :param backup_trigger_type:
            The value to assign to the backup_trigger_type property of this NodeBackupSummary.
        :type backup_trigger_type: str

        :param backup_type:
            The value to assign to the backup_type property of this NodeBackupSummary.
        :type backup_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this NodeBackupSummary.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this NodeBackupSummary.
        :type time_created: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'node_instance_id': 'str',
            'node_host_name': 'str',
            'backup_trigger_type': 'str',
            'backup_type': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'node_instance_id': 'nodeInstanceId',
            'node_host_name': 'nodeHostName',
            'backup_trigger_type': 'backupTriggerType',
            'backup_type': 'backupType',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated'
        }
        self._id = None
        self._display_name = None
        self._node_instance_id = None
        self._node_host_name = None
        self._backup_trigger_type = None
        self._backup_type = None
        self._lifecycle_state = None
        self._time_created = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this NodeBackupSummary.
        The id of the node backup.


        :return: The id of this NodeBackupSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NodeBackupSummary.
        The id of the node backup.


        :param id: The id of this NodeBackupSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this NodeBackupSummary.
        BDS generated name for the backup. Format is nodeHostName_timeCreated.


        :return: The display_name of this NodeBackupSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this NodeBackupSummary.
        BDS generated name for the backup. Format is nodeHostName_timeCreated.


        :param display_name: The display_name of this NodeBackupSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def node_instance_id(self):
        """
        **[Required]** Gets the node_instance_id of this NodeBackupSummary.
        The instance OCID of the node, which is the resource from which the node backup was acquired.


        :return: The node_instance_id of this NodeBackupSummary.
        :rtype: str
        """
        return self._node_instance_id

    @node_instance_id.setter
    def node_instance_id(self, node_instance_id):
        """
        Sets the node_instance_id of this NodeBackupSummary.
        The instance OCID of the node, which is the resource from which the node backup was acquired.


        :param node_instance_id: The node_instance_id of this NodeBackupSummary.
        :type: str
        """
        self._node_instance_id = node_instance_id

    @property
    def node_host_name(self):
        """
        **[Required]** Gets the node_host_name of this NodeBackupSummary.
        Host name of the node that the backup belongs to.


        :return: The node_host_name of this NodeBackupSummary.
        :rtype: str
        """
        return self._node_host_name

    @node_host_name.setter
    def node_host_name(self, node_host_name):
        """
        Sets the node_host_name of this NodeBackupSummary.
        Host name of the node that the backup belongs to.


        :param node_host_name: The node_host_name of this NodeBackupSummary.
        :type: str
        """
        self._node_host_name = node_host_name

    @property
    def backup_trigger_type(self):
        """
        **[Required]** Gets the backup_trigger_type of this NodeBackupSummary.
        type based on how backup action was initiated.


        :return: The backup_trigger_type of this NodeBackupSummary.
        :rtype: str
        """
        return self._backup_trigger_type

    @backup_trigger_type.setter
    def backup_trigger_type(self, backup_trigger_type):
        """
        Sets the backup_trigger_type of this NodeBackupSummary.
        type based on how backup action was initiated.


        :param backup_trigger_type: The backup_trigger_type of this NodeBackupSummary.
        :type: str
        """
        self._backup_trigger_type = backup_trigger_type

    @property
    def backup_type(self):
        """
        **[Required]** Gets the backup_type of this NodeBackupSummary.
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created


        :return: The backup_type of this NodeBackupSummary.
        :rtype: str
        """
        return self._backup_type

    @backup_type.setter
    def backup_type(self, backup_type):
        """
        Sets the backup_type of this NodeBackupSummary.
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created


        :param backup_type: The backup_type of this NodeBackupSummary.
        :type: str
        """
        self._backup_type = backup_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this NodeBackupSummary.
        The state of NodeBackup.


        :return: The lifecycle_state of this NodeBackupSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this NodeBackupSummary.
        The state of NodeBackup.


        :param lifecycle_state: The lifecycle_state of this NodeBackupSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this NodeBackupSummary.
        The time the cluster was created, shown as an RFC 3339 formatted datetime string.


        :return: The time_created of this NodeBackupSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this NodeBackupSummary.
        The time the cluster was created, shown as an RFC 3339 formatted datetime string.


        :param time_created: The time_created of this NodeBackupSummary.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
