# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstallSoftwareUpdatesDetails(object):
    """
    Details for installing a software update to a cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstallSoftwareUpdatesDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param software_update_keys:
            The value to assign to the software_update_keys property of this InstallSoftwareUpdatesDetails.
        :type software_update_keys: list[str]

        """
        self.swagger_types = {
            'software_update_keys': 'list[str]'
        }
        self.attribute_map = {
            'software_update_keys': 'softwareUpdateKeys'
        }
        self._software_update_keys = None

    @property
    def software_update_keys(self):
        """
        **[Required]** Gets the software_update_keys of this InstallSoftwareUpdatesDetails.
        A list of unique identifiers of target software updates.


        :return: The software_update_keys of this InstallSoftwareUpdatesDetails.
        :rtype: list[str]
        """
        return self._software_update_keys

    @software_update_keys.setter
    def software_update_keys(self, software_update_keys):
        """
        Sets the software_update_keys of this InstallSoftwareUpdatesDetails.
        A list of unique identifiers of target software updates.


        :param software_update_keys: The software_update_keys of this InstallSoftwareUpdatesDetails.
        :type: list[str]
        """
        self._software_update_keys = software_update_keys

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
