# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ActivateIamUserSyncConfigurationDetails(object):
    """
    Details for activating IAM user sync configuration
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ActivateIamUserSyncConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_admin_password:
            The value to assign to the cluster_admin_password property of this ActivateIamUserSyncConfigurationDetails.
        :type cluster_admin_password: str

        :param is_posix_attributes_addition_required:
            The value to assign to the is_posix_attributes_addition_required property of this ActivateIamUserSyncConfigurationDetails.
        :type is_posix_attributes_addition_required: bool

        """
        self.swagger_types = {
            'cluster_admin_password': 'str',
            'is_posix_attributes_addition_required': 'bool'
        }
        self.attribute_map = {
            'cluster_admin_password': 'clusterAdminPassword',
            'is_posix_attributes_addition_required': 'isPosixAttributesAdditionRequired'
        }
        self._cluster_admin_password = None
        self._is_posix_attributes_addition_required = None

    @property
    def cluster_admin_password(self):
        """
        **[Required]** Gets the cluster_admin_password of this ActivateIamUserSyncConfigurationDetails.
        Base-64 encoded password for the cluster admin user.


        :return: The cluster_admin_password of this ActivateIamUserSyncConfigurationDetails.
        :rtype: str
        """
        return self._cluster_admin_password

    @cluster_admin_password.setter
    def cluster_admin_password(self, cluster_admin_password):
        """
        Sets the cluster_admin_password of this ActivateIamUserSyncConfigurationDetails.
        Base-64 encoded password for the cluster admin user.


        :param cluster_admin_password: The cluster_admin_password of this ActivateIamUserSyncConfigurationDetails.
        :type: str
        """
        self._cluster_admin_password = cluster_admin_password

    @property
    def is_posix_attributes_addition_required(self):
        """
        Gets the is_posix_attributes_addition_required of this ActivateIamUserSyncConfigurationDetails.
        whether posix attribute needs to be appended to users


        :return: The is_posix_attributes_addition_required of this ActivateIamUserSyncConfigurationDetails.
        :rtype: bool
        """
        return self._is_posix_attributes_addition_required

    @is_posix_attributes_addition_required.setter
    def is_posix_attributes_addition_required(self, is_posix_attributes_addition_required):
        """
        Sets the is_posix_attributes_addition_required of this ActivateIamUserSyncConfigurationDetails.
        whether posix attribute needs to be appended to users


        :param is_posix_attributes_addition_required: The is_posix_attributes_addition_required of this ActivateIamUserSyncConfigurationDetails.
        :type: bool
        """
        self._is_posix_attributes_addition_required = is_posix_attributes_addition_required

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
