# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FilterTextOrId(object):
    """
    A span filter written in text, or as the `OCID`__ of a
    SpanFilter resource. If both are given, the filterText is used.

    __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FilterTextOrId object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param filter_id:
            The value to assign to the filter_id property of this FilterTextOrId.
        :type filter_id: str

        :param filter_text:
            The value to assign to the filter_text property of this FilterTextOrId.
        :type filter_text: str

        """
        self.swagger_types = {
            'filter_id': 'str',
            'filter_text': 'str'
        }
        self.attribute_map = {
            'filter_id': 'filterId',
            'filter_text': 'filterText'
        }
        self._filter_id = None
        self._filter_text = None

    @property
    def filter_id(self):
        """
        Gets the filter_id of this FilterTextOrId.
        The `OCID`__ of a Span Filter. The filterId is mandatory for the creation
        of MetricGroups. A filterId is generated when a Span Filter is created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The filter_id of this FilterTextOrId.
        :rtype: str
        """
        return self._filter_id

    @filter_id.setter
    def filter_id(self, filter_id):
        """
        Sets the filter_id of this FilterTextOrId.
        The `OCID`__ of a Span Filter. The filterId is mandatory for the creation
        of MetricGroups. A filterId is generated when a Span Filter is created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param filter_id: The filter_id of this FilterTextOrId.
        :type: str
        """
        self._filter_id = filter_id

    @property
    def filter_text(self):
        """
        Gets the filter_text of this FilterTextOrId.
        The string that defines the Span Filter expression.


        :return: The filter_text of this FilterTextOrId.
        :rtype: str
        """
        return self._filter_text

    @filter_text.setter
    def filter_text(self, filter_text):
        """
        Sets the filter_text of this FilterTextOrId.
        The string that defines the Span Filter expression.


        :param filter_text: The filter_text of this FilterTextOrId.
        :type: str
        """
        self._filter_text = filter_text

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
