# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Entity(object):
    """
    Entity Object Reference
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Entity object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_value:
            The value to assign to the entity_value property of this Entity.
        :type entity_value: str

        :param pronunciations:
            The value to assign to the pronunciations property of this Entity.
        :type pronunciations: list[oci.ai_speech.models.Pronunciation]

        :param weight:
            The value to assign to the weight property of this Entity.
        :type weight: float

        """
        self.swagger_types = {
            'entity_value': 'str',
            'pronunciations': 'list[Pronunciation]',
            'weight': 'float'
        }
        self.attribute_map = {
            'entity_value': 'entityValue',
            'pronunciations': 'pronunciations',
            'weight': 'weight'
        }
        self._entity_value = None
        self._pronunciations = None
        self._weight = None

    @property
    def entity_value(self):
        """
        **[Required]** Gets the entity_value of this Entity.
        Entity value


        :return: The entity_value of this Entity.
        :rtype: str
        """
        return self._entity_value

    @entity_value.setter
    def entity_value(self, entity_value):
        """
        Sets the entity_value of this Entity.
        Entity value


        :param entity_value: The entity_value of this Entity.
        :type: str
        """
        self._entity_value = entity_value

    @property
    def pronunciations(self):
        """
        Gets the pronunciations of this Entity.
        List of pronunciations (minimum 1, maximum 255)


        :return: The pronunciations of this Entity.
        :rtype: list[oci.ai_speech.models.Pronunciation]
        """
        return self._pronunciations

    @pronunciations.setter
    def pronunciations(self, pronunciations):
        """
        Sets the pronunciations of this Entity.
        List of pronunciations (minimum 1, maximum 255)


        :param pronunciations: The pronunciations of this Entity.
        :type: list[oci.ai_speech.models.Pronunciation]
        """
        self._pronunciations = pronunciations

    @property
    def weight(self):
        """
        Gets the weight of this Entity.
        Entity weight


        :return: The weight of this Entity.
        :rtype: float
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """
        Sets the weight of this Entity.
        Entity weight


        :param weight: The weight of this Entity.
        :type: float
        """
        self._weight = weight

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
