# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MelConcept(object):
    """
    The MEL concepts details for health ner.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MelConcept object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ontology_name:
            The value to assign to the ontology_name property of this MelConcept.
        :type ontology_name: str

        :param concepts:
            The value to assign to the concepts property of this MelConcept.
        :type concepts: list[oci.ai_language.models.MelConceptDetails]

        """
        self.swagger_types = {
            'ontology_name': 'str',
            'concepts': 'list[MelConceptDetails]'
        }
        self.attribute_map = {
            'ontology_name': 'ontologyName',
            'concepts': 'concepts'
        }
        self._ontology_name = None
        self._concepts = None

    @property
    def ontology_name(self):
        """
        **[Required]** Gets the ontology_name of this MelConcept.
        Name of the ontology to which the Entity is mapped


        :return: The ontology_name of this MelConcept.
        :rtype: str
        """
        return self._ontology_name

    @ontology_name.setter
    def ontology_name(self, ontology_name):
        """
        Sets the ontology_name of this MelConcept.
        Name of the ontology to which the Entity is mapped


        :param ontology_name: The ontology_name of this MelConcept.
        :type: str
        """
        self._ontology_name = ontology_name

    @property
    def concepts(self):
        """
        **[Required]** Gets the concepts of this MelConcept.
        This contains the list of matched concepts which are ranked by the relevant score with the input text


        :return: The concepts of this MelConcept.
        :rtype: list[oci.ai_language.models.MelConceptDetails]
        """
        return self._concepts

    @concepts.setter
    def concepts(self, concepts):
        """
        Sets the concepts of this MelConcept.
        This contains the list of matched concepts which are ranked by the relevant score with the input text


        :param concepts: The concepts of this MelConcept.
        :type: list[oci.ai_language.models.MelConceptDetails]
        """
        self._concepts = concepts

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
