/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.WLSJTAPlugin;
import oracle.ucp.jdbc.BorrowContextUpdater;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.UCPConnectionBuilderImpl;
import oracle.ucp.jdbc.UCPXAConnectionBuilder;
import oracle.ucp.jdbc.UCPXAConnectionBuilderImpl;
import oracle.ucp.jdbc.XAConnectionConnectionPool;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleXAConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.other.OtherConnectionProxyFactory;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.logging.annotations.StringBlinder;
import oracle.ucp.util.OpaqueString;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class PoolXADataSourceImpl
extends PoolDataSourceImpl
implements PoolXADataSource,
Serializable,
Referenceable,
ObjectFactory,
UniversalConnectionPoolAdapter {
    static final String CLASS_NAME = PoolXADataSourceImpl.class.getName();
    private static final long serialVersionUID = 4343640747511L;
    private XADataSource m_xaDataSource = null;

    public PoolXADataSourceImpl() {
    }

    PoolXADataSourceImpl(String poolName, String dsName, Map<String, Object> config) throws UniversalConnectionPoolException, Exception {
        super(poolName, dsName, config);
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    protected void createPoolWithDefaultProperties() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "createPoolWithDefaultProperties", "entering args ()", null, null, new Object[0]);
            String className = this.getClass().getName();
            int errCode = 27;
            try {
                this.m_xaDataSource = (XADataSource)this.connectionFactory;
                this.trace(Level.FINEST, CLASS_NAME, "createPoolWithDefaultProperties", "XADataSource is set", null, null, new Object[0]);
                errCode = 1;
                String connectionFactoryClassName = this.getConnectionFactoryClassName();
                if (connectionFactoryClassName != null && connectionFactoryClassName.startsWith("oracle.jdbc")) {
                    OracleXADataSourceConnectionFactoryAdapter ocfa = new OracleXADataSourceConnectionFactoryAdapter(this.m_xaDataSource, this.getDiagnosable());
                    this.connectionPool = new OracleXAConnectionConnectionPool(ocfa, this.getDiagnosable());
                    ocfa.setUniversalConnectionPool(this.connectionPool);
                    this.connectionPool.setOraclePool(true);
                } else {
                    XADataSourceConnectionFactoryAdapter cfa = new XADataSourceConnectionFactoryAdapter(this.m_xaDataSource, this.getDiagnosable());
                    this.connectionPool = new XAConnectionConnectionPool(cfa, this.getDiagnosable()){
                        private final ConnectionProxyFactory cpf;
                        {
                            this.cpf = new OtherConnectionProxyFactory();
                        }

                        @Override
                        public ConnectionProxyFactory getProxyFactory() {
                            return this.cpf;
                        }
                    };
                    cfa.setUniversalConnectionPool(this.connectionPool);
                    this.connectionPool.setOraclePool(false);
                }
                assert (this.connectionPool != null);
                this.connectionPool.setConnectionFactory(this.connectionFactory);
                this.trace(Level.FINE, CLASS_NAME, "createPoolWithDefaultProperties", "connection pool is created", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(errCode, e);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "createPoolWithDefaultProperties", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "createPoolWithDefaultProperties", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public Connection getConnection() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "entering args ()", null, null, new Object[0]);
            if (WLSJTAPlugin.jtaWLSEnabled) {
                this.trace(Level.FINEST, CLASS_NAME, "getConnection", "WLS/JTA support enabled, allow PoolXADataSourceImpl.getConnection()", null, null, new Object[0]);
                Connection connection = this.getXAConnection().getConnection();
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "returning {0}", null, null, connection);
                return connection;
            }
            this.trace(Level.FINEST, CLASS_NAME, "getConnection", "PoolXADataSourceImpl.getConnection() is disabled", null, null, new Object[0]);
            UCPErrorHandler.throwSQLException(58, null);
            Connection connection = null;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "returning {0}", null, null, connection);
            return connection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Connection getConnection(String string, @Blind String string2) throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "entering args ({0}, {1})", null, null, string, new StringBlinder().blind(string2));
            if (WLSJTAPlugin.jtaWLSEnabled) {
                void password;
                void username;
                this.trace(Level.FINEST, CLASS_NAME, "getConnection", "WLS/JTA support enabled, allow PoolXADataSourceImpl.getConnection(usr,pwd)", null, null, new Object[0]);
                Connection connection = this.getXAConnection((String)username, (String)password).getConnection();
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "returning {0}", null, null, connection);
                return connection;
            }
            this.trace(Level.FINEST, CLASS_NAME, "getConnection", "PoolXADataSourceImpl.getConnection(usr,pwd) is disabled", null, null, new Object[0]);
            UCPErrorHandler.throwSQLException(58, null);
            Connection connection = null;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "returning {0}", null, null, connection);
            return connection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public Connection getConnection(Properties properties) throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "entering args ({0})", null, null, properties);
            this.trace(Level.FINEST, CLASS_NAME, "getConnection", "PoolXADataSourceImpl.getConnection() is disabled", null, null, new Object[0]);
            UCPErrorHandler.throwSQLException(58, null);
            Connection connection = null;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "returning {0}", null, null, connection);
            return connection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public Connection getConnection(String string, @Blind String string2, Properties properties) throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "entering args ({0}, {1}, {2})", null, null, string, new StringBlinder().blind(string2), properties);
            this.trace(Level.FINEST, CLASS_NAME, "getConnection", "PoolXADataSourceImpl.getConnection() is disabled", null, null, new Object[0]);
            UCPErrorHandler.throwSQLException(58, null);
            Connection connection = null;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "returning {0}", null, null, connection);
            return connection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public XAConnection getXAConnection() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "entering args ()", null, null, new Object[0]);
            XAConnection xAConnection = this.getXAConnection(this.getUser(), this.getPasswordReal(), null);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "returning {0}", null, null, xAConnection);
            return xAConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public XAConnection getXAConnection(String string, @Blind String string2) throws SQLException {
        try {
            void password;
            void user;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "entering args ({0}, {1})", null, null, string, new StringBlinder().blind(string2));
            XAConnection xAConnection = this.getXAConnection((String)user, (String)password, null);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "returning {0}", null, null, xAConnection);
            return xAConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public XAConnection getXAConnection(Properties properties) throws SQLException {
        try {
            void labels;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "entering args ({0})", null, null, properties);
            XAConnection xAConnection = this.getXAConnection(this.getUser(), this.getPasswordReal(), (Properties)labels);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "returning {0}", null, null, xAConnection);
            return xAConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public XAConnection getXAConnection(String string, @Blind String string2, Properties properties) throws SQLException {
        try {
            void labels;
            void password;
            void username;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "entering args ({0}, {1}, {2})", null, null, string, new StringBlinder().blind(string2), properties);
            if (Objects.nonNull(username) && Objects.isNull(this.getUser())) {
                this.setUser((String)username);
            }
            if (Objects.nonNull(password) && Objects.isNull(this.getPasswordReal())) {
                this.setPassword((String)password);
            }
            UCPXAConnectionBuilder cb = this.createXAConnectionBuilder().labels((Properties)labels);
            if (Objects.nonNull(username)) {
                cb.user((String)username);
            }
            if (Objects.nonNull(password)) {
                cb.password((String)password);
            }
            XAConnection xAConnection = cb.build();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "returning {0}", null, null, xAConnection);
            return xAConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    protected Connection getConnection(UCPConnectionBuilderImpl uCPConnectionBuilderImpl) throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "entering args ({0})", null, null, uCPConnectionBuilderImpl);
            if (WLSJTAPlugin.jtaWLSEnabled) {
                void builder;
                this.trace(Level.FINEST, CLASS_NAME, "getConnection", "WLS/JTA support enabled, allow PoolXADataSourceImpl.getConnection(ucpConnBuilder)", null, null, new Object[0]);
                UCPXAConnectionBuilderImpl xaBuilder = (UCPXAConnectionBuilderImpl)this.createXAConnectionBuilder((UCPConnectionBuilderImpl)builder);
                Connection connection = this.getXAConnection(xaBuilder).getConnection();
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "returning {0}", null, null, connection);
                return connection;
            }
            this.trace(Level.FINEST, CLASS_NAME, "getConnection", "PoolXADataSourceImpl.getConnection(ucpConnBuilder) is disabled", null, null, new Object[0]);
            UCPErrorHandler.throwSQLException(58, null);
            Connection connection = null;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "returning {0}", null, null, connection);
            return connection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    XAConnection getXAConnection(UCPXAConnectionBuilderImpl uCPXAConnectionBuilderImpl) throws SQLException {
        try {
            void builder;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "entering args ({0})", null, null, uCPXAConnectionBuilderImpl);
            BorrowContextUpdater bcu = builder.getBorrowContextUpdater();
            String user = this.getUser();
            String bcuUser = bcu.getUser();
            OpaqueString pwd = this.getPasswordInternal();
            OpaqueString bcuPwd = bcu.getPassword();
            boolean keepMetadataConn = Objects.equals(user, bcuUser) && Objects.equals(pwd, bcuPwd);
            JDBCConnectionRetrievalInfo cri = new JDBCConnectionRetrievalInfo(this, bcu);
            this.startPool(cri, keepMetadataConn);
            XAConnection xaconn = null;
            try {
                JDBCUniversalPooledConnection jdbcPooledConnection = (JDBCUniversalPooledConnection)this.connectionPool.borrowConnection(cri);
                jdbcPooledConnection.setMaxStatements(this.connectionPool.getMaxStatements());
                xaconn = this.connectionPool.getProxyFactory().proxyForXAConnection(this.connectionPool, jdbcPooledConnection);
                WLSJTAPlugin.registerXAResource(xaconn.getXAResource(), this.getDataSourceName());
            }
            catch (NoAvailableConnectionsException e) {
                UCPErrorHandler.throwSQLException(28, e);
            }
            catch (UniversalConnectionPoolException e) {
                UCPErrorHandler.throwSQLException(29, e);
            }
            XAConnection xAConnection = xaconn;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "returning {0}", null, null, xAConnection);
            return xAConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolXADataSourceImpl", "getXAConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private CompletionStage<XAConnection> getXAConnectionAsync(UCPXAConnectionBuilderImpl builder) {
        CompletableFuture<XAConnection> cf = new CompletableFuture<XAConnection>();
        Executor executor = builder.executor;
        BorrowContextUpdater bcu = builder.getBorrowContextUpdater();
        boolean keepMetadataConn = Objects.equals(this.getUser(), bcu.getUser()) && Objects.equals(this.getPasswordReal(), bcu.getPassword().get());
        JDBCConnectionRetrievalInfo cri = new JDBCConnectionRetrievalInfo(this, bcu);
        ((CompletableFuture)CompletableFuture.runAsync(() -> {
            try {
                this.trace(Level.FINEST, CLASS_NAME, "getXAConnectionAsync", "about to start pool", null, null, new Object[0]);
                this.startPool(cri, keepMetadataConn);
                this.trace(Level.FINEST, CLASS_NAME, "getXAConnectionAsync", "pool started successfully", null, null, new Object[0]);
            }
            catch (Throwable e) {
                this.trace(Level.WARNING, CLASS_NAME, "getXAConnectionAsync", "", null, e, new Object[0]);
                cf.completeExceptionally(e);
            }
        }, executor).thenComposeAsync(p -> this.connectionPool.borrowConnectionAsync(cri, executor))).whenCompleteAsync((p, e) -> {
            if (Objects.nonNull(e)) {
                cf.completeExceptionally(UCPErrorHandler.newSQLException(28, e));
            }
            if (Objects.isNull(p)) {
                this.trace(Level.FINEST, CLASS_NAME, "getXAConnectionAsync", "no connection borrowed", null, null, new Object[0]);
                cf.complete(null);
                return;
            }
            XAConnection xaconn = null;
            try {
                JDBCUniversalPooledConnection jdbcConn = (JDBCUniversalPooledConnection)p;
                jdbcConn.setMaxStatements(this.connectionPool.getMaxStatements());
                xaconn = this.connectionPool.getProxyFactory().proxyForXAConnection(this.connectionPool, jdbcConn);
                WLSJTAPlugin.registerXAResource(xaconn.getXAResource(), this.getDataSourceName());
            }
            catch (SQLException e2) {
                cf.completeExceptionally(e2);
            }
            this.trace(Level.FINEST, CLASS_NAME, "getXAConnectionAsync", "connection is borrowed, xaconn={0}", null, null, xaconn);
            cf.complete(xaconn);
        });
        return cf;
    }

    @Override
    public UCPXAConnectionBuilder createXAConnectionBuilder() {
        return this.createXAConnectionBuilder(null);
    }

    private UCPXAConnectionBuilder createXAConnectionBuilder(UCPConnectionBuilderImpl builder) {
        return new UCPXAConnectionBuilderImpl(builder){

            @Override
            public XAConnection build() throws SQLException {
                return PoolXADataSourceImpl.this.getXAConnection(this);
            }

            @Override
            public CompletionStage<XAConnection> buildAsyncOracle() {
                return Util.simulateAsyncBorrow() ? this.buildAsyncOracleSimulate() : this.buildAsyncOracleReal();
            }

            private CompletionStage<XAConnection> buildAsyncOracleSimulate() {
                CompletableFuture<XAConnection> f = new CompletableFuture<XAConnection>();
                CompletableFuture.runAsync(() -> {
                    try {
                        XAConnection conn = this.build();
                        f.complete(conn);
                    }
                    catch (Throwable e) {
                        f.completeExceptionally(e);
                    }
                }, this.executor);
                return f;
            }

            private CompletionStage<XAConnection> buildAsyncOracleReal() {
                return PoolXADataSourceImpl.this.getXAConnectionAsync(this);
            }

            @Override
            public Flow.Publisher<XAConnection> buildConnectionPublisherOracle() {
                return new PoolDataSourceImpl.ConnectionPublisher(this);
            }
        };
    }
}

