/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.RACCallbackGuard;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.jdbc.oracle.rlb.ConnectionsDispatcher;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.Policy;
import oracle.ucp.jdbc.oracle.rlb.PolicyImpl;
import oracle.ucp.util.Util;

public class OracleDatabaseInstanceInfoList
implements Diagnosable {
    static final String CLASS_NAME = OracleDatabaseInstanceInfoList.class.getName();
    private final ReentrantLock databaseInstanceInfoLock = new ReentrantLock();
    private final Instances instances = new Instances();
    private Policy rlbPolicy;
    private final RACManagerImpl m_racMngr;
    private static final String CONNECT_DATA_KEYWORD = "CONNECT_DATA";
    private OracleDatabaseInstanceInfo lastUsedInstanceToGrow;

    public Collection<OracleDatabaseInstanceInfo> getAllInstances() {
        return this.instances.getAllInstances();
    }

    public OracleDatabaseInstanceInfoList(RACManagerImpl racMngr) {
        String sPolicy = null;
        try {
            sPolicy = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty("oracle.ucp.jdbc.oracle.rlb.policy");
                }
            });
            this.rlbPolicy = null == sPolicy || "".equals(sPolicy) ? new PolicyImpl() : (Policy)Class.forName(sPolicy).newInstance();
        }
        catch (Exception e) {
            this.trace(Level.WARNING, CLASS_NAME, "createConnection", "unable to use policy class {0}, using default RLB policy instead", null, null, sPolicy);
            this.rlbPolicy = new PolicyImpl();
        }
        this.lastUsedInstanceToGrow = null;
        this.m_racMngr = racMngr;
        this.rlbPolicy.plugRLBInfo(this.m_racMngr.rlbMetricsAccumulator);
        this.rlbPolicy.plugConnectionsDispatcher(new ConnectionsDispatcher(){

            @Override
            public FailoverablePooledConnection borrowConnection(OracleDatabaseInstanceInfo dbInstance, ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
                return OracleDatabaseInstanceInfoList.this.m_racMngr.getRACCallback().getAvailableConnectionToInstance(cri, new RACInstanceImpl(dbInstance));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatabaseInstanceInfo(OracleDatabaseInstanceInfo dbInfo, boolean isForFailover, boolean isAddingConnection) {
        this.databaseInstanceInfoLock.lock();
        try {
            int instId;
            Integer instNum = this.instances.getId(dbInfo);
            int n = instId = instNum != null ? instNum : -1;
            if (isForFailover) {
                if (instId != -1) {
                    if (isAddingConnection && instId != dbInfo.getId()) {
                        this.trace(Level.FINEST, CLASS_NAME, "updateDatabaseInstanceInfo", "name->id mapping out-of-sync, instance={0}, id={1}, id-in-table={2}", null, null, dbInfo.getInstanceName(), dbInfo.getId(), instId);
                        return;
                    }
                    OracleDatabaseInstanceInfo dbInstance = this.instances.getInstance(instId);
                    if (isAddingConnection) {
                        dbInstance.incrementNumberOfConnectionsCount();
                        if (dbInstance.status == 2) {
                            dbInstance.status = 1;
                        }
                    } else {
                        dbInstance.decrementNumberOfConnectionsCount();
                    }
                } else {
                    dbInfo.incrementNumberOfConnectionsCount();
                    this.setNamedInstanceUrl(dbInfo, dbInfo.getInstanceName());
                    dbInfo.status = 1;
                    if (dbInfo.getId() >= 0) {
                        this.instances.add(dbInfo, dbInfo.getId());
                    }
                }
            } else if (instId >= 0) {
                OracleDatabaseInstanceInfo dbInstance = this.instances.getInstance(instId);
                dbInstance.setAdvisoryPercent(dbInfo.getAdvisoryPercent());
                dbInstance.flag = dbInfo.flag;
            }
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    private void setNamedInstanceUrl(OracleDatabaseInstanceInfo dbInfo, String instanceName) {
        StringBuffer urlBuf = new StringBuffer(this.m_racMngr.getRACCallback().getUrl());
        int keywordIndex = urlBuf.indexOf(CONNECT_DATA_KEYWORD);
        if (keywordIndex == -1) {
            dbInfo.setNamedInstanceUrl(null);
            this.trace(Level.FINEST, CLASS_NAME, "setNamedInstanceUrl", "connect data keyword not found", null, null, new Object[0]);
        } else {
            int equalSignIndex = urlBuf.indexOf("=", keywordIndex + CONNECT_DATA_KEYWORD.length());
            if (equalSignIndex == -1) {
                dbInfo.setNamedInstanceUrl(null);
                this.trace(Level.FINEST, CLASS_NAME, "setNamedInstanceUrl", "equal sign was not found", null, null, new Object[0]);
            } else {
                urlBuf.insert(equalSignIndex + 1, "(INSTANCE_NAME=" + instanceName + ")");
                dbInfo.setNamedInstanceUrl(urlBuf.toString());
            }
        }
        this.trace(Level.FINEST, CLASS_NAME, "setNamedInstanceUrl", "instance={0}, namedInstanceUrl={1}", null, null, dbInfo.getInstanceName(), urlBuf.toString());
    }

    public boolean isNamedInstanceConnectingAllowed(String instanceName, String dbUniqName, boolean isInstanceAffinityEnabled) {
        int instId;
        RACCallbackGuard cbk = this.m_racMngr.getRACCallback();
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(dbUniqName, instanceName);
        Integer instNum = this.instances.getId(tmpInstance);
        int n = instId = instNum != null ? instNum : -1;
        if (instId < 0) {
            this.trace(Level.FINEST, CLASS_NAME, "isNamedInstanceConnectingAllowed", "instId < 0", null, null, new Object[0]);
            return false;
        }
        OracleDatabaseInstanceInfo dbInstance = this.instances.getInstance(instId);
        if (dbInstance == null) {
            this.trace(Level.FINEST, CLASS_NAME, "isNamedInstanceConnectingAllowed", "dbInstance is null", null, null, new Object[0]);
            return false;
        }
        if (dbInstance.status == 1 && dbInstance.flag <= 3) {
            int connNumThreshold;
            this.trace(Level.FINEST, CLASS_NAME, "isNamedInstanceConnectingAllowed", "instance is alive", null, null, new Object[0]);
            int dbVersion = this.m_racMngr.getDatabaseVersion();
            if (dbVersion >= 11100 || !isInstanceAffinityEnabled) {
                this.trace(Level.FINEST, CLASS_NAME, "isNamedInstanceConnectingAllowed", "recent RAC version or instance affinity not enabled", null, null, new Object[0]);
                float advisoryPercent = 0 == this.m_racMngr.rlbMetricsAccumulator.getReel().size() ? 100.0f / (float)this.getUpInstancesCount() : dbInstance.getAdvisoryPercent();
                this.trace(Level.FINEST, CLASS_NAME, "isNamedInstanceConnectingAllowed", "advisoryPercent={0}, roomToGrowPool={1}", null, null, Float.valueOf(advisoryPercent), cbk.getRoomToGrowPool());
                connNumThreshold = Math.round(advisoryPercent * (float)cbk.getMaxPoolSize() / 100.0f);
            } else {
                this.trace(Level.FINEST, CLASS_NAME, "isNamedInstanceConnectingAllowed", "older RAC version and instance affinity enabled", null, null, new Object[0]);
                connNumThreshold = cbk.getRoomToGrowPool() + dbInstance.getNumNamedInstanceConns();
            }
            this.trace(Level.FINEST, CLASS_NAME, "isNamedInstanceConnectingAllowed", "dbVersion={0}, threshold={1}, connNum={2}", null, null, dbVersion, connNumThreshold, dbInstance.getNumberOfConnectionsCount());
            return connNumThreshold > dbInstance.getNumberOfConnectionsCount();
        }
        this.trace(Level.FINEST, CLASS_NAME, "isNamedInstanceConnectingAllowed", "instance is not alive", null, null, new Object[0]);
        return false;
    }

    public int size() {
        return this.instances.size();
    }

    public RACInstance getMostDesirableInstanceToGrow() {
        StringBuilder sb = new StringBuilder();
        sb.append("most desirable instance to grow: ");
        int maxConnsToGrow = Integer.MIN_VALUE;
        OracleDatabaseInstanceInfo instanceToGrow = this.lastUsedInstanceToGrow;
        for (Map.Entry<OracleDatabaseInstanceInfo, Integer> rlbPolicyEntry : this.rlbPolicy.getCurrentRebalancePolicy().entrySet()) {
            OracleDatabaseInstanceInfo dbInstance = rlbPolicyEntry.getKey();
            int rebalanceCount = rlbPolicyEntry.getValue();
            sb.append("(").append(dbInstance.getInstanceName()).append(":").append(rebalanceCount).append(")");
            OracleDatabaseInstanceInfo.RebalancingState state = dbInstance.getRebalancingState();
            if (OracleDatabaseInstanceInfo.RebalancingState.SHRINKING == state || OracleDatabaseInstanceInfo.RebalancingState.SHRUNK == state || rebalanceCount <= 0 || rebalanceCount <= maxConnsToGrow) continue;
            this.lastUsedInstanceToGrow = instanceToGrow = dbInstance;
            maxConnsToGrow = rebalanceCount;
        }
        if (null != instanceToGrow) {
            sb.append(" grow on ").append(instanceToGrow.getInstanceName());
            instanceToGrow.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.GROWING);
        } else {
            sb.append("no instance to grow");
        }
        this.trace(Level.FINEST, CLASS_NAME, "getMostDesirableInstanceToGrow", "{0}", null, null, sb.toString());
        return null == instanceToGrow ? null : new RACInstanceImpl(instanceToGrow);
    }

    public FailoverablePooledConnection selectConnectionPerRLBMetrics(ConnectionRetrievalInfo cri, RACManagerImpl racMngr) throws UniversalConnectionPoolException {
        FailoverablePooledConnection pc = this.rlbPolicy.borrowConnection(cri);
        if (pc != null) {
            racMngr.incrementSuccessfulRCLBBasedBorrowCount();
        } else {
            racMngr.incrementFailedRCLBBasedBorrowCount();
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleInstancesForGravitation(BlockingQueue<OracleDatabaseInstanceInfo> instancesToGravitateQueue) {
        this.databaseInstanceInfoLock.lock();
        try {
            for (Map.Entry<OracleDatabaseInstanceInfo, Integer> rlbPolicyEntry : this.rlbPolicy.getCurrentRebalancePolicy().entrySet()) {
                OracleDatabaseInstanceInfo dbInstance = rlbPolicyEntry.getKey();
                int rebalanceCount = rlbPolicyEntry.getValue();
                OracleDatabaseInstanceInfo.RebalancingState state = dbInstance.getRebalancingState();
                if (OracleDatabaseInstanceInfo.RebalancingState.GROWING == state || rebalanceCount >= 0) continue;
                String msg = "gravitate " + dbInstance.getInstanceName() + ", " + rebalanceCount + " connections";
                this.trace(Level.FINEST, CLASS_NAME, "scheduleInstancesForGravitation", "{0}", null, null, msg);
                dbInstance.setConnsToTearDown(Math.abs(rebalanceCount));
                dbInstance.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.SHRINKING);
                instancesToGravitateQueue.add(dbInstance);
            }
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public boolean useGoodGroup() {
        float goodGroupPercent = 0.0f;
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (1 != dbInstance.status || 4 == dbInstance.flag || 5 == dbInstance.flag) continue;
            goodGroupPercent += dbInstance.getAdvisoryPercent();
        }
        return goodGroupPercent > 0.0f;
    }

    private FailoverablePooledConnection getConnectionToNamedInstance(OracleDatabaseInstanceInfo dbInstance, boolean forQueryInstanceId) {
        FailoverablePooledConnection fpc = null;
        String namedInstanceUrl = dbInstance.getNamedInstanceUrl();
        try {
            RACInstanceImpl racInstance = new RACInstanceImpl(dbInstance);
            fpc = this.m_racMngr.getRACCallback().openNewConnection(namedInstanceUrl, racInstance);
        }
        catch (Exception exc) {
            fpc = null;
            this.trace(Level.WARNING, CLASS_NAME, "getConnectionToNamedInstance", "", null, exc, new Object[0]);
        }
        if (fpc != null) {
            fpc.setAsNamedInstanceConnection();
            if (!forQueryInstanceId) {
                dbInstance.incrementNumNamedInstanceConns();
            }
        }
        return fpc;
    }

    public void markUpInstanceForUpEvent(String upServiceName, String upInstanceName, String upHostName, String upDbName) {
        int upInstId;
        OracleDatabaseInstanceInfo upInstance = new OracleDatabaseInstanceInfo(upDbName, upInstanceName, upHostName);
        upInstance.setServiceName(upServiceName);
        Integer instNum = this.instances.getId(upInstance);
        int n = upInstId = instNum != null ? instNum : -1;
        if (upInstId != -1) {
            upInstance = this.instances.getInstance(upInstId);
            upInstance.status = 1;
        } else {
            this.setNamedInstanceUrl(upInstance, upInstance.getInstanceName());
            upInstance.status = 1;
            FailoverablePooledConnection namedInstanceConn = this.getConnectionToNamedInstance(upInstance, true);
            if (null != namedInstanceConn) {
                int newInstanceId = namedInstanceConn.getInstanceNumber();
                if (newInstanceId >= 0) {
                    this.instances.add(upInstance, newInstanceId);
                }
                try {
                    namedInstanceConn.close(false);
                }
                catch (UniversalConnectionPoolException exc) {
                    this.trace(Level.WARNING, CLASS_NAME, "markUpInstanceForUpEvent", "", null, exc, new Object[0]);
                }
            } else {
                this.trace(Level.FINEST, CLASS_NAME, "markUpInstanceForUpEvent", "namedInstanceConn is null", null, null, new Object[0]);
            }
        }
    }

    public void markDownInstanceForServiceDownEvent(String downInstanceName, String downDbName) {
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (downInstanceName == null) {
                dbInstance.status = 2;
                continue;
            }
            if (!Util.sameOrEqual(downDbName, dbInstance.getDatabaseName()) || !Util.sameOrEqual(downInstanceName, dbInstance.getInstanceName())) continue;
            dbInstance.status = 2;
        }
    }

    public void markDownInstanceForHostDownEvent(String downHostName) {
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (!Util.sameOrEqual(downHostName, dbInstance.getHostName())) continue;
            dbInstance.status = 2;
        }
    }

    public int getUpInstancesCount() {
        int upCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (dbInstance.status != 1) continue;
            ++upCount;
        }
        return upCount;
    }

    public OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(String instanceName, String databaseName) {
        return this.instances.getInstance(databaseName, instanceName);
    }

    public OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(int instanceId) {
        return this.instances.getInstance(instanceId);
    }

    public INSTANCE_CATEGORY_FOR_DATA_AFFINITY getInstanceCategory(OracleDatabaseInstanceInfo dbInstance) {
        String instanceKey = this.m_racMngr.generateDatabaseInstanceKey(dbInstance.getInstanceName(), dbInstance.getDatabaseName(), dbInstance.getServiceName());
        boolean affinityHint = this.m_racMngr.getConnectionAffinityValue(instanceKey);
        if (dbInstance.status == 1 && (dbInstance.flag == 1 || dbInstance.flag == 2) && affinityHint) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.GOOD_INSTANCE;
        }
        if (!(dbInstance.status != 1 || dbInstance.flag != 3 && affinityHint)) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.VIOLATING_INSTANCE;
        }
        return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.BAD_INSTANCE;
    }

    public Collection<OracleDatabaseInstanceInfo> getRacMetadata() {
        return this.instances.getAllInstances();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return DiagnosticsCollectorImpl.getCommon();
    }

    public static class Instances {
        private static final String BROKEN = "instance info base integrity is broken";
        private final ReentrantLock databaseInstanceLock = new ReentrantLock();
        private Map<OracleDatabaseInstanceInfo, Integer> instanceToId = new HashMap<OracleDatabaseInstanceInfo, Integer>();
        private Map<Integer, OracleDatabaseInstanceInfo> idToInstance = new HashMap<Integer, OracleDatabaseInstanceInfo>();

        OracleDatabaseInstanceInfo getInstance(int id) {
            this.databaseInstanceLock.lock();
            try {
                assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
                assert (id >= 0) : "negative id";
                OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = this.idToInstance.get(id);
                return oracleDatabaseInstanceInfo;
            }
            finally {
                this.databaseInstanceLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OracleDatabaseInstanceInfo getInstance(String databaseName, String instanceName) {
            this.databaseInstanceLock.lock();
            try {
                assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
                OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = this.idToInstance.get(this.instanceToId.get(new OracleDatabaseInstanceInfo(databaseName, instanceName)));
                return oracleDatabaseInstanceInfo;
            }
            finally {
                this.databaseInstanceLock.unlock();
            }
        }

        Collection<OracleDatabaseInstanceInfo> getAllInstances() {
            this.databaseInstanceLock.lock();
            try {
                assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
                ArrayList<OracleDatabaseInstanceInfo> arrayList = new ArrayList<OracleDatabaseInstanceInfo>(this.idToInstance.values());
                return arrayList;
            }
            finally {
                this.databaseInstanceLock.unlock();
            }
        }

        Integer getId(OracleDatabaseInstanceInfo instance) {
            this.databaseInstanceLock.lock();
            try {
                assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
                Integer n = this.instanceToId.get(instance);
                return n;
            }
            finally {
                this.databaseInstanceLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(OracleDatabaseInstanceInfo instance, int id) {
            this.databaseInstanceLock.lock();
            try {
                assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
                assert (id >= 0) : "negative id";
                assert (null != instance) : "instance is null";
                Integer oldId = this.instanceToId.get(instance);
                OracleDatabaseInstanceInfo oldInstance = this.idToInstance.get(id);
                if (null != oldId && oldId.equals(id) && null != oldInstance && oldInstance.equals(instance)) {
                    return;
                }
                assert (null == oldId && null == oldInstance) : "some other pair with either given instance or id has been previously written";
                this.instanceToId.put(instance, id);
                this.idToInstance.put(id, instance);
            }
            finally {
                this.databaseInstanceLock.unlock();
            }
        }

        int size() {
            this.databaseInstanceLock.lock();
            try {
                assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
                int n = this.instanceToId.size();
                return n;
            }
            finally {
                this.databaseInstanceLock.unlock();
            }
        }
    }

    public static enum INSTANCE_CATEGORY_FOR_DATA_AFFINITY {
        GOOD_INSTANCE,
        VIOLATING_INSTANCE,
        BAD_INSTANCE;

    }
}

