/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u05e4\u05bf\u05d9\u05d3\u05d6\u05e9\u05d9";
        final String metaValue_ar = "\u05d0\u05b7\u05e8\u05d0\u05b7\u05d1\u05d9\u05e9";
        final String metaValue_el = "\u05d2\u05e8\u05d9\u05db\u05d9\u05e9";
        final Object[][] data = new Object[][] {
            { "001", "\u05d5\u05d5\u05e2\u05dc\u05d8" },
            { "002", "\u05d0\u05b7\u05e4\u05bf\u05e8\u05d9\u05e7\u05e2" },
            { "003", "\u05e6\u05e4\u05d5\u05df\u05be\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "005", "\u05d3\u05e8\u05d5\u05dd\u05be\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "009", "\u05d0\u05e7\u05e2\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "013", "\u05e6\u05e2\u05e0\u05d8\u05e8\u05d0\u05b7\u05dc\u05be\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "019", "\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "021", "\u05e6\u05e4\u05d5\u05e0\u05d3\u05d9\u05e7\u05e2 \u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "029", "\u05e7\u05d0\u05b7\u05e8\u05d0\u05b7\u05d0\u05d9\u05d1\u05e2" },
            { "030", "\u05de\u05d6\u05e8\u05d7 \u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "034", "\u05d3\u05e8\u05d5\u05dd\u05be\u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "035", "\u05d3\u05e8\u05d5\u05dd\u05be\u05de\u05d6\u05e8\u05d7 \u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "039", "\u05d3\u05e8\u05d5\u05dd\u05be\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "061", "\u05e4\u05bc\u05d0\u05dc\u05d9\u05e0\u05e2\u05d6\u05d9\u05e2" },
            { "142", "\u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "143", "\u05e6\u05e2\u05e0\u05d8\u05e8\u05d0\u05b7\u05dc\u05be\u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "145", "\u05de\u05e2\u05e8\u05d1\u05be\u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "150", "\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "151", "\u05de\u05d6\u05e8\u05d7\u05be\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "154", "\u05e6\u05e4\u05bf\u05d5\u05df\u05be\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "155", "\u05de\u05e2\u05e8\u05d1\u05be\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "419", "\u05dc\u05d0\u05b7\u05d8\u05d9\u05d9\u05df\u05be\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "AD", "\u05d0\u05b7\u05e0\u05d3\u05d0\u05e8\u05e2" },
            { "AF", "\u05d0\u05b7\u05e4\u05bf\u05d2\u05d4\u05d0\u05b7\u05e0\u05d9\u05e1\u05d8\u05d0\u05b7\u05df" },
            { "AG", "\u05d0\u05b7\u05e0\u05d8\u05d9\u05d2\u05d5\u05e2 \u05d0\u05d5\u05df \u05d1\u05d0\u05b7\u05e8\u05d1\u05d5\u05d3\u05e2" },
            { "AL", "\u05d0\u05b7\u05dc\u05d1\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "AM", "\u05d0\u05b7\u05e8\u05de\u05e2\u05e0\u05d9\u05e2" },
            { "AO", "\u05d0\u05b7\u05e0\u05d2\u05d0\u05dc\u05e2" },
            { "AQ", "\u05d0\u05b7\u05e0\u05d8\u05d0\u05b7\u05e8\u05e7\u05d8\u05d9\u05e7\u05e2" },
            { "AR", "\u05d0\u05b7\u05e8\u05d2\u05e2\u05e0\u05d8\u05d9\u05e0\u05e2" },
            { "AT", "\u05e2\u05e1\u05d8\u05e8\u05d9\u05d9\u05da" },
            { "AU", "\u05d0\u05d5\u05d9\u05e1\u05d8\u05e8\u05d0\u05b7\u05dc\u05d9\u05e2" },
            { "AW", "\u05d0\u05b7\u05e8\u05d5\u05d1\u05d0\u05b7" },
            { "BA", "\u05d1\u05d0\u05e1\u05e0\u05d9\u05e2 \u05d4\u05e2\u05e8\u05e6\u05e2\u05d2\u05d0\u05d5\u05d5\u05d9\u05e0\u05e2" },
            { "BB", "\u05d1\u05d0\u05b7\u05e8\u05d1\u05d0\u05b7\u05d3\u05d0\u05e1" },
            { "BD", "\u05d1\u05d0\u05b7\u05e0\u05d2\u05dc\u05d0\u05b7\u05d3\u05e2\u05e9" },
            { "BE", "\u05d1\u05e2\u05dc\u05d2\u05d9\u05e2" },
            { "BF", "\u05d1\u05d5\u05e8\u05e7\u05d9\u05e0\u05e2 \u05e4\u05bf\u05d0\u05b7\u05e1\u05d0" },
            { "BG", "\u05d1\u05d5\u05dc\u05d2\u05d0\u05b7\u05e8\u05d9\u05e2" },
            { "BI", "\u05d1\u05d5\u05e8\u05d5\u05e0\u05d3\u05d9" },
            { "BJ", "\u05d1\u05e2\u05e0\u05d9\u05df" },
            { "BM", "\u05d1\u05e2\u05e8\u05de\u05d5\u05d3\u05e2" },
            { "BN", "\u05d1\u05e8\u05d5\u05e0\u05d9\u05d9" },
            { "BO", "\u05d1\u05d0\u05dc\u05d9\u05d5\u05d5\u05d9\u05e2" },
            { "BR", "\u05d1\u05e8\u05d0\u05b7\u05d6\u05d9\u05dc" },
            { "BS", "\u05d1\u05d0\u05b7\u05d4\u05d0\u05b7\u05de\u05d0\u05b7\u05e1" },
            { "BT", "\u05d1\u05d4\u05d5\u05d8\u05d0\u05b7\u05df" },
            { "BW", "\u05d1\u05d0\u05e6\u05d5\u05d5\u05d0\u05b7\u05e0\u05e2" },
            { "BY", "\u05d1\u05e2\u05dc\u05d0\u05b7\u05e8\u05d5\u05e1" },
            { "BZ", "\u05d1\u05e2\u05dc\u05d9\u05d6" },
            { "CA", "\u05e7\u05d0\u05b7\u05e0\u05d0\u05b7\u05d3\u05e2" },
            { "CD", "\u05e7\u05d0\u05e0\u05d2\u05d0\u05be\u05e7\u05d9\u05e0\u05e9\u05d0\u05b7\u05d6\u05e2" },
            { "CF", "\u05e6\u05e2\u05e0\u05d8\u05e8\u05d0\u05b7\u05dc\u05be\u05d0\u05b7\u05e4\u05bf\u05e8\u05d9\u05e7\u05d0\u05b7\u05e0\u05d9\u05e9\u05e2 \u05e8\u05e2\u05e4\u05bc\u05d5\u05d1\u05dc\u05d9\u05e7" },
            { "CH", "\u05e9\u05d5\u05d5\u05d9\u05d9\u05e5" },
            { "CI", "\u05d4\u05e2\u05dc\u05e4\u05bf\u05d0\u05b7 \u05e0\u05d3\u05d1\u05d9\u05d9\u05df \u05d1\u05d0\u05e8\u05d8\u05df" },
            { "CK", "\u05e7\u05d5\u05e7 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "CL", "\u05d8\u05e9\u05d9\u05dc\u05e2" },
            { "CM", "\u05e7\u05d0\u05b7\u05de\u05e2\u05e8\u05d5\u05df" },
            { "CN", "\u05db\u05d9\u05e0\u05e2" },
            { "CO", "\u05e7\u05d0\u05dc\u05d0\u05de\u05d1\u05d9\u05e2" },
            { "CR", "\u05e7\u05d0\u05e1\u05d8\u05d0\u05b7 \u05e8\u05d9\u05e7\u05d0\u05b7" },
            { "CU", "\u05e7\u05d5\u05d1\u05d0\u05b7" },
            { "CV", "\u05e7\u05d0\u05b7\u05e4\u05bc\u05d5\u05d5\u05e2\u05e8\u05d3\u05d9\u05e9\u05e2 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "CW", "\u05e7\u05d5\u05e8\u05d0\u05b7\u05e1\u05d0\u05b7\u05d0" },
            { "CZ", "\u05d8\u05e9\u05e2\u05db\u05d9\u05d9" },
            { "DE", "\u05d3\u05d9\u05d9\u05d8\u05e9\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "DJ", "\u05d3\u05d6\u05e9\u05d9\u05d1\u05d5\u05d8\u05d9" },
            { "DK", "\u05d3\u05e2\u05e0\u05de\u05d0\u05b7\u05e8\u05e7" },
            { "DM", "\u05d3\u05d0\u05de\u05d9\u05e0\u05d9\u05e7\u05e2" },
            { "DO", "\u05d3\u05d0\u05de\u05d9\u05e0\u05d9\u05e7\u05d0\u05b7\u05e0\u05d9\u05e9\u05e2 \u05e8\u05e2\u05e4\u05bc\u05d5\u05d1\u05dc\u05d9\u05e7" },
            { "EC", "\u05e2\u05e7\u05d5\u05d5\u05d0\u05b7\u05d3\u05d0\u05e8" },
            { "EE", "\u05e2\u05e1\u05d8\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "EG", "\u05e2\u05d2\u05d9\u05e4\u05bc\u05d8\u05df" },
            { "ER", "\u05e2\u05e8\u05d9\u05d8\u05e8\u05e2\u05e2" },
            { "ES", "\u05e9\u05e4\u05bc\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "ET", "\u05e2\u05d8\u05d9\u05d0\u05e4\u05bc\u05d9\u05e2" },
            { "EU", "\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2\u05d9\u05e9\u05e2\u05e8 \u05e4\u05bf\u05d0\u05b7\u05e8\u05d1\u05d0\u05b7\u05e0\u05d3" },
            { "FI", "\u05e4\u05bf\u05d9\u05e0\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "FJ", metaValue_FJ },
            { "FK", "\u05e4\u05bf\u05d0\u05b7\u05dc\u05e7\u05dc\u05d0\u05b7\u05e0\u05d3 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "FM", "\u05de\u05d9\u05e7\u05e8\u05d0\u05e0\u05e2\u05d6\u05d9\u05e2" },
            { "FO", "\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "FR", "\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e7\u05e8\u05d9\u05d9\u05da" },
            { "GA", "\u05d2\u05d0\u05b7\u05d1\u05d0\u05df" },
            { "GB", "\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0\u05d9\u05d9\u05e0\u05d9\u05d2\u05d8\u05e2 \u05e7\u05e2\u05e0\u05d9\u05d2\u05e8\u05d9\u05d9\u05da" },
            { "GD", "\u05d2\u05e8\u05e2\u05e0\u05d0\u05b7\u05d3\u05d0\u05b7" },
            { "GE", "\u05d2\u05e8\u05d5\u05d6\u05d9\u05e2" },
            { "GF", "\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9\u05e2 \u05d2\u05d5\u05d9\u05d0\u05b7\u05e0\u05e2" },
            { "GG", "\u05d2\u05e2\u05e8\u05e0\u05d6\u05d9" },
            { "GH", "\u05d2\u05d4\u05d0\u05b7\u05e0\u05e2" },
            { "GI", "\u05d2\u05d9\u05d1\u05e8\u05d0\u05b7\u05dc\u05d8\u05d0\u05b7\u05e8" },
            { "GL", "\u05d2\u05e8\u05d9\u05e0\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "GM", "\u05d2\u05d0\u05b7\u05de\u05d1\u05d9\u05e2" },
            { "GN", "\u05d2\u05d9\u05e0\u05e2" },
            { "GP", "\u05d2\u05d5\u05d5\u05d0\u05b7\u05d3\u05e2\u05dc\u05d5\u05e4" },
            { "GQ", "\u05e2\u05e7\u05d5\u05d5\u05d0\u05b7\u05d8\u05d0\u05e8\u05d9\u05e9\u05e2 \u05d2\u05d9\u05e0\u05e2" },
            { "GR", "\u05d2\u05e8\u05d9\u05db\u05e0\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "GT", "\u05d2\u05d5\u05d5\u05d0\u05b7\u05d8\u05e2\u05de\u05d0\u05b7\u05dc\u05e2" },
            { "GU", "\u05d2\u05d5\u05d5\u05d0\u05b7\u05dd" },
            { "GW", "\u05d2\u05d9\u05e0\u05e2\u05be\u05d1\u05d9\u05e1\u05d0\u05b7\u05d5" },
            { "GY", "\u05d2\u05d5\u05d9\u05d0\u05b7\u05e0\u05e2" },
            { "HN", "\u05d4\u05d0\u05e0\u05d3\u05d5\u05e8\u05d0\u05b7\u05e1" },
            { "HR", "\u05e7\u05e8\u05d0\u05d0\u05b7\u05d8\u05d9\u05e2" },
            { "HT", "\u05d4\u05d0\u05b7\u05d9\u05d8\u05d9" },
            { "HU", "\u05d0\u05d5\u05e0\u05d2\u05e2\u05e8\u05df" },
            { "IC", "\u05e7\u05d0\u05b7\u05e0\u05d0\u05b7\u05e8\u05d9\u05e9\u05e2 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "ID", "\u05d0\u05d9\u05e0\u05d3\u05d0\u05e0\u05e2\u05d6\u05d9\u05e2" },
            { "IE", "\u05d0\u05d9\u05e8\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "IL", "\u05d9\u05e9\u05e8\u05d0\u05dc" },
            { "IN", "\u05d0\u05d9\u05e0\u05d3\u05d9\u05e2" },
            { "IR", "\u05d0\u05d9\u05e8\u05d0\u05b7\u05df" },
            { "IS", "\u05d0\u05d9\u05e1\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "IT", "\u05d0\u05d9\u05d8\u05d0\u05b7\u05dc\u05d9\u05e2" },
            { "JE", "\u05d3\u05d6\u05e9\u05e2\u05e8\u05d6\u05d9" },
            { "JM", "\u05d3\u05d6\u05e9\u05d0\u05b7\u05de\u05d9\u05d9\u05e7\u05e2" },
            { "JP", "\u05d9\u05d0\u05b7\u05e4\u05bc\u05d0\u05b7\u05df" },
            { "KE", "\u05e7\u05e2\u05e0\u05d9\u05e2" },
            { "KH", "\u05e7\u05d0\u05b7\u05de\u05d1\u05d0\u05d3\u05d9\u05e2" },
            { "KI", "\u05e7\u05d9\u05e8\u05d9\u05d1\u05d0\u05b7\u05d8\u05d9" },
            { "KM", "\u05e7\u05d0\u05de\u05d0\u05e8\u05d0\u05e1" },
            { "KY", "\u05e7\u05d9\u05d9\u05de\u05d0\u05b7\u05df \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "LA", "\u05dc\u05d0\u05b7\u05d0\u05e1" },
            { "LB", "\u05dc\u05d1\u05e0\u05d5\u05df" },
            { "LI", "\u05dc\u05d9\u05db\u05d8\u05e0\u05e9\u05d8\u05d9\u05d9\u05df" },
            { "LK", "\u05e1\u05e8\u05d9\u05be\u05dc\u05d0\u05b7\u05e0\u05e7\u05d0\u05b7" },
            { "LR", "\u05dc\u05d9\u05d1\u05e2\u05e8\u05d9\u05e2" },
            { "LS", "\u05dc\u05e2\u05e1\u05d0\u05d8\u05d0" },
            { "LT", "\u05dc\u05d9\u05d8\u05e2" },
            { "LU", "\u05dc\u05d5\u05e7\u05e1\u05e2\u05de\u05d1\u05d5\u05e8\u05d2" },
            { "LV", "\u05dc\u05e2\u05d8\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "LY", "\u05dc\u05d9\u05d1\u05d9\u05e2" },
            { "MA", "\u05de\u05d0\u05b7\u05e8\u05d0\u05e7\u05d0" },
            { "MC", "\u05de\u05d0\u05e0\u05d0\u05b7\u05e7\u05d0" },
            { "MD", "\u05de\u05d0\u05dc\u05d3\u05d0\u05d5\u05d5\u05e2" },
            { "ME", "\u05de\u05d0\u05e0\u05d8\u05e2\u05e0\u05e2\u05d2\u05e8\u05d0" },
            { "MG", "\u05de\u05d0\u05b7\u05d3\u05d0\u05b7\u05d2\u05d0\u05b7\u05e1\u05e7\u05d0\u05b7\u05e8" },
            { "MH", "\u05de\u05d0\u05b7\u05e8\u05e9\u05d0\u05b7\u05dc \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "ML", "\u05de\u05d0\u05b7\u05dc\u05d9" },
            { "MM", "\u05de\u05d9\u05d0\u05b7\u05e0\u05de\u05d0\u05b7\u05e8" },
            { "MN", "\u05de\u05d0\u05e0\u05d2\u05d0\u05dc\u05d9\u05d9" },
            { "MQ", "\u05de\u05d0\u05b7\u05e8\u05d8\u05d9\u05e0\u05d9\u05e7" },
            { "MR", "\u05de\u05d0\u05b7\u05e8\u05d9\u05d8\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "MS", "\u05de\u05d0\u05e0\u05d8\u05e1\u05e2\u05e8\u05d0\u05b7\u05d8" },
            { "MT", "\u05de\u05d0\u05b7\u05dc\u05d8\u05d0\u05b7" },
            { "MU", "\u05de\u05d0\u05e8\u05d9\u05e6\u05d9\u05d5\u05e1" },
            { "MV", "\u05de\u05d0\u05b7\u05dc\u05d3\u05d9\u05d5\u05d5\u05df" },
            { "MW", "\u05de\u05d0\u05b7\u05dc\u05d0\u05b7\u05d5\u05d5\u05d9" },
            { "MX", "\u05de\u05e2\u05e7\u05e1\u05d9\u05e7\u05e2" },
            { "MY", "\u05de\u05d0\u05b7\u05dc\u05d9\u05d9\u05d6\u05d9\u05e2" },
            { "MZ", "\u05de\u05d0\u05d6\u05d0\u05b7\u05de\u05d1\u05d9\u05e7" },
            { "NA", "\u05e0\u05d0\u05b7\u05de\u05d9\u05d1\u05d9\u05e2" },
            { "NC", "\u05e0\u05f2\u05b7 \u05e7\u05d0\u05b7\u05dc\u05e2\u05d3\u05d0\u05e0\u05d9\u05e2" },
            { "NE", "\u05e0\u05d9\u05d6\u05e9\u05e2\u05e8" },
            { "NF", "\u05e0\u05d0\u05e8\u05e4\u05bf\u05d0\u05dc\u05e7 \u05d0\u05d9\u05e0\u05d6\u05dc" },
            { "NG", "\u05e0\u05d9\u05d2\u05e2\u05e8\u05d9\u05e2" },
            { "NI", "\u05e0\u05d9\u05e7\u05d0\u05b7\u05e8\u05d0\u05b7\u05d2\u05d5\u05e2" },
            { "NL", "\u05d4\u05d0\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "NO", "\u05e0\u05d0\u05e8\u05d5\u05d5\u05e2\u05d2\u05d9\u05e2" },
            { "NP", "\u05e0\u05e2\u05e4\u05bc\u05d0\u05b7\u05dc" },
            { "NZ", "\u05e0\u05d9\u05d5 \u05d6\u05d9\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "PA", "\u05e4\u05bc\u05d0\u05b7\u05e0\u05d0\u05b7\u05de\u05d0\u05b7" },
            { "PE", "\u05e4\u05bc\u05e2\u05e8\u05d5" },
            { "PF", "\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9\u05e2 \u05e4\u05bc\u05d0\u05dc\u05d9\u05e0\u05e2\u05d6\u05d9\u05e2" },
            { "PG", "\u05e4\u05bc\u05d0\u05b7\u05e4\u05bc\u05d5\u05d0\u05b7 \u05e0\u05f2\u05b7 \u05d2\u05d9\u05e0\u05e2" },
            { "PH", "\u05e4\u05bf\u05d9\u05dc\u05d9\u05e4\u05bc\u05d9\u05e0\u05e2\u05df" },
            { "PK", "\u05e4\u05bc\u05d0\u05b7\u05e7\u05d9\u05e1\u05d8\u05d0\u05b7\u05df" },
            { "PL", "\u05e4\u05bc\u05d5\u05d9\u05dc\u05df" },
            { "PN", "\u05e4\u05bc\u05d9\u05d8\u05e7\u05e2\u05e8\u05df \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "PR", "\u05e4\u05bc\u05d0\u05e8\u05d8\u05d0\u05be\u05e8\u05d9\u05e7\u05d0" },
            { "PT", "\u05e4\u05bc\u05d0\u05e8\u05d8\u05d5\u05d2\u05d0\u05b7\u05dc" },
            { "PY", "\u05e4\u05bc\u05d0\u05b7\u05e8\u05d0\u05b7\u05d2\u05d5\u05d5\u05f2\u05b7" },
            { "QA", "\u05e7\u05d0\u05b7\u05d8\u05d0\u05b7\u05e8" },
            { "RE", "\u05e8\u05e2\u05d0\u05d5\u05e0\u05d9\u05d0\u05df" },
            { "RO", "\u05e8\u05d5\u05de\u05e2\u05e0\u05d9\u05e2" },
            { "RS", "\u05e1\u05e2\u05e8\u05d1\u05d9\u05e2" },
            { "RU", "\u05e8\u05d5\u05e1\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "RW", "\u05e8\u05d5\u05d5\u05d0\u05b7\u05e0\u05d3\u05e2" },
            { "SB", "\u05e1\u05d0\u05dc\u05d0\u05de\u05d0\u05df \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "SC", "\u05e1\u05d9\u05d9\u05e9\u05e2\u05dc" },
            { "SD", "\u05e1\u05d5\u05d3\u05d0\u05b7\u05df" },
            { "SE", "\u05e9\u05d5\u05d5\u05e2\u05d3\u05df" },
            { "SG", "\u05e1\u05d9\u05e0\u05d2\u05d0\u05b7\u05e4\u05bc\u05d5\u05e8" },
            { "SH", "\u05e1\u05d8 \u05d4\u05e2\u05dc\u05e2\u05e0\u05e2" },
            { "SI", "\u05e1\u05dc\u05d0\u05d5\u05d5\u05e2\u05e0\u05d9\u05e2" },
            { "SK", "\u05e1\u05dc\u05d0\u05d5\u05d5\u05d0\u05b7\u05e7\u05d9\u05d9" },
            { "SL", "\u05e1\u05d9\u05e2\u05e8\u05e2 \u05dc\u05e2\u05d0\u05e0\u05e2" },
            { "SM", "\u05e1\u05d0\u05b7\u05df \u05de\u05d0\u05b7\u05e8\u05d9\u05e0\u05d0" },
            { "SN", "\u05e1\u05e2\u05e0\u05e2\u05d2\u05d0\u05b7\u05dc" },
            { "SO", "\u05e1\u05d0\u05de\u05d0\u05b7\u05dc\u05d9\u05e2" },
            { "SR", "\u05e1\u05d5\u05e8\u05d9\u05e0\u05d0\u05b7\u05dd" },
            { "SS", "\u05d3\u05e8\u05d5\u05dd\u05be\u05e1\u05d5\u05d3\u05d0\u05b7\u05df" },
            { "ST", "\u05e1\u05d0\u05b7\u05d0 \u05d8\u05d0\u05de\u05e2 \u05d0\u05d5\u05df \u05e4\u05bc\u05e8\u05d9\u05e0\u05e1\u05d9\u05e4\u05bc\u05e2" },
            { "SV", "\u05e2\u05dc \u05e1\u05d0\u05b7\u05dc\u05d5\u05d5\u05d0\u05b7\u05d3\u05d0\u05e8" },
            { "SY", "\u05e1\u05d9\u05e8\u05d9\u05e2" },
            { "SZ", "\u05e1\u05d5\u05d5\u05d0\u05b7\u05d6\u05d9\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "TD", "\u05d8\u05e9\u05d0\u05b7\u05d3" },
            { "TG", "\u05d8\u05d0\u05d2\u05d0" },
            { "TH", "\u05d8\u05d9\u05d9\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "TL", "\u05de\u05d6\u05e8\u05d7 \u05d8\u05d9\u05de\u05d0\u05e8" },
            { "TM", "\u05d8\u05d5\u05e8\u05e7\u05de\u05e2\u05e0\u05d9\u05e1\u05d8\u05d0\u05b7\u05df" },
            { "TN", "\u05d8\u05d5\u05e0\u05d9\u05e1\u05d9\u05e2" },
            { "TO", "\u05d8\u05d0\u05e0\u05d2\u05d0\u05b7" },
            { "TR", "\u05d8\u05e2\u05e8\u05e7\u05d9\u05d9" },
            { "TT", "\u05d8\u05e8\u05d9\u05e0\u05d9\u05d3\u05d0\u05b7\u05d3 \u05d0\u05d5\u05df \u05d8\u05d0\u05d1\u05d0\u05b7\u05d2\u05d0" },
            { "TV", "\u05d8\u05d5\u05d0\u05d5\u05d5\u05d0\u05b7\u05dc\u05d5" },
            { "TZ", "\u05d8\u05d0\u05b7\u05e0\u05d6\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "UA", "\u05d0\u05d5\u05e7\u05e8\u05d0\u05b7\u05d9\u05e0\u05e2" },
            { "UG", "\u05d0\u05d5\u05d2\u05d0\u05b7\u05e0\u05d3\u05e2" },
            { "US", "\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0\u05d9\u05d9\u05e0\u05d9\u05d2\u05d8\u05e2 \u05e9\u05d8\u05d0\u05b7\u05d8\u05df" },
            { "UY", "\u05d0\u05d5\u05e8\u05d5\u05d2\u05d5\u05d5\u05d9\u05d9" },
            { "VA", "\u05d5\u05d5\u05d0\u05b7\u05d8\u05d9\u05e7\u05d0\u05b7\u05df \u05e9\u05d8\u05d0\u05b8\u05d8" },
            { "VE", "\u05d5\u05d5\u05e2\u05e0\u05e2\u05d6\u05d5\u05e2\u05dc\u05e2" },
            { "VN", "\u05d5\u05d5\u05d9\u05e2\u05d8\u05e0\u05d0\u05b7\u05dd" },
            { "VU", "\u05d5\u05d5\u05d0\u05b7\u05e0\u05d5\u05d0\u05b7\u05d8\u05d5" },
            { "WS", "\u05e1\u05d0\u05b7\u05de\u05d0\u05d0\u05b7" },
            { "XK", "\u05e7\u05d0\u05e1\u05d0\u05d5\u05d5\u05d0" },
            { "YE", "\u05ea\u05d9\u05de\u05df" },
            { "YT", "\u05de\u05d0\u05b7\u05d9\u05d0\u05d8" },
            { "ZA", "\u05d3\u05e8\u05d5\u05dd\u05be\u05d0\u05b7\u05e4\u05bf\u05e8\u05d9\u05e7\u05e2" },
            { "ZM", "\u05d6\u05d0\u05b7\u05de\u05d1\u05d9\u05e2" },
            { "ZW", "\u05d6\u05d9\u05de\u05d1\u05d0\u05b7\u05d1\u05d5\u05d5\u05e2" },
            { "ZZ", "\u05d0\u05d5\u05de\u05d1\u05d0\u05b7\u05d5\u05d5\u05d0\u05d5\u05e1\u05d8\u05e2\u05e8 \u05e8\u05d0\u05b7\u05d9\u05d0\u05df" },
            { "aa", "\u05d0\u05b7\u05e4\u05bf\u05d0\u05b7\u05e8" },
            { "af", "\u05d0\u05b7\u05e4\u05bf\u05e8\u05d9\u05e7\u05d0\u05b7\u05e0\u05e1" },
            { "am", "\u05d0\u05b7\u05de\u05d4\u05d0\u05b7\u05e8\u05d9\u05e9" },
            { "an", "\u05d0\u05b7\u05e8\u05d0\u05b7\u05d2\u05d0\u05e0\u05d9\u05e9" },
            { "ar", metaValue_ar },
            { "as", "\u05d0\u05b7\u05e1\u05d0\u05b7\u05de\u05d9\u05e9" },
            { "az", "\u05d0\u05b7\u05d6\u05e2\u05e8\u05d1\u05d9\u05d9\u05d3\u05d6\u05e9\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "be", "\u05d1\u05e2\u05dc\u05d0\u05b7\u05e8\u05d5\u05e1\u05d9\u05e9" },
            { "bg", "\u05d1\u05d5\u05dc\u05d2\u05d0\u05b7\u05e8\u05d9\u05e9" },
            { "bn", "\u05d1\u05e2\u05e0\u05d2\u05d0\u05b7\u05dc\u05d9\u05e9" },
            { "bo", "\u05d8\u05d9\u05d1\u05e2\u05d8\u05d9\u05e9" },
            { "br", "\u05d1\u05e8\u05e2\u05d8\u05d0\u05e0\u05d9\u05e9" },
            { "bs", "\u05d1\u05d0\u05e1\u05e0\u05d9\u05e9" },
            { "ca", "\u05e7\u05d0\u05b7\u05d8\u05d0\u05b7\u05dc\u05d0\u05e0\u05d9\u05e9" },
            { "cs", "\u05d8\u05e9\u05e2\u05db\u05d9\u05e9" },
            { "cu", "\u05e7\u05dc\u05d5\u05d9\u05e1\u05d8\u05e2\u05e8\u05be\u05e1\u05dc\u05d0\u05b7\u05d5\u05d5\u05d9\u05e9" },
            { "cy", "\u05d5\u05d5\u05e2\u05dc\u05e9\u05d9\u05e9" },
            { "da", "\u05d3\u05e2\u05e0\u05d9\u05e9" },
            { "de", "\u05d3\u05f2\u05b7\u05d8\u05e9" },
            { "el", metaValue_el },
            { "en", "\u05e2\u05e0\u05d2\u05dc\u05d9\u05e9" },
            { "eo", "\u05e2\u05e1\u05e4\u05bc\u05e2\u05e8\u05d0\u05b7\u05e0\u05d8\u05d0" },
            { "es", "\u05e9\u05e4\u05bc\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "et", "\u05e2\u05e1\u05d8\u05d9\u05e9" },
            { "eu", "\u05d1\u05d0\u05b7\u05e1\u05e7\u05d9\u05e9" },
            { "fa", "\u05e4\u05bc\u05e2\u05e8\u05e1\u05d9\u05e9" },
            { "fi", "\u05e4\u05bf\u05d9\u05e0\u05d9\u05e9" },
            { "fj", metaValue_FJ },
            { "fo", "\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0\u05d9\u05e9" },
            { "fr", "\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9" },
            { "fy", "\u05de\u05e2\u05e8\u05d1\u05be\u05e4\u05bf\u05e8\u05d9\u05d6\u05d9\u05e9" },
            { "ga", "\u05d0\u05d9\u05e8\u05d9\u05e9" },
            { "gd", "\u05e1\u05e7\u05d0\u05d8\u05d9\u05e9 \u05d2\u05e2\u05dc\u05d9\u05e9" },
            { "gl", "\u05d2\u05d0\u05b7\u05dc\u05d9\u05e9\u05d9\u05e9" },
            { "gv", "\u05de\u05d0\u05b7\u05e0\u05e7\u05e1" },
            { "ha", "\u05d4\u05d0\u05b7\u05d5\u05e1\u05d0\u05b7" },
            { "he", "\u05d4\u05e2\u05d1\u05e8\u05e2\u05d0\u05d9\u05e9" },
            { "hi", "\u05d4\u05d9\u05e0\u05d3\u05d9" },
            { "hr", "\u05e7\u05e8\u05d0\u05d0\u05b7\u05d8\u05d9\u05e9" },
            { "hu", "\u05d0\u05d5\u05e0\u05d2\u05e2\u05e8\u05d9\u05e9" },
            { "hy", "\u05d0\u05b7\u05e8\u05de\u05e2\u05e0\u05d9\u05e9" },
            { "id", "\u05d0\u05d9\u05e0\u05d3\u05d0\u05e0\u05e2\u05d6\u05d9\u05e9" },
            { "io", "\u05d0\u05d9\u05d3\u05d0" },
            { "is", "\u05d0\u05d9\u05e1\u05dc\u05d0\u05b7\u05e0\u05d3\u05d9\u05e9" },
            { "it", "\u05d0\u05d9\u05d8\u05d0\u05b7\u05dc\u05d9\u05e2\u05e0\u05d9\u05e9" },
            { "ja", "\u05d9\u05d0\u05b7\u05e4\u05bc\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "jv", "\u05d9\u05d0\u05b7\u05d5\u05d5\u05d0\u05b7\u05e0\u05e2\u05d6\u05d9\u05e9" },
            { "ka", "\u05d2\u05e8\u05d5\u05d6\u05d9\u05e0\u05d9\u05e9" },
            { "kk", "\u05e7\u05d0\u05b7\u05d6\u05d0\u05b7\u05db\u05d9\u05e9" },
            { "km", "\u05db\u05de\u05e2\u05e8" },
            { "kn", "\u05e7\u05d0\u05b7\u05e0\u05d0\u05b7\u05d3\u05d0\u05b7" },
            { "ko", "\u05e7\u05d0\u05e8\u05e2\u05d0\u05d9\u05e9" },
            { "ku", "\u05e7\u05d5\u05e8\u05d3\u05d9\u05e9" },
            { "kw", "\u05e7\u05d0\u05e8\u05e0\u05d9\u05e9" },
            { "ky", "\u05e7\u05d9\u05e8\u05d2\u05d9\u05d6\u05d9\u05e9" },
            { "la", "\u05dc\u05d0\u05d8\u05d9\u05d9\u05e0\u05d9\u05e9" },
            { "lb", "\u05dc\u05d5\u05e7\u05e1\u05e2\u05de\u05d1\u05d5\u05e8\u05d2\u05d9\u05e9" },
            { "lo", "\u05dc\u05d0\u05b7\u05d0" },
            { "lt", "\u05dc\u05d9\u05d8\u05d5\u05d5\u05d9\u05e9" },
            { "lv", "\u05dc\u05e2\u05d8\u05d9\u05e9" },
            { "mi", "\u05de\u05d0\u05b7\u05d0\u05e8\u05d9\u05e9" },
            { "mk", "\u05de\u05d0\u05b7\u05e7\u05e2\u05d3\u05d0\u05e0\u05d9\u05e9" },
            { "ml", "\u05de\u05d0\u05b7\u05dc\u05d0\u05b7\u05d9\u05d0\u05b7\u05dc\u05d0\u05b7\u05dd" },
            { "mn", "\u05de\u05d0\u05e0\u05d2\u05d0\u05dc\u05d9\u05e9" },
            { "mt", "\u05de\u05d0\u05b7\u05dc\u05d8\u05e2\u05d6\u05d9\u05e9" },
            { "my", "\u05d1\u05d9\u05e8\u05de\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "ne", "\u05e0\u05e2\u05e4\u05bc\u05d0\u05b7\u05dc\u05d9\u05e9" },
            { "nl", "\u05d4\u05d0\u05dc\u05e2\u05e0\u05d3\u05d9\u05e9" },
            { "nn", "\u05e0\u05f2\u05b7\u05be\u05e0\u05d0\u05e8\u05d5\u05d5\u05e2\u05d2\u05d9\u05e9" },
            { "no", "\u05e0\u05d0\u05e8\u05d5\u05d5\u05e2\u05d2\u05d9\u05e9" },
            { "oc", "\u05d0\u05e7\u05e1\u05d9\u05d8\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "os", "\u05d0\u05e1\u05e2\u05d8\u05d9\u05e9" },
            { "pl", "\u05e4\u05bc\u05d5\u05d9\u05dc\u05d9\u05e9" },
            { "ps", "\u05e4\u05bc\u05d0\u05b7\u05e9\u05d8\u05d0\u05b8" },
            { "pt", "\u05e4\u05bc\u05d0\u05e8\u05d8\u05d5\u05d2\u05e2\u05d6\u05d9\u05e9" },
            { "ro", "\u05e8\u05d5\u05de\u05e2\u05e0\u05d9\u05e9" },
            { "ru", "\u05e8\u05d5\u05e1\u05d9\u05e9" },
            { "sa", "\u05e1\u05d0\u05b7\u05e0\u05e1\u05e7\u05e8\u05d9\u05d8" },
            { "sc", "\u05e1\u05d0\u05b7\u05e8\u05d3\u05d9\u05e9" },
            { "sd", "\u05e1\u05d9\u05e0\u05d3\u05d4\u05d9" },
            { "se", "\u05e0\u05d0\u05e8\u05d3\u05e1\u05d0\u05b7\u05de\u05d9\u05e9" },
            { "sh", "\u05e1\u05e2\u05e8\u05d1\u05d0\u05be\u05e7\u05e8\u05d0\u05d0\u05b7\u05d8\u05d9\u05e9" },
            { "si", "\u05e1\u05d9\u05e0\u05d4\u05d0\u05b7\u05dc\u05d9\u05e9" },
            { "sk", "\u05e1\u05dc\u05d0\u05d5\u05d5\u05d0\u05b7\u05e7\u05d9\u05e9" },
            { "sl", "\u05e1\u05dc\u05d0\u05d5\u05d5\u05e2\u05e0\u05d9\u05e9" },
            { "sm", "\u05e1\u05d0\u05b7\u05de\u05d0\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "sn", "\u05e9\u05d0\u05e0\u05d0\u05b7" },
            { "so", "\u05e1\u05d0\u05de\u05d0\u05b7\u05dc\u05d9\u05e9" },
            { "sq", "\u05d0\u05b7\u05dc\u05d1\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "sr", "\u05e1\u05e2\u05e8\u05d1\u05d9\u05e9" },
            { "sv", "\u05e9\u05d5\u05d5\u05e2\u05d3\u05d9\u05e9" },
            { "sw", "\u05e1\u05d5\u05d5\u05d0\u05b7\u05d4\u05d9\u05dc\u05d9\u05e9" },
            { "ta", "\u05d8\u05d0\u05b7\u05de\u05d9\u05dc" },
            { "tk", "\u05d8\u05d5\u05e8\u05e7\u05de\u05e2\u05e0\u05d9\u05e9" },
            { "tl", "\u05d8\u05d0\u05b7\u05d2\u05d0\u05b7\u05dc\u05d0\u05d2" },
            { "tt", "\u05d8\u05d0\u05b8\u05d8\u05e2\u05e8\u05d9\u05e9" },
            { "uk", "\u05d0\u05d5\u05e7\u05e8\u05d0\u05b7\u05d0\u05d9\u05e0\u05d9\u05e9" },
            { "ur", "\u05d0\u05d5\u05e8\u05d3\u05d5" },
            { "uz", "\u05d0\u05d5\u05d6\u05d1\u05e2\u05e7\u05d9\u05e9" },
            { "vi", "\u05d5\u05d5\u05d9\u05e2\u05d8\u05e0\u05d0\u05b7\u05de\u05e2\u05d6\u05d9\u05e9" },
            { "vo", "\u05d5\u05d5\u05d0\u05dc\u05d0\u05b7\u05e4\u05bc\u05d5\u05e7" },
            { "yi", "\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9" },
            { "zh", "\u05db\u05d9\u05e0\u05e2\u05d6\u05d9\u05e9" },
            { "zu", "\u05d6\u05d5\u05dc\u05d5" },
            { "akk", "\u05d0\u05b7\u05e7\u05d0\u05b7\u05d3\u05d9\u05e9" },
            { "ang", "\u05d0\u05b7\u05dc\u05d8 \u05e2\u05e0\u05d2\u05dc\u05d9\u05e9" },
            { "arc", "\u05d0\u05b7\u05e8\u05d0\u05b7\u05de\u05d9\u05e9" },
            { "ban", "\u05d1\u05d0\u05b7\u05dc\u05d9\u05e0\u05e2\u05d6\u05d9\u05e9" },
            { "bar", "\u05d1\u05f2\u05b7\u05e2\u05e8\u05d9\u05e9" },
            { "ceb", "\u05e1\u05e2\u05d1\u05d5\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "crh", "\u05e7\u05e8\u05d9\u05dd\u05be\u05d8\u05e2\u05e8\u05e7\u05d9\u05e9" },
            { "csb", "\u05e7\u05d0\u05b7\u05e9\u05d5\u05d1\u05d9\u05e9" },
            { "dsb", "\u05d0\u05d5\u05e0\u05d8\u05e2\u05e8\u05be\u05e1\u05d0\u05e8\u05d1\u05d9\u05e9" },
            { "dyo", "\u05d6\u05e9\u05d0\u05dc\u05d0\u05be\u05e4\u05bf\u05d0\u05e0\u05d9" },
            { "enm", "\u05de\u05d9\u05d8\u05dc \u05e2\u05e0\u05d2\u05dc\u05d9\u05e9" },
            { "fil", "\u05e4\u05bf\u05d9\u05dc\u05d9\u05e4\u05bc\u05d9\u05e0\u05d0" },
            { "fro", "\u05d0\u05b7\u05dc\u05d8\u05be\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9" },
            { "frr", "\u05d3\u05e8\u05d5\u05dd\u05be\u05e4\u05bf\u05e8\u05d9\u05d6\u05d9\u05e9" },
            { "frs", "\u05de\u05d6\u05e8\u05d7\u05be\u05e4\u05bf\u05e8\u05d9\u05d6\u05d9\u05e9" },
            { "gmh", "\u05de\u05d9\u05d8\u05dc \u05d4\u05d5\u05d9\u05db\u05d3\u05d5\u05d9\u05d8\u05e9" },
            { "goh", "\u05d0\u05b7\u05dc\u05d8\u05be \u05d4\u05d5\u05d9\u05db\u05d3\u05d5\u05d9\u05d8\u05e9" },
            { "got", "\u05d2\u05d0\u05d8\u05d9\u05e9" },
            { "grc", "\u05d0\u05d5\u05e8\u05d0\u05b7\u05dc\u05d8\u05be\u05d2\u05e8\u05d9\u05db\u05d9\u05e9" },
            { "hif", "\u05e4\u05d9\u05d3\u05d6\u05e9\u05d9 \u05d4\u05d9\u05e0\u05d3\u05d9" },
            { "hsb", "\u05d0\u05d9\u05d9\u05d1\u05e2\u05e8\u05be\u05e1\u05d0\u05e8\u05d1\u05d9\u05e9" },
            { "jbo", "\u05dc\u05d0\u05d6\u05e9\u05d1\u05d0\u05b8\u05df" },
            { "jpr", "\u05d9\u05d9\u05d3\u05d9\u05e9\u05be\u05e4\u05e2\u05e8\u05e1\u05d9\u05e9" },
            { "lad", "\u05dc\u05d0\u05b7\u05d3\u05d9\u05e0\u05d0" },
            { "liv", "\u05dc\u05d9\u05d5\u05d5\u05d9\u05e9" },
            { "lus", "\u05de\u05d9\u05d6\u05d0" },
            { "nap", "\u05e0\u05d0\u05b7\u05e4\u05bc\u05d0\u05dc\u05d9\u05d8\u05b7\u05e0\u05d9\u05e9" },
            { "nds", "\u05e0\u05d9\u05d3\u05e2\u05e8\u05d3\u05f2\u05b7\u05d8\u05e9" },
            { "peo", "\u05d0\u05b7\u05dc\u05d8 \u05e4\u05bc\u05e2\u05e8\u05e1\u05d9\u05e9" },
            { "prg", "\u05e4\u05bc\u05e8\u05d9\u05d9\u05e1\u05d9\u05e9" },
            { "rue", "\u05e8\u05d5\u05e1\u05d9\u05e0\u05d9\u05e9" },
            { "scn", "\u05e1\u05d9\u05e6\u05d9\u05dc\u05d9\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "sco", "\u05e1\u05e7\u05d0\u05d8\u05e1" },
            { "sga", "\u05d0\u05b7\u05dc\u05d8\u05be\u05d0\u05d9\u05e8\u05d9\u05e9" },
            { "sli", "\u05d0\u05d5\u05e0\u05d8\u05e2\u05e8 \u05e9\u05dc\u05e2\u05d6\u05d9\u05e9" },
            { "sux", "\u05e1\u05d5\u05de\u05e2\u05e8\u05d9\u05e9" },
            { "swb", "\u05e7\u05d0\u05de\u05d0\u05e8\u05d9\u05e9" },
            { "szl", "\u05e9\u05dc\u05e2\u05d6\u05d9\u05e9" },
            { "tig", "\u05d8\u05d9\u05d2\u05e8\u05e2" },
            { "und", "\u05d0\u05d5\u05de\u05d1\u05d0\u05b7\u05d5\u05d5\u05d0\u05d5\u05e1\u05d8\u05e2 \u05e9\u05e4\u05bc\u05e8\u05d0\u05b7\u05da" },
            { "vls", "\u05de\u05e2\u05e8\u05d1 \u05e4\u05bf\u05dc\u05e2\u05de\u05d9\u05e9" },
            { "Arab", metaValue_ar },
            { "Cyrl", "\u05e6\u05d9\u05e8\u05d9\u05dc\u05d9\u05e9" },
            { "Deva", "\u05d3\u05e2\u05d5\u05d5\u05d0\u05b7\u05e0\u05d0\u05b7\u05d2\u05d0\u05b7\u05e8\u05d9" },
            { "Grek", metaValue_el },
            { "Hebr", "\u05d4\u05e2\u05d1\u05e8\u05e2\u05d9\u05e9" },
            { "Latn", "\u05d2\u05b7\u05dc\u05d7\u05d9\u05e9" },
            { "nl_BE", "\u05e4\u05bf\u05dc\u05e2\u05de\u05d9\u05e9" },
            { "sw_CD", "\u05e7\u05d0\u05e0\u05d2\u05d0\u05be\u05e1\u05d5\u05d5\u05d0\u05b7\u05d4\u05d9\u05dc\u05d9\u05e9" },
            { "key.nu", "\u05e0\u05d5\u05de\u05e2\u05e8\u05df" },
            { "type.ca.gregorian", "\u05d2\u05e8\u05e2\u05d2\u05d0\u05e8\u05d9\u05e9\u05e2\u05e8 \u05e7\u05d0\u05b7\u05dc\u05e2\u05e0\u05d3\u05d0\u05b7\u05e8" },
        };
        return data;
    }
}
