/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_th extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "\u0e2d\u0e32\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e44\u0e1a\u0e08\u0e32\u0e19";
        final String metaValue_BY = "\u0e40\u0e1a\u0e25\u0e32\u0e23\u0e38\u0e2a";
        final String metaValue_BG = "\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22";
        final String metaValue_CZ = "\u0e40\u0e0a\u0e47\u0e01";
        final String metaValue_DK = "\u0e40\u0e14\u0e19\u0e21\u0e32\u0e23\u0e4c\u0e01";
        final String metaValue_ES = "\u0e2a\u0e40\u0e1b\u0e19";
        final String metaValue_EE = "\u0e40\u0e2d\u0e2a\u0e42\u0e15\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_FI = "\u0e1f\u0e34\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c";
        final String metaValue_FJ = "\u0e1f\u0e34\u0e08\u0e34";
        final String metaValue_FR = "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a";
        final String metaValue_HR = "\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22";
        final String metaValue_HU = "\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35";
        final String metaValue_AM = "\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_ID = "\u0e2d\u0e34\u0e19\u0e42\u0e14\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22";
        final String metaValue_IS = "\u0e44\u0e2d\u0e0b\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c";
        final String metaValue_IT = "\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35";
        final String metaValue_JP = "\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19";
        final String metaValue_GE = "\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22";
        final String metaValue_GL = "\u0e01\u0e23\u0e35\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c";
        final String metaValue_LU = "\u0e25\u0e31\u0e01\u0e40\u0e0b\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01";
        final String metaValue_UG = "\u0e22\u0e39\u0e01\u0e31\u0e19\u0e14\u0e32";
        final String metaValue_LA = "\u0e25\u0e32\u0e27";
        final String metaValue_LT = "\u0e25\u0e34\u0e17\u0e31\u0e27\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_LV = "\u0e25\u0e31\u0e15\u0e40\u0e27\u0e35\u0e22";
        final String metaValue_MN = "\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22";
        final String metaValue_MT = "\u0e21\u0e2d\u0e25\u0e15\u0e32";
        final String metaValue_NR = "\u0e19\u0e32\u0e2d\u0e39\u0e23\u0e39";
        final String metaValue_NP = "\u0e40\u0e19\u0e1b\u0e32\u0e25";
        final String metaValue_NO = "\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c";
        final String metaValue_PL = "\u0e42\u0e1b\u0e41\u0e25\u0e19\u0e14\u0e4c";
        final String metaValue_PT = "\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a";
        final String metaValue_BI = "\u0e1a\u0e38\u0e23\u0e38\u0e19\u0e14\u0e35";
        final String metaValue_RO = "\u0e42\u0e23\u0e21\u0e32\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_RU = "\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22";
        final String metaValue_RW = "\u0e23\u0e27\u0e31\u0e19\u0e14\u0e32";
        final String metaValue_SI = "\u0e2a\u0e42\u0e25\u0e27\u0e35\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_WS = "\u0e0b\u0e32\u0e21\u0e31\u0e27";
        final String metaValue_AL = "\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_RS = "\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22";
        final String metaValue_SE = "\u0e2a\u0e27\u0e35\u0e40\u0e14\u0e19";
        final String metaValue_TH = "\u0e44\u0e17\u0e22";
        final String metaValue_TO = "\u0e15\u0e2d\u0e07\u0e01\u0e32";
        final String metaValue_TR = "\u0e15\u0e38\u0e23\u0e01\u0e35";
        final String metaValue_UA = "\u0e22\u0e39\u0e40\u0e04\u0e23\u0e19";
        final String metaValue_VN = "\u0e40\u0e27\u0e35\u0e22\u0e14\u0e19\u0e32\u0e21";
        final String metaValue_CN = "\u0e08\u0e35\u0e19";
        final String metaValue_PH = "\u0e1f\u0e34\u0e25\u0e34\u0e1b\u0e1b\u0e34\u0e19\u0e2a\u0e4c";
        final String metaValue_PW = "\u0e1b\u0e32\u0e40\u0e25\u0e32";
        final String metaValue_SY = "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22";
        final String metaValue_TK = "\u0e42\u0e15\u0e40\u0e01\u0e40\u0e25\u0e32";
        final String metaValue_TV = "\u0e15\u0e39\u0e27\u0e32\u0e25\u0e39";
        final String metaValue_ar = "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a";
        final String metaValue_ae = "\u0e2d\u0e40\u0e27\u0e2a\u0e15\u0e30";
        final String metaValue_ban = "\u0e1a\u0e32\u0e2b\u0e25\u0e35";
        final String metaValue_zbl = "\u0e1a\u0e25\u0e34\u0e2a\u0e0b\u0e34\u0e21\u0e42\u0e1a\u0e25\u0e2a\u0e4c";
        final String metaValue_bug = "\u0e1a\u0e39\u0e01\u0e34\u0e2a";
        final String metaValue_ccp = "\u0e08\u0e31\u0e01\u0e21\u0e48\u0e32";
        final String metaValue_chr = "\u0e40\u0e0a\u0e2d\u0e42\u0e23\u0e01\u0e35";
        final String metaValue_cop = "\u0e04\u0e2d\u0e1b\u0e15\u0e34\u0e01";
        final String metaValue_got = "\u0e42\u0e01\u0e18\u0e34\u0e01";
        final String metaValue_el = "\u0e01\u0e23\u0e35\u0e01";
        final String metaValue_gu = "\u0e04\u0e38\u0e0a\u0e23\u0e32\u0e15";
        final String metaValue_jv = "\u0e0a\u0e27\u0e32";
        final String metaValue_km = "\u0e40\u0e02\u0e21\u0e23";
        final String metaValue_kn = "\u0e01\u0e31\u0e19\u0e19\u0e32\u0e14\u0e32";
        final String metaValue_ko = "\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35";
        final String metaValue_la = "\u0e25\u0e30\u0e15\u0e34\u0e19";
        final String metaValue_men = "\u0e40\u0e21\u0e19\u0e40\u0e14";
        final String metaValue_ml = "\u0e21\u0e32\u0e25\u0e32\u0e22\u0e32\u0e25\u0e31\u0e21";
        final String metaValue_my = "\u0e1e\u0e21\u0e48\u0e32";
        final String metaValue_nqo = "\u0e40\u0e2d\u0e47\u0e19\u0e42\u0e01";
        final String metaValue_phn = "\u0e1f\u0e34\u0e19\u0e34\u0e40\u0e0a\u0e35\u0e22";
        final String metaValue_si = "\u0e2a\u0e34\u0e07\u0e2b\u0e25";
        final String metaValue_su = "\u0e0b\u0e38\u0e19\u0e14\u0e32";
        final String metaValue_ta = "\u0e17\u0e21\u0e34\u0e2c";
        final String metaValue_te = "\u0e40\u0e15\u0e25\u0e39\u0e01\u0e39";
        final String metaValue_tl = "\u0e15\u0e32\u0e01\u0e32\u0e25\u0e47\u0e2d\u0e01";
        final String metaValue_bo = "\u0e17\u0e34\u0e40\u0e1a\u0e15";
        final String metaValue_uga = "\u0e22\u0e39\u0e01\u0e32\u0e23\u0e34\u0e15";
        final String metaValue_vai = "\u0e44\u0e27";
        final String metaValue_peo = "\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e35\u0e22\u0e42\u0e1a\u0e23\u0e32\u0e13";
        final String metaValue_MD = "\u0e21\u0e2d\u0e25\u0e42\u0e14\u0e27\u0e32";
        final String metaValue_ssy = "\u0e0b\u0e32\u0e42\u0e2e";
        final String metaValue_Hant = "\u0e15\u0e31\u0e27\u0e40\u0e15\u0e47\u0e21";
        final String metaValue_Hans = "\u0e15\u0e31\u0e27\u0e22\u0e48\u0e2d";
        final String metaValue_key_nu = "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02";
        final Object[][] data = new Object[][] {
            { "001", "\u0e42\u0e25\u0e01" },
            { "002", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32" },
            { "003", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "005", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49" },
            { "009", "\u0e42\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e40\u0e19\u0e35\u0e22" },
            { "011", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "013", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07" },
            { "014", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "015", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "017", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07" },
            { "018", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e15\u0e2d\u0e19\u0e43\u0e15\u0e49" },
            { "019", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "021", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32\u0e15\u0e2d\u0e19\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "029", "\u0e41\u0e04\u0e23\u0e34\u0e1a\u0e40\u0e1a\u0e35\u0e22\u0e19" },
            { "030", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "034", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e43\u0e15\u0e49" },
            { "035", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01\u0e40\u0e09\u0e35\u0e22\u0e07\u0e43\u0e15\u0e49" },
            { "039", "\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e43\u0e15\u0e49" },
            { "053", "\u0e2d\u0e2d\u0e2a\u0e15\u0e23\u0e32\u0e40\u0e25\u0e40\u0e0b\u0e35\u0e22" },
            { "054", "\u0e40\u0e21\u0e25\u0e32\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "057", "\u0e40\u0e02\u0e15\u0e44\u0e21\u0e42\u0e04\u0e23\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "061", "\u0e42\u0e1b\u0e25\u0e34\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "142", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22" },
            { "143", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e01\u0e25\u0e32\u0e07" },
            { "145", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "150", "\u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "151", "\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "154", "\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "155", "\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "202", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49\u0e2a\u0e30\u0e2e\u0e32\u0e23\u0e32" },
            { "419", "\u0e25\u0e30\u0e15\u0e34\u0e19\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "AC", "\u0e40\u0e01\u0e32\u0e30\u0e41\u0e2d\u0e2a\u0e40\u0e0b\u0e19\u0e0a\u0e31\u0e19" },
            { "AD", "\u0e2d\u0e31\u0e19\u0e14\u0e2d\u0e23\u0e4c\u0e23\u0e32" },
            { "AE", "\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e40\u0e2d\u0e21\u0e34\u0e40\u0e23\u0e15\u0e2a\u0e4c" },
            { "AF", "\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "AG", "\u0e41\u0e2d\u0e19\u0e15\u0e34\u0e01\u0e32\u0e41\u0e25\u0e30\u0e1a\u0e32\u0e23\u0e4c\u0e1a\u0e39\u0e14\u0e32" },
            { "AI", "\u0e41\u0e2d\u0e07\u0e01\u0e27\u0e34\u0e25\u0e25\u0e32" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "\u0e41\u0e2d\u0e07\u0e42\u0e01\u0e25\u0e32" },
            { "AQ", "\u0e41\u0e2d\u0e19\u0e15\u0e32\u0e23\u0e4c\u0e01\u0e15\u0e34\u0e01\u0e32" },
            { "AR", "\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32" },
            { "AS", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19\u0e0b\u0e32\u0e21\u0e31\u0e27" },
            { "AT", "\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e35\u0e22" },
            { "AU", "\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22" },
            { "AW", "\u0e2d\u0e32\u0e23\u0e39\u0e1a\u0e32" },
            { "AX", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e2d\u0e25\u0e31\u0e19\u0e14\u0e4c" },
            { "AZ", metaValue_AZ },
            { "BA", "\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22\u0e41\u0e25\u0e30\u0e40\u0e2e\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e42\u0e01\u0e27\u0e35\u0e19\u0e32" },
            { "BB", "\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e1a\u0e42\u0e14\u0e2a" },
            { "BD", "\u0e1a\u0e31\u0e07\u0e01\u0e25\u0e32\u0e40\u0e17\u0e28" },
            { "BE", "\u0e40\u0e1a\u0e25\u0e40\u0e22\u0e35\u0e22\u0e21" },
            { "BF", "\u0e1a\u0e39\u0e23\u0e4c\u0e01\u0e34\u0e19\u0e32\u0e1f\u0e32\u0e42\u0e0b" },
            { "BG", metaValue_BG },
            { "BH", "\u0e1a\u0e32\u0e2b\u0e4c\u0e40\u0e23\u0e19" },
            { "BI", metaValue_BI },
            { "BJ", "\u0e40\u0e1a\u0e19\u0e34\u0e19" },
            { "BL", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e18\u0e40\u0e25\u0e21\u0e35" },
            { "BM", "\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e21\u0e34\u0e27\u0e14\u0e32" },
            { "BN", "\u0e1a\u0e23\u0e39\u0e44\u0e19" },
            { "BO", "\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22" },
            { "BQ", "\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e41\u0e04\u0e23\u0e34\u0e1a\u0e40\u0e1a\u0e35\u0e22\u0e19" },
            { "BR", "\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25" },
            { "BS", "\u0e1a\u0e32\u0e2e\u0e32\u0e21\u0e32\u0e2a" },
            { "BT", "\u0e20\u0e39\u0e0f\u0e32\u0e19" },
            { "BV", "\u0e40\u0e01\u0e32\u0e30\u0e1a\u0e39\u0e40\u0e27" },
            { "BW", "\u0e1a\u0e2d\u0e15\u0e2a\u0e27\u0e32\u0e19\u0e32" },
            { "BY", metaValue_BY },
            { "BZ", "\u0e40\u0e1a\u0e25\u0e35\u0e0b" },
            { "CA", "\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32" },
            { "CC", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e04\u0e42\u0e04\u0e2a (\u0e04\u0e35\u0e25\u0e34\u0e07)" },
            { "CD", "\u0e04\u0e2d\u0e07\u0e42\u0e01 - \u0e01\u0e34\u0e19\u0e0a\u0e32\u0e0b\u0e32" },
            { "CF", "\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07" },
            { "CG", "\u0e04\u0e2d\u0e07\u0e42\u0e01 - \u0e1a\u0e23\u0e32\u0e0b\u0e0b\u0e32\u0e27\u0e34\u0e25" },
            { "CH", "\u0e2a\u0e27\u0e34\u0e15\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "CI", "\u0e42\u0e01\u0e15\u0e14\u0e34\u0e27\u0e31\u0e27\u0e23\u0e4c" },
            { "CK", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e04\u0e38\u0e01" },
            { "CL", "\u0e0a\u0e34\u0e25\u0e35" },
            { "CM", "\u0e41\u0e04\u0e40\u0e21\u0e2d\u0e23\u0e39\u0e19" },
            { "CN", metaValue_CN },
            { "CO", "\u0e42\u0e04\u0e25\u0e2d\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "CP", "\u0e40\u0e01\u0e32\u0e30\u0e04\u0e25\u0e34\u0e1b\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e15\u0e31\u0e19" },
            { "CR", "\u0e04\u0e2d\u0e2a\u0e15\u0e32\u0e23\u0e34\u0e01\u0e32" },
            { "CU", "\u0e04\u0e34\u0e27\u0e1a\u0e32" },
            { "CV", "\u0e40\u0e04\u0e1b\u0e40\u0e27\u0e34\u0e23\u0e4c\u0e14" },
            { "CW", "\u0e04\u0e39\u0e23\u0e32\u0e40\u0e0b\u0e32" },
            { "CX", "\u0e40\u0e01\u0e32\u0e30\u0e04\u0e23\u0e34\u0e2a\u0e15\u0e4c\u0e21\u0e32\u0e2a" },
            { "CY", "\u0e44\u0e0b\u0e1b\u0e23\u0e31\u0e2a" },
            { "CZ", metaValue_CZ },
            { "DE", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e19\u0e35" },
            { "DG", "\u0e14\u0e34\u0e40\u0e2d\u0e42\u0e01\u0e01\u0e32\u0e23\u0e4c\u0e40\u0e0b\u0e35\u0e22" },
            { "DJ", "\u0e08\u0e34\u0e1a\u0e39\u0e15\u0e35" },
            { "DK", metaValue_DK },
            { "DM", "\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e32" },
            { "DO", "\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e31\u0e19" },
            { "DZ", "\u0e41\u0e2d\u0e25\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "EA", "\u0e40\u0e0b\u0e27\u0e15\u0e32\u0e41\u0e25\u0e30\u0e40\u0e21\u0e25\u0e35\u0e22\u0e32" },
            { "EC", "\u0e40\u0e2d\u0e01\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c" },
            { "EE", metaValue_EE },
            { "EG", "\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "EH", "\u0e0b\u0e32\u0e2e\u0e32\u0e23\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "ER", "\u0e40\u0e2d\u0e23\u0e34\u0e40\u0e17\u0e23\u0e35\u0e22" },
            { "ES", metaValue_ES },
            { "ET", "\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22" },
            { "EU", "\u0e2a\u0e2b\u0e20\u0e32\u0e1e\u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "EZ", "\u0e22\u0e39\u0e42\u0e23\u0e42\u0e0b\u0e19" },
            { "FI", metaValue_FI },
            { "FJ", metaValue_FJ },
            { "FK", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1f\u0e2d\u0e25\u0e4c\u0e01\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "FM", "\u0e44\u0e21\u0e42\u0e04\u0e23\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "FO", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e41\u0e1f\u0e42\u0e23" },
            { "FR", metaValue_FR },
            { "GA", "\u0e01\u0e32\u0e1a\u0e2d\u0e07" },
            { "GB", "\u0e2a\u0e2b\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23" },
            { "GD", "\u0e40\u0e01\u0e23\u0e40\u0e19\u0e14\u0e32" },
            { "GE", metaValue_GE },
            { "GF", "\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e40\u0e01\u0e35\u0e22\u0e19\u0e32" },
            { "GG", "\u0e40\u0e01\u0e34\u0e23\u0e4c\u0e19\u0e0b\u0e35\u0e22\u0e4c" },
            { "GH", "\u0e01\u0e32\u0e19\u0e32" },
            { "GI", "\u0e22\u0e34\u0e1a\u0e23\u0e2d\u0e25\u0e15\u0e32\u0e23\u0e4c" },
            { "GL", metaValue_GL },
            { "GM", "\u0e41\u0e01\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "GN", "\u0e01\u0e34\u0e19\u0e35" },
            { "GP", "\u0e01\u0e27\u0e32\u0e40\u0e14\u0e2d\u0e25\u0e39\u0e1b" },
            { "GQ", "\u0e2d\u0e34\u0e40\u0e04\u0e27\u0e17\u0e2d\u0e40\u0e23\u0e35\u0e22\u0e25\u0e01\u0e34\u0e19\u0e35" },
            { "GR", "\u0e01\u0e23\u0e35\u0e0b" },
            { "GS", "\u0e40\u0e01\u0e32\u0e30\u0e40\u0e0b\u0e32\u0e17\u0e4c\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22\u0e41\u0e25\u0e30\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e0b\u0e32\u0e17\u0e4c\u0e41\u0e0b\u0e19\u0e14\u0e4c\u0e27\u0e34\u0e0a" },
            { "GT", "\u0e01\u0e31\u0e27\u0e40\u0e15\u0e21\u0e32\u0e25\u0e32" },
            { "GU", "\u0e01\u0e27\u0e21" },
            { "GW", "\u0e01\u0e34\u0e19\u0e35-\u0e1a\u0e34\u0e2a\u0e40\u0e0b\u0e32" },
            { "GY", "\u0e01\u0e32\u0e22\u0e2d\u0e32\u0e19\u0e32" },
            { "HK", "\u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e2e\u0e48\u0e2d\u0e07\u0e01\u0e07\u0e41\u0e2b\u0e48\u0e07\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e1b\u0e23\u0e30\u0e0a\u0e32\u0e0a\u0e19\u0e08\u0e35\u0e19" },
            { "HM", "\u0e40\u0e01\u0e32\u0e30\u0e40\u0e2e\u0e34\u0e23\u0e4c\u0e14\u0e41\u0e25\u0e30\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e41\u0e21\u0e01\u0e14\u0e2d\u0e19\u0e31\u0e25\u0e14\u0e4c" },
            { "HN", "\u0e2e\u0e2d\u0e19\u0e14\u0e39\u0e23\u0e31\u0e2a" },
            { "HR", metaValue_HR },
            { "HT", "\u0e40\u0e2e\u0e15\u0e34" },
            { "HU", metaValue_HU },
            { "IC", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e04\u0e32\u0e19\u0e32\u0e23\u0e35" },
            { "ID", metaValue_ID },
            { "IE", "\u0e44\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "IL", "\u0e2d\u0e34\u0e2a\u0e23\u0e32\u0e40\u0e2d\u0e25" },
            { "IM", "\u0e40\u0e01\u0e32\u0e30\u0e41\u0e21\u0e19" },
            { "IN", "\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22" },
            { "IO", "\u0e1a\u0e23\u0e34\u0e15\u0e34\u0e0a\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22\u0e19\u0e42\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e19\u0e40\u0e17\u0e23\u0e4c\u0e23\u0e34\u0e17\u0e2d\u0e23\u0e35" },
            { "IQ", "\u0e2d\u0e34\u0e23\u0e31\u0e01" },
            { "IR", "\u0e2d\u0e34\u0e2b\u0e23\u0e48\u0e32\u0e19" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "JE", "\u0e40\u0e08\u0e2d\u0e23\u0e4c\u0e0b\u0e35\u0e22\u0e4c" },
            { "JM", "\u0e08\u0e32\u0e40\u0e21\u0e01\u0e32" },
            { "JO", "\u0e08\u0e2d\u0e23\u0e4c\u0e41\u0e14\u0e19" },
            { "JP", metaValue_JP },
            { "KE", "\u0e40\u0e04\u0e19\u0e22\u0e32" },
            { "KG", "\u0e04\u0e35\u0e23\u0e4c\u0e01\u0e35\u0e0b\u0e2a\u0e16\u0e32\u0e19" },
            { "KH", "\u0e01\u0e31\u0e21\u0e1e\u0e39\u0e0a\u0e32" },
            { "KI", "\u0e04\u0e34\u0e23\u0e34\u0e1a\u0e32\u0e2a" },
            { "KM", "\u0e04\u0e2d\u0e42\u0e21\u0e42\u0e23\u0e2a" },
            { "KN", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e04\u0e34\u0e15\u0e2a\u0e4c\u0e41\u0e25\u0e30\u0e40\u0e19\u0e27\u0e34\u0e2a" },
            { "KP", "\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "KR", "\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e43\u0e15\u0e49" },
            { "KW", "\u0e04\u0e39\u0e40\u0e27\u0e15" },
            { "KY", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e04\u0e22\u0e4c\u0e41\u0e21\u0e19" },
            { "KZ", "\u0e04\u0e32\u0e0b\u0e31\u0e04\u0e2a\u0e16\u0e32\u0e19" },
            { "LA", metaValue_LA },
            { "LB", "\u0e40\u0e25\u0e1a\u0e32\u0e19\u0e2d\u0e19" },
            { "LC", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e25\u0e39\u0e40\u0e0b\u0e35\u0e22" },
            { "LI", "\u0e25\u0e34\u0e01\u0e40\u0e15\u0e19\u0e2a\u0e44\u0e15\u0e19\u0e4c" },
            { "LK", "\u0e28\u0e23\u0e35\u0e25\u0e31\u0e07\u0e01\u0e32" },
            { "LR", "\u0e44\u0e25\u0e1a\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "LS", "\u0e40\u0e25\u0e42\u0e0b\u0e42\u0e17" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "\u0e25\u0e34\u0e40\u0e1a\u0e35\u0e22" },
            { "MA", "\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01" },
            { "MC", "\u0e42\u0e21\u0e19\u0e32\u0e42\u0e01" },
            { "MD", metaValue_MD },
            { "ME", "\u0e21\u0e2d\u0e19\u0e40\u0e15\u0e40\u0e19\u0e42\u0e01\u0e23" },
            { "MF", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e21\u0e32\u0e23\u0e4c\u0e15\u0e34\u0e19" },
            { "MG", "\u0e21\u0e32\u0e14\u0e32\u0e01\u0e31\u0e2a\u0e01\u0e32\u0e23\u0e4c" },
            { "MH", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e21\u0e32\u0e23\u0e4c\u0e41\u0e0a\u0e25\u0e25\u0e4c" },
            { "MK", "\u0e21\u0e32\u0e0b\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "ML", "\u0e21\u0e32\u0e25\u0e35" },
            { "MM", "\u0e40\u0e21\u0e35\u0e22\u0e19\u0e21\u0e32 (\u0e1e\u0e21\u0e48\u0e32)" },
            { "MN", metaValue_MN },
            { "MO", "\u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e21\u0e32\u0e40\u0e01\u0e4a\u0e32\u0e41\u0e2b\u0e48\u0e07\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e1b\u0e23\u0e30\u0e0a\u0e32\u0e0a\u0e19\u0e08\u0e35\u0e19" },
            { "MP", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e17\u0e34\u0e23\u0e4c\u0e19\u0e21\u0e32\u0e40\u0e23\u0e35\u0e22\u0e19\u0e32" },
            { "MQ", "\u0e21\u0e32\u0e23\u0e4c\u0e15\u0e34\u0e19\u0e35\u0e01" },
            { "MR", "\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e15\u0e40\u0e19\u0e35\u0e22" },
            { "MS", "\u0e21\u0e2d\u0e19\u0e15\u0e4c\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e23\u0e31\u0e15" },
            { "MT", metaValue_MT },
            { "MU", "\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e0a\u0e35\u0e22\u0e2a" },
            { "MV", "\u0e21\u0e31\u0e25\u0e14\u0e35\u0e1f\u0e2a\u0e4c" },
            { "MW", "\u0e21\u0e32\u0e25\u0e32\u0e27\u0e35" },
            { "MX", "\u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01" },
            { "MY", "\u0e21\u0e32\u0e40\u0e25\u0e40\u0e0b\u0e35\u0e22" },
            { "MZ", "\u0e42\u0e21\u0e0b\u0e31\u0e21\u0e1a\u0e34\u0e01" },
            { "NA", "\u0e19\u0e32\u0e21\u0e34\u0e40\u0e1a\u0e35\u0e22" },
            { "NC", "\u0e19\u0e34\u0e27\u0e41\u0e04\u0e25\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22" },
            { "NE", "\u0e44\u0e19\u0e40\u0e08\u0e2d\u0e23\u0e4c" },
            { "NF", "\u0e40\u0e01\u0e32\u0e30\u0e19\u0e2d\u0e23\u0e4c\u0e1f\u0e2d\u0e25\u0e4c\u0e01" },
            { "NG", "\u0e44\u0e19\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "NI", "\u0e19\u0e34\u0e01\u0e32\u0e23\u0e32\u0e01\u0e31\u0e27" },
            { "NL", "\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "\u0e19\u0e35\u0e2d\u0e39\u0e40\u0e2d" },
            { "NZ", "\u0e19\u0e34\u0e27\u0e0b\u0e35\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "OM", "\u0e42\u0e2d\u0e21\u0e32\u0e19" },
            { "PA", "\u0e1b\u0e32\u0e19\u0e32\u0e21\u0e32" },
            { "PE", "\u0e40\u0e1b\u0e23\u0e39" },
            { "PF", "\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e42\u0e1b\u0e25\u0e34\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "PG", "\u0e1b\u0e32\u0e1b\u0e31\u0e27\u0e19\u0e34\u0e27\u0e01\u0e34\u0e19\u0e35" },
            { "PH", metaValue_PH },
            { "PK", "\u0e1b\u0e32\u0e01\u0e35\u0e2a\u0e16\u0e32\u0e19" },
            { "PL", metaValue_PL },
            { "PM", "\u0e41\u0e0b\u0e07\u0e1b\u0e35\u0e41\u0e22\u0e23\u0e4c\u0e41\u0e25\u0e30\u0e21\u0e35\u0e40\u0e01\u0e2d\u0e25\u0e07" },
            { "PN", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1e\u0e34\u0e15\u0e41\u0e04\u0e23\u0e4c\u0e19" },
            { "PR", "\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e42\u0e15\u0e23\u0e34\u0e42\u0e01" },
            { "PS", "\u0e14\u0e34\u0e19\u0e41\u0e14\u0e19\u0e1b\u0e32\u0e40\u0e25\u0e2a\u0e44\u0e15\u0e19\u0e4c" },
            { "PT", metaValue_PT },
            { "PW", metaValue_PW },
            { "PY", "\u0e1b\u0e32\u0e23\u0e32\u0e01\u0e27\u0e31\u0e22" },
            { "QA", "\u0e01\u0e32\u0e15\u0e32\u0e23\u0e4c" },
            { "QO", "\u0e40\u0e2d\u0e32\u0e15\u0e4c\u0e44\u0e25\u0e2d\u0e34\u0e07\u0e42\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e40\u0e19\u0e35\u0e22" },
            { "RE", "\u0e40\u0e23\u0e2d\u0e39\u0e19\u0e35\u0e22\u0e07" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "RU", metaValue_RU },
            { "RW", metaValue_RW },
            { "SA", "\u0e0b\u0e32\u0e2d\u0e38\u0e14\u0e35\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22" },
            { "SB", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e0b\u0e42\u0e25\u0e21\u0e2d\u0e19" },
            { "SC", "\u0e40\u0e0b\u0e40\u0e0a\u0e25\u0e2a\u0e4c" },
            { "SD", "\u0e0b\u0e39\u0e14\u0e32\u0e19" },
            { "SE", metaValue_SE },
            { "SG", "\u0e2a\u0e34\u0e07\u0e04\u0e42\u0e1b\u0e23\u0e4c" },
            { "SH", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e40\u0e2e\u0e40\u0e25\u0e19\u0e32" },
            { "SI", metaValue_SI },
            { "SJ", "\u0e2a\u0e1f\u0e32\u0e25\u0e1a\u0e32\u0e23\u0e4c\u0e41\u0e25\u0e30\u0e22\u0e32\u0e19\u0e44\u0e21\u0e40\u0e2d\u0e19" },
            { "SK", "\u0e2a\u0e42\u0e25\u0e27\u0e30\u0e40\u0e01\u0e35\u0e22" },
            { "SL", "\u0e40\u0e0b\u0e35\u0e22\u0e23\u0e4c\u0e23\u0e32\u0e25\u0e35\u0e42\u0e2d\u0e19" },
            { "SM", "\u0e0b\u0e32\u0e19\u0e21\u0e32\u0e23\u0e34\u0e42\u0e19" },
            { "SN", "\u0e40\u0e0b\u0e40\u0e19\u0e01\u0e31\u0e25" },
            { "SO", "\u0e42\u0e0b\u0e21\u0e32\u0e40\u0e25\u0e35\u0e22" },
            { "SR", "\u0e0b\u0e39\u0e23\u0e34\u0e19\u0e32\u0e40\u0e21" },
            { "SS", "\u0e0b\u0e39\u0e14\u0e32\u0e19\u0e43\u0e15\u0e49" },
            { "ST", "\u0e40\u0e0b\u0e32\u0e15\u0e39\u0e40\u0e21\u0e41\u0e25\u0e30\u0e1b\u0e23\u0e34\u0e19\u0e0b\u0e34\u0e1b\u0e35" },
            { "SV", "\u0e40\u0e2d\u0e25\u0e0b\u0e31\u0e25\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c" },
            { "SX", "\u0e0b\u0e34\u0e19\u0e15\u0e4c\u0e21\u0e32\u0e23\u0e4c\u0e40\u0e17\u0e19" },
            { "SY", metaValue_SY },
            { "SZ", "\u0e40\u0e2d\u0e2a\u0e27\u0e32\u0e15\u0e35\u0e19\u0e35" },
            { "TA", "\u0e17\u0e23\u0e34\u0e2a\u0e15\u0e31\u0e19\u0e14\u0e32\u0e04\u0e39\u0e19\u0e32" },
            { "TC", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e15\u0e34\u0e01\u0e2a\u0e4c\u0e41\u0e25\u0e30\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e04\u0e04\u0e2d\u0e2a" },
            { "TD", "\u0e0a\u0e32\u0e14" },
            { "TF", "\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e40\u0e0b\u0e32\u0e40\u0e17\u0e34\u0e23\u0e4c\u0e19\u0e40\u0e17\u0e23\u0e4c\u0e23\u0e34\u0e17\u0e2d\u0e23\u0e35\u0e2a\u0e4c" },
            { "TG", "\u0e42\u0e15\u0e42\u0e01" },
            { "TH", metaValue_TH },
            { "TJ", "\u0e17\u0e32\u0e08\u0e34\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "TK", metaValue_TK },
            { "TL", "\u0e15\u0e34\u0e21\u0e2d\u0e23\u0e4c-\u0e40\u0e25\u0e2a\u0e40\u0e15" },
            { "TM", "\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "TN", "\u0e15\u0e39\u0e19\u0e34\u0e40\u0e0b\u0e35\u0e22" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "\u0e15\u0e23\u0e34\u0e19\u0e34\u0e41\u0e14\u0e14\u0e41\u0e25\u0e30\u0e42\u0e15\u0e40\u0e1a\u0e42\u0e01" },
            { "TV", metaValue_TV },
            { "TW", "\u0e44\u0e15\u0e49\u0e2b\u0e27\u0e31\u0e19" },
            { "TZ", "\u0e41\u0e17\u0e19\u0e0b\u0e32\u0e40\u0e19\u0e35\u0e22" },
            { "UA", metaValue_UA },
            { "UG", metaValue_UG },
            { "UM", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e23\u0e2d\u0e1a\u0e19\u0e2d\u0e01\u0e02\u0e2d\u0e07\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "UN", "\u0e2a\u0e2b\u0e1b\u0e23\u0e30\u0e0a\u0e32\u0e0a\u0e32\u0e15\u0e34" },
            { "US", "\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "UY", "\u0e2d\u0e38\u0e23\u0e38\u0e01\u0e27\u0e31\u0e22" },
            { "UZ", "\u0e2d\u0e38\u0e0b\u0e40\u0e1a\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "VA", "\u0e19\u0e04\u0e23\u0e27\u0e32\u0e15\u0e34\u0e01\u0e31\u0e19" },
            { "VC", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e27\u0e34\u0e19\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e41\u0e25\u0e30\u0e40\u0e01\u0e23\u0e19\u0e32\u0e14\u0e35\u0e19\u0e2a\u0e4c" },
            { "VE", "\u0e40\u0e27\u0e40\u0e19\u0e0b\u0e38\u0e40\u0e2d\u0e25\u0e32" },
            { "VG", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1a\u0e23\u0e34\u0e15\u0e34\u0e0a\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e08\u0e34\u0e19" },
            { "VI", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e08\u0e34\u0e19\u0e02\u0e2d\u0e07\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "VN", metaValue_VN },
            { "VU", "\u0e27\u0e32\u0e19\u0e39\u0e2d\u0e32\u0e15\u0e39" },
            { "WF", "\u0e27\u0e32\u0e25\u0e25\u0e34\u0e2a\u0e41\u0e25\u0e30\u0e1f\u0e38\u0e15\u0e39\u0e19\u0e32" },
            { "WS", metaValue_WS },
            { "XA", "\u0e2a\u0e33\u0e40\u0e19\u0e35\u0e22\u0e07\u0e44\u0e21\u0e48\u0e08\u0e23\u0e34\u0e07" },
            { "XB", "Bidi \u0e44\u0e21\u0e48\u0e08\u0e23\u0e34\u0e07" },
            { "XK", "\u0e42\u0e04\u0e42\u0e0b\u0e42\u0e27" },
            { "YE", "\u0e40\u0e22\u0e40\u0e21\u0e19" },
            { "YT", "\u0e21\u0e32\u0e22\u0e2d\u0e15" },
            { "ZA", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49" },
            { "ZM", "\u0e41\u0e0b\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "ZW", "\u0e0b\u0e34\u0e21\u0e1a\u0e31\u0e1a\u0e40\u0e27" },
            { "ZZ", "\u0e20\u0e39\u0e21\u0e34\u0e20\u0e32\u0e04\u0e17\u0e35\u0e48\u0e44\u0e21\u0e48\u0e23\u0e39\u0e49\u0e08\u0e31\u0e01" },
            { "aa", "\u0e2d\u0e30\u0e1f\u0e32\u0e23\u0e4c" },
            { "ab", "\u0e2d\u0e31\u0e1a\u0e2e\u0e32\u0e40\u0e0b\u0e35\u0e22" },
            { "ae", metaValue_ae },
            { "af", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e19\u0e2a\u0e4c" },
            { "ak", "\u0e2d\u0e32\u0e04\u0e32\u0e19" },
            { "am", "\u0e2d\u0e31\u0e21\u0e2e\u0e32\u0e23\u0e32" },
            { "an", "\u0e2d\u0e32\u0e23\u0e32\u0e01\u0e2d\u0e19" },
            { "ar", metaValue_ar },
            { "as", "\u0e2d\u0e31\u0e2a\u0e2a\u0e31\u0e21" },
            { "av", "\u0e2d\u0e32\u0e27\u0e32\u0e23\u0e4c" },
            { "ay", "\u0e44\u0e2d\u0e22\u0e4c\u0e21\u0e32\u0e23\u0e32" },
            { "az", metaValue_AZ },
            { "ba", "\u0e1a\u0e31\u0e0a\u0e04\u0e35\u0e23\u0e4c" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "\u0e1a\u0e34\u0e2a\u0e25\u0e32\u0e21\u0e32" },
            { "bm", "\u0e1a\u0e31\u0e21\u0e1a\u0e32\u0e23\u0e32" },
            { "bn", "\u0e1a\u0e31\u0e07\u0e01\u0e25\u0e32" },
            { "bo", metaValue_bo },
            { "br", "\u0e40\u0e1a\u0e23\u0e15\u0e31\u0e19" },
            { "bs", "\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22" },
            { "ca", "\u0e04\u0e32\u0e15\u0e32\u0e25\u0e31\u0e19" },
            { "ce", "\u0e40\u0e0a\u0e40\u0e0a\u0e19" },
            { "ch", "\u0e0a\u0e32\u0e21\u0e2d\u0e23\u0e4c\u0e42\u0e23" },
            { "co", "\u0e04\u0e2d\u0e23\u0e4c\u0e0b\u0e34\u0e01\u0e32" },
            { "cr", "\u0e04\u0e23\u0e35" },
            { "cs", metaValue_CZ },
            { "cu", "\u0e40\u0e0a\u0e2d\u0e23\u0e4c\u0e0a\u0e2a\u0e25\u0e32\u0e27\u0e34\u0e01" },
            { "cv", "\u0e0a\u0e39\u0e27\u0e31\u0e0a" },
            { "cy", "\u0e40\u0e27\u0e25\u0e2a\u0e4c" },
            { "da", metaValue_DK },
            { "de", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19" },
            { "dv", "\u0e18\u0e34\u0e40\u0e27\u0e2b\u0e34" },
            { "dz", "\u0e0b\u0e2d\u0e07\u0e04\u0e32" },
            { "ee", "\u0e40\u0e2d\u0e40\u0e27" },
            { "el", metaValue_el },
            { "en", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29" },
            { "eo", "\u0e40\u0e2d\u0e2a\u0e40\u0e1b\u0e23\u0e31\u0e19\u0e42\u0e15" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "eu", "\u0e1a\u0e32\u0e2a\u0e01\u0e4c" },
            { "fa", "\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e35\u0e22" },
            { "ff", "\u0e1f\u0e39\u0e25\u0e32\u0e2b\u0e4c" },
            { "fi", metaValue_FI },
            { "fj", metaValue_FJ },
            { "fo", "\u0e41\u0e1f\u0e42\u0e23" },
            { "fr", metaValue_FR },
            { "fy", "\u0e1f\u0e23\u0e34\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "ga", "\u0e44\u0e2d\u0e23\u0e34\u0e0a" },
            { "gd", "\u0e40\u0e01\u0e25\u0e34\u0e01\u0e2a\u0e01\u0e2d\u0e15" },
            { "gl", "\u0e01\u0e32\u0e25\u0e34\u0e40\u0e0b\u0e35\u0e22" },
            { "gn", "\u0e01\u0e31\u0e27\u0e23\u0e32\u0e19\u0e35" },
            { "gu", metaValue_gu },
            { "gv", "\u0e21\u0e32\u0e19\u0e0b\u0e4c" },
            { "ha", "\u0e40\u0e2e\u0e32\u0e0b\u0e32" },
            { "he", "\u0e2e\u0e34\u0e1a\u0e23\u0e39" },
            { "hi", "\u0e2e\u0e34\u0e19\u0e14\u0e35" },
            { "ho", "\u0e2e\u0e35\u0e23\u0e35\u0e42\u0e21\u0e15\u0e39" },
            { "hr", metaValue_HR },
            { "ht", "\u0e40\u0e2e\u0e15\u0e34\u0e04\u0e23\u0e35\u0e42\u0e2d\u0e25" },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "\u0e40\u0e2e\u0e40\u0e23\u0e42\u0e23" },
            { "ia", "\u0e2d\u0e34\u0e19\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e25\u0e34\u0e07\u0e01\u0e31\u0e27" },
            { "id", metaValue_ID },
            { "ie", "\u0e2d\u0e34\u0e19\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e25\u0e34\u0e07\u0e01\u0e34\u0e27" },
            { "ig", "\u0e2d\u0e34\u0e01\u0e42\u0e1a" },
            { "ii", "\u0e40\u0e2a\u0e09\u0e27\u0e19\u0e22\u0e35\u0e48" },
            { "ik", "\u0e2d\u0e35\u0e19\u0e39\u0e40\u0e1b\u0e35\u0e22\u0e01" },
            { "io", "\u0e2d\u0e35\u0e42\u0e14" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "\u0e2d\u0e34\u0e19\u0e38\u0e01\u0e15\u0e34\u0e15\u0e38\u0e15" },
            { "ja", metaValue_JP },
            { "jv", metaValue_jv },
            { "ka", metaValue_GE },
            { "kg", "\u0e04\u0e2d\u0e07\u0e42\u0e01" },
            { "ki", "\u0e01\u0e35\u0e01\u0e39\u0e22\u0e39" },
            { "kj", "\u0e01\u0e27\u0e19\u0e22\u0e32\u0e21\u0e32" },
            { "kk", "\u0e04\u0e32\u0e0b\u0e31\u0e04" },
            { "kl", metaValue_GL },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0e04\u0e32\u0e19\u0e39\u0e23\u0e35" },
            { "ks", "\u0e41\u0e04\u0e0a\u0e40\u0e21\u0e35\u0e22\u0e23\u0e4c" },
            { "ku", "\u0e40\u0e04\u0e34\u0e23\u0e4c\u0e14" },
            { "kv", "\u0e42\u0e01\u0e21\u0e34" },
            { "kw", "\u0e04\u0e2d\u0e23\u0e4c\u0e19\u0e34\u0e0a" },
            { "ky", "\u0e04\u0e35\u0e23\u0e4c\u0e01\u0e35\u0e0b" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", metaValue_UG },
            { "li", "\u0e25\u0e34\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01" },
            { "ln", "\u0e25\u0e34\u0e07\u0e01\u0e32\u0e25\u0e32" },
            { "lo", metaValue_LA },
            { "lt", metaValue_LT },
            { "lu", "\u0e25\u0e39\u0e1a\u0e32-\u0e01\u0e32\u0e15\u0e2d\u0e07\u0e01\u0e32" },
            { "lv", metaValue_LV },
            { "mg", "\u0e21\u0e32\u0e25\u0e32\u0e01\u0e32\u0e0b\u0e35" },
            { "mh", "\u0e21\u0e32\u0e23\u0e4c\u0e41\u0e0a\u0e25\u0e25\u0e4c" },
            { "mi", "\u0e40\u0e21\u0e32\u0e23\u0e35" },
            { "mk", "\u0e21\u0e32\u0e0b\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22" },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "\u0e21\u0e23\u0e32\u0e10\u0e35" },
            { "ms", "\u0e21\u0e32\u0e40\u0e25\u0e22\u0e4c" },
            { "mt", metaValue_MT },
            { "my", metaValue_my },
            { "na", metaValue_NR },
            { "nb", "\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c\u0e1a\u0e38\u0e04\u0e21\u0e2d\u0e25" },
            { "nd", "\u0e40\u0e2d\u0e47\u0e19\u0e40\u0e14\u0e40\u0e1a\u0e40\u0e25\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "ne", metaValue_NP },
            { "ng", "\u0e14\u0e2d\u0e07\u0e01\u0e32" },
            { "nl", "\u0e14\u0e31\u0e15\u0e0a\u0e4c" },
            { "nn", "\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c\u0e19\u0e35\u0e19\u0e2d\u0e2a\u0e01\u0e4c" },
            { "no", metaValue_NO },
            { "nr", "\u0e40\u0e2d\u0e47\u0e19\u0e40\u0e14\u0e40\u0e1a\u0e40\u0e25\u0e43\u0e15\u0e49" },
            { "nv", "\u0e19\u0e32\u0e27\u0e32\u0e42\u0e2e" },
            { "ny", "\u0e40\u0e19\u0e35\u0e22\u0e19\u0e08\u0e32" },
            { "oc", "\u0e2d\u0e47\u0e2d\u0e01\u0e0b\u0e34\u0e15\u0e31\u0e19" },
            { "oj", "\u0e42\u0e2d\u0e08\u0e34\u0e1a\u0e27\u0e32" },
            { "om", "\u0e42\u0e2d\u0e42\u0e23\u0e42\u0e21" },
            { "or", "\u0e42\u0e2d\u0e14\u0e34\u0e22\u0e32" },
            { "os", "\u0e2d\u0e2d\u0e2a\u0e40\u0e0b\u0e40\u0e15\u0e35\u0e22" },
            { "pa", "\u0e1b\u0e31\u0e0d\u0e08\u0e32\u0e1a" },
            { "pi", "\u0e1a\u0e32\u0e25\u0e35" },
            { "pl", metaValue_PL },
            { "ps", "\u0e1e\u0e31\u0e0a\u0e42\u0e15" },
            { "pt", metaValue_PT },
            { "qu", "\u0e40\u0e04\u0e0a\u0e27\u0e32" },
            { "rm", "\u0e42\u0e23\u0e41\u0e21\u0e19\u0e0b\u0e4c" },
            { "rn", metaValue_BI },
            { "ro", metaValue_RO },
            { "ru", metaValue_RU },
            { "rw", metaValue_RW },
            { "sa", "\u0e2a\u0e31\u0e19\u0e2a\u0e01\u0e24\u0e15" },
            { "sc", "\u0e0b\u0e32\u0e23\u0e4c\u0e40\u0e14\u0e0d\u0e32" },
            { "sd", "\u0e2a\u0e34\u0e19\u0e18\u0e34" },
            { "se", "\u0e0b\u0e32\u0e21\u0e34\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "sg", "\u0e0b\u0e31\u0e19\u0e42\u0e01" },
            { "sh", "\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e42\u0e1a-\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22" },
            { "si", metaValue_si },
            { "sk", "\u0e2a\u0e42\u0e25\u0e27\u0e31\u0e01" },
            { "sl", metaValue_SI },
            { "sm", metaValue_WS },
            { "sn", "\u0e42\u0e0a\u0e19\u0e32" },
            { "so", "\u0e42\u0e0b\u0e21\u0e32\u0e25\u0e35" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", "\u0e2a\u0e27\u0e32\u0e15\u0e34" },
            { "st", "\u0e42\u0e0b\u0e42\u0e17\u0e43\u0e15\u0e49" },
            { "su", metaValue_su },
            { "sv", metaValue_SE },
            { "sw", "\u0e2a\u0e27\u0e32\u0e2e\u0e35\u0e25\u0e35" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u0e17\u0e32\u0e08\u0e34\u0e01" },
            { "th", metaValue_TH },
            { "ti", "\u0e15\u0e34\u0e01\u0e23\u0e34\u0e0d\u0e0d\u0e32" },
            { "tk", "\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19" },
            { "tl", metaValue_tl },
            { "tn", "\u0e2a\u0e27\u0e32\u0e19\u0e32" },
            { "to", metaValue_TO },
            { "tr", metaValue_TR },
            { "ts", "\u0e0b\u0e2d\u0e07\u0e01\u0e32" },
            { "tt", "\u0e15\u0e32\u0e15\u0e32\u0e23\u0e4c" },
            { "tw", "\u0e17\u0e27\u0e34" },
            { "ty", "\u0e15\u0e32\u0e2e\u0e34\u0e15\u0e35" },
            { "ug", "\u0e2d\u0e38\u0e22\u0e01\u0e39\u0e23\u0e4c" },
            { "uk", metaValue_UA },
            { "ur", "\u0e2d\u0e39\u0e23\u0e14\u0e39" },
            { "uz", "\u0e2d\u0e38\u0e0b\u0e40\u0e1a\u0e01" },
            { "ve", "\u0e40\u0e27\u0e19\u0e14\u0e32" },
            { "vi", metaValue_VN },
            { "vo", "\u0e42\u0e27\u0e25\u0e32\u0e1e\u0e36\u0e04" },
            { "wa", "\u0e27\u0e2d\u0e25\u0e25\u0e39\u0e19" },
            { "wo", "\u0e42\u0e27\u0e25\u0e2d\u0e1f" },
            { "xh", "\u0e04\u0e30\u0e2b\u0e4c\u0e42\u0e2d\u0e0b\u0e32" },
            { "yi", "\u0e22\u0e34\u0e14\u0e14\u0e34\u0e0a" },
            { "yo", "\u0e42\u0e22\u0e23\u0e39\u0e1a\u0e32" },
            { "za", "\u0e08\u0e49\u0e27\u0e07" },
            { "zh", metaValue_CN },
            { "zu", "\u0e0b\u0e39\u0e25\u0e39" },
            { "ace", "\u0e2d\u0e32\u0e40\u0e08\u0e30\u0e2b\u0e4c" },
            { "ach", "\u0e2d\u0e32\u0e42\u0e04\u0e25\u0e34" },
            { "ada", "\u0e2d\u0e32\u0e41\u0e14\u0e07\u0e21\u0e35" },
            { "ady", "\u0e2d\u0e30\u0e14\u0e37\u0e22\u0e40\u0e01" },
            { "aeb", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e15\u0e39\u0e19\u0e34\u0e40\u0e0b\u0e35\u0e22" },
            { "afh", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e2e\u0e35\u0e25\u0e35" },
            { "agq", "\u0e2d\u0e31\u0e01\u0e40\u0e2e\u0e21" },
            { "ain", "\u0e44\u0e2d\u0e19\u0e38" },
            { "akk", "\u0e2d\u0e31\u0e01\u0e01\u0e32\u0e14" },
            { "akz", "\u0e41\u0e2d\u0e25\u0e30\u0e41\u0e1a\u0e21\u0e32" },
            { "ale", "\u0e2d\u0e32\u0e25\u0e34\u0e27\u0e15\u0e4c" },
            { "aln", "\u0e40\u0e01\u0e01\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22" },
            { "alt", "\u0e2d\u0e31\u0e25\u0e44\u0e15\u0e43\u0e15\u0e49" },
            { "ang", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "ann", "\u0e42\u0e2d\u0e42\u0e1a\u0e42\u0e25" },
            { "anp", "\u0e2d\u0e31\u0e07\u0e04\u0e34\u0e01\u0e32" },
            { "arc", "\u0e2d\u0e23\u0e32\u0e40\u0e21\u0e2d\u0e34\u0e01" },
            { "arn", "\u0e21\u0e32\u0e1b\u0e39\u0e40\u0e0a" },
            { "aro", "\u0e2d\u0e32\u0e40\u0e23\u0e32\u0e19\u0e32" },
            { "arp", "\u0e2d\u0e32\u0e23\u0e32\u0e1b\u0e32\u0e42\u0e2e" },
            { "arq", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e41\u0e2d\u0e25\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "ars", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e19\u0e31\u0e08\u0e0d\u0e4c\u0e14\u0e35" },
            { "arw", "\u0e2d\u0e32\u0e23\u0e32\u0e27\u0e31\u0e01" },
            { "ary", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01" },
            { "arz", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "asa", "\u0e2d\u0e32\u0e0b\u0e39" },
            { "ase", "\u0e20\u0e32\u0e29\u0e32\u0e21\u0e37\u0e2d\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19" },
            { "ast", "\u0e2d\u0e31\u0e2a\u0e15\u0e39\u0e40\u0e23\u0e35\u0e22\u0e2a" },
            { "atj", "\u0e2d\u0e30\u0e17\u0e34\u0e04\u0e32\u0e40\u0e21\u0e01" },
            { "avk", "\u0e42\u0e04\u0e15\u0e32\u0e27\u0e32" },
            { "awa", "\u0e2d\u0e27\u0e18\u0e35" },
            { "bal", "\u0e1a\u0e32\u0e25\u0e39\u0e0a\u0e34" },
            { "ban", metaValue_ban },
            { "bar", "\u0e1a\u0e32\u0e27\u0e32\u0e40\u0e23\u0e35\u0e22" },
            { "bas", "\u0e1a\u0e32\u0e2a\u0e32" },
            { "bax", "\u0e1a\u0e32\u0e21\u0e31\u0e19" },
            { "bbc", "\u0e1a\u0e32\u0e15\u0e31\u0e01\u0e42\u0e17\u0e1a\u0e32" },
            { "bbj", "\u0e42\u0e04\u0e21\u0e32\u0e25\u0e32" },
            { "bej", "\u0e40\u0e1a\u0e08\u0e32" },
            { "bem", "\u0e40\u0e1a\u0e21\u0e1a\u0e32" },
            { "bew", "\u0e40\u0e1a\u0e15\u0e32\u0e27\u0e35" },
            { "bez", "\u0e40\u0e1a\u0e19\u0e32" },
            { "bfd", "\u0e1a\u0e32\u0e1f\u0e31\u0e15" },
            { "bfq", "\u0e1e\u0e17\u0e04\u0e30" },
            { "bgc", "\u0e2b\u0e23\u0e34\u0e22\u0e19\u0e27\u0e35" },
            { "bgn", "\u0e1a\u0e32\u0e25\u0e39\u0e08\u0e34\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "bho", "\u0e42\u0e20\u0e0a\u0e1b\u0e38\u0e23\u0e35" },
            { "bik", "\u0e1a\u0e34\u0e01\u0e2d\u0e25" },
            { "bin", "\u0e1a\u0e34\u0e19\u0e35" },
            { "bjn", "\u0e1a\u0e31\u0e19\u0e08\u0e32\u0e23\u0e4c" },
            { "bkm", "\u0e01\u0e21" },
            { "bla", "\u0e2a\u0e34\u0e01\u0e2a\u0e34\u0e01\u0e32" },
            { "blo", "\u0e2d\u0e32\u0e19\u0e35" },
            { "bpy", "\u0e1e\u0e34\u0e28\u0e19\u0e38\u0e1b\u0e23\u0e34\u0e22\u0e30" },
            { "bqi", "\u0e1a\u0e31\u0e01\u0e15\u0e34\u0e22\u0e32\u0e23\u0e35" },
            { "bra", "\u0e1e\u0e31\u0e23\u0e0a" },
            { "brh", "\u0e1a\u0e23\u0e32\u0e2e\u0e38\u0e22" },
            { "brx", "\u0e42\u0e1e\u0e42\u0e11" },
            { "bss", "\u0e2d\u0e32\u0e42\u0e04\u0e0b\u0e35" },
            { "bua", "\u0e1a\u0e39\u0e40\u0e23\u0e35\u0e22\u0e15" },
            { "bug", metaValue_bug },
            { "bum", "\u0e1a\u0e39\u0e25\u0e39" },
            { "byn", "\u0e1a\u0e25\u0e34\u0e19" },
            { "byv", "\u0e40\u0e21\u0e14\u0e38\u0e21\u0e1a\u0e32" },
            { "cad", "\u0e04\u0e31\u0e14\u0e42\u0e14" },
            { "car", "\u0e04\u0e32\u0e23\u0e34\u0e1a" },
            { "cay", "\u0e04\u0e32\u0e22\u0e39\u0e01\u0e32" },
            { "cch", "\u0e41\u0e2d\u0e15\u0e41\u0e0b\u0e21" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u0e40\u0e0b\u0e1a\u0e39" },
            { "cgg", "\u0e04\u0e35\u0e01\u0e32" },
            { "chb", "\u0e0a\u0e34\u0e1a\u0e0a\u0e32" },
            { "chg", "\u0e0a\u0e30\u0e01\u0e30\u0e44\u0e15" },
            { "chk", "\u0e0a\u0e39\u0e01" },
            { "chm", "\u0e21\u0e32\u0e23\u0e35" },
            { "chn", "\u0e0a\u0e34\u0e19\u0e38\u0e01\u0e08\u0e32\u0e23\u0e4c\u0e01\u0e2d\u0e19" },
            { "cho", "\u0e0a\u0e47\u0e2d\u0e01\u0e17\u0e2d\u0e27\u0e4c" },
            { "chp", "\u0e0a\u0e34\u0e1e\u0e34\u0e27\u0e22\u0e31\u0e19" },
            { "chr", metaValue_chr },
            { "chy", "\u0e40\u0e0a\u0e40\u0e22\u0e19\u0e40\u0e19" },
            { "ckb", "\u0e40\u0e04\u0e34\u0e23\u0e4c\u0e14\u0e15\u0e2d\u0e19\u0e01\u0e25\u0e32\u0e07" },
            { "clc", "\u0e0a\u0e34\u0e25\u0e42\u0e04\u0e15\u0e34\u0e19" },
            { "cop", metaValue_cop },
            { "cps", "\u0e01\u0e32\u0e1b\u0e34\u0e0b\u0e19\u0e2d\u0e19" },
            { "crg", "\u0e21\u0e34\u0e0a\u0e34\u0e1f" },
            { "crh", "\u0e15\u0e38\u0e23\u0e01\u0e35\u0e44\u0e04\u0e23\u0e40\u0e21\u0e35\u0e22" },
            { "crj", "\u0e04\u0e23\u0e35\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01\u0e40\u0e09\u0e35\u0e22\u0e07\u0e43\u0e15\u0e49" },
            { "crk", "\u0e40\u0e1e\u0e25\u0e19\u0e2a\u0e4c\u0e04\u0e23\u0e35" },
            { "crl", "\u0e04\u0e23\u0e35\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01\u0e40\u0e09\u0e35\u0e22\u0e07\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "crm", "\u0e21\u0e39\u0e2a\u0e04\u0e23\u0e35" },
            { "crr", "\u0e2d\u0e31\u0e25\u0e01\u0e2d\u0e19\u0e04\u0e27\u0e34\u0e19\u0e41\u0e04\u0e42\u0e23\u0e44\u0e25\u0e19\u0e32" },
            { "crs", "\u0e04\u0e23\u0e35\u0e42\u0e2d\u0e25\u0e40\u0e0b\u0e40\u0e0b\u0e25\u0e2a\u0e4c\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a" },
            { "csb", "\u0e04\u0e32\u0e0b\u0e39\u0e40\u0e1a\u0e35\u0e22\u0e19" },
            { "csw", "\u0e2a\u0e27\u0e2d\u0e21\u0e1b\u0e35\u0e04\u0e23\u0e35" },
            { "dak", "\u0e14\u0e32\u0e42\u0e01\u0e17\u0e32" },
            { "dar", "\u0e14\u0e32\u0e23\u0e4c\u0e01\u0e34\u0e19" },
            { "dav", "\u0e44\u0e17\u0e17\u0e32" },
            { "del", "\u0e40\u0e14\u0e25\u0e32\u0e41\u0e27\u0e23\u0e4c" },
            { "den", "\u0e2a\u0e40\u0e25\u0e27\u0e35" },
            { "dgr", "\u0e42\u0e14\u0e01\u0e23\u0e34\u0e1a" },
            { "din", "\u0e14\u0e34\u0e07\u0e01\u0e32" },
            { "dje", "\u0e0b\u0e32\u0e23\u0e4c\u0e21\u0e32" },
            { "doi", "\u0e42\u0e11\u0e04\u0e23\u0e35" },
            { "dsb", "\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22\u0e15\u0e2d\u0e19\u0e25\u0e48\u0e32\u0e07" },
            { "dtp", "\u0e14\u0e39\u0e0b\u0e38\u0e19\u0e01\u0e25\u0e32\u0e07" },
            { "dua", "\u0e14\u0e31\u0e27\u0e25\u0e32" },
            { "dum", "\u0e14\u0e31\u0e15\u0e0a\u0e4c\u0e01\u0e25\u0e32\u0e07" },
            { "dyo", "\u0e42\u0e08\u0e25\u0e32-\u0e1f\u0e2d\u0e19\u0e22\u0e35" },
            { "dyu", "\u0e14\u0e34\u0e27\u0e25\u0e32" },
            { "dzg", "\u0e14\u0e32\u0e0b\u0e32\u0e01\u0e32" },
            { "ebu", "\u0e40\u0e2d\u0e47\u0e21\u0e1a\u0e39" },
            { "efi", "\u0e2d\u0e35\u0e1f\u0e34\u0e01" },
            { "egl", "\u0e40\u0e2d\u0e21\u0e35\u0e40\u0e25\u0e35\u0e22" },
            { "egy", "\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "eka", "\u0e2d\u0e35\u0e01\u0e32\u0e08\u0e38\u0e01" },
            { "elx", "\u0e2d\u0e35\u0e25\u0e32\u0e44\u0e21\u0e15\u0e4c" },
            { "enm", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e01\u0e25\u0e32\u0e07" },
            { "esu", "\u0e22\u0e39\u0e1e\u0e34\u0e01\u0e01\u0e25\u0e32\u0e07" },
            { "ewo", "\u0e2d\u0e35\u0e27\u0e31\u0e19\u0e42\u0e14" },
            { "ext", "\u0e40\u0e2d\u0e01\u0e0b\u0e4c\u0e40\u0e15\u0e23\u0e21\u0e32\u0e14\u0e39\u0e23\u0e32" },
            { "fan", "\u0e1f\u0e2d\u0e07" },
            { "fat", "\u0e1f\u0e31\u0e19\u0e15\u0e34" },
            { "fil", metaValue_PH },
            { "fit", "\u0e1f\u0e34\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e17\u0e2d\u0e23\u0e4c\u0e40\u0e19\u0e14\u0e32\u0e40\u0e25\u0e47\u0e19" },
            { "fon", "\u0e1f\u0e2d\u0e19" },
            { "frc", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a\u0e40\u0e04\u0e08\u0e31\u0e19" },
            { "frm", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a\u0e01\u0e25\u0e32\u0e07" },
            { "fro", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "frp", "\u0e2d\u0e32\u0e23\u0e4c\u0e1e\u0e34\u0e15\u0e32" },
            { "frr", "\u0e1f\u0e23\u0e34\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "frs", "\u0e1f\u0e23\u0e34\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "fur", "\u0e1f\u0e23\u0e39\u0e25\u0e35" },
            { "gaa", "\u0e01\u0e32" },
            { "gag", "\u0e01\u0e32\u0e01\u0e32\u0e2d\u0e38\u0e0b" },
            { "gan", "\u0e08\u0e35\u0e19\u0e01\u0e31\u0e49\u0e19" },
            { "gay", "\u0e01\u0e32\u0e42\u0e22" },
            { "gba", "\u0e01\u0e1a\u0e32\u0e22\u0e32" },
            { "gbz", "\u0e14\u0e32\u0e23\u0e35\u0e42\u0e0b\u0e42\u0e23\u0e2d\u0e31\u0e2a\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "gez", "\u0e01\u0e35\u0e0b" },
            { "gil", "\u0e01\u0e34\u0e25\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e15" },
            { "glk", "\u0e01\u0e34\u0e25\u0e32\u0e01\u0e35" },
            { "gmh", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2a\u0e39\u0e07\u0e01\u0e25\u0e32\u0e07" },
            { "goh", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2a\u0e39\u0e07\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "gon", "\u0e01\u0e2d\u0e19\u0e14\u0e34" },
            { "gor", "\u0e01\u0e2d\u0e23\u0e2d\u0e19\u0e17\u0e32\u0e42\u0e25" },
            { "got", metaValue_got },
            { "grb", "\u0e40\u0e01\u0e23\u0e42\u0e1a" },
            { "grc", "\u0e01\u0e23\u0e35\u0e01\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "gsw", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2a\u0e27\u0e34\u0e2a" },
            { "guc", "\u0e27\u0e32\u0e22\u0e39" },
            { "gur", "\u0e1f\u0e23\u0e32\u0e1f\u0e23\u0e32" },
            { "guz", "\u0e01\u0e38\u0e0b\u0e0b\u0e35" },
            { "gwi", "\u0e01\u0e27\u0e34\u0e0a\u0e2d\u0e34\u0e19" },
            { "hai", "\u0e44\u0e2e\u0e14\u0e32" },
            { "hak", "\u0e08\u0e35\u0e19\u0e41\u0e04\u0e30" },
            { "haw", "\u0e2e\u0e32\u0e27\u0e32\u0e22" },
            { "hax", "\u0e40\u0e2e\u0e14\u0e32\u0e43\u0e15\u0e49" },
            { "hif", "\u0e2e\u0e34\u0e19\u0e14\u0e35\u0e1f\u0e34\u0e08\u0e34" },
            { "hil", "\u0e2e\u0e35\u0e25\u0e35\u0e01\u0e31\u0e22\u0e19\u0e19" },
            { "hit", "\u0e2e\u0e34\u0e15\u0e44\u0e15\u0e15\u0e4c" },
            { "hmn", "\u0e21\u0e49\u0e07" },
            { "hsb", "\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22\u0e15\u0e2d\u0e19\u0e1a\u0e19" },
            { "hsn", "\u0e08\u0e35\u0e19\u0e40\u0e0b\u0e35\u0e22\u0e07" },
            { "hup", "\u0e2e\u0e39\u0e1b\u0e32" },
            { "hur", "\u0e2e\u0e31\u0e25\u0e42\u0e01\u0e40\u0e21\u0e40\u0e25\u0e21" },
            { "iba", "\u0e2d\u0e34\u0e1a\u0e32\u0e19" },
            { "ibb", "\u0e2d\u0e34\u0e1a\u0e34\u0e1a\u0e34\u0e42\u0e2d" },
            { "ikt", "\u0e2d\u0e34\u0e19\u0e38\u0e01\u0e15\u0e34\u0e15\u0e38\u0e15\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "ilo", "\u0e2d\u0e35\u0e42\u0e25\u0e42\u0e01" },
            { "inh", "\u0e2d\u0e34\u0e19\u0e01\u0e38\u0e0a" },
            { "izh", "\u0e2d\u0e34\u0e19\u0e40\u0e01\u0e23\u0e35\u0e22\u0e19" },
            { "jam", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e04\u0e25\u0e35\u0e42\u0e2d\u0e25\u0e08\u0e32\u0e40\u0e21\u0e01\u0e32" },
            { "jbo", "\u0e42\u0e25\u0e0a\u0e1a\u0e31\u0e19" },
            { "jgo", "\u0e2d\u0e36\u0e19\u0e01\u0e2d\u0e21\u0e1a\u0e32" },
            { "jmc", "\u0e21\u0e32\u0e0a\u0e32\u0e40\u0e21" },
            { "jpr", "\u0e22\u0e34\u0e27-\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e35\u0e22" },
            { "jrb", "\u0e22\u0e34\u0e27-\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a" },
            { "jut", "\u0e08\u0e31\u0e17" },
            { "kaa", "\u0e01\u0e32\u0e23\u0e32-\u0e01\u0e32\u0e25\u0e1e\u0e32\u0e01" },
            { "kab", "\u0e01\u0e32\u0e44\u0e1a\u0e25" },
            { "kac", "\u0e01\u0e30\u0e09\u0e34\u0e48\u0e19" },
            { "kaj", "\u0e04\u0e08\u0e39" },
            { "kam", "\u0e04\u0e31\u0e21\u0e1a\u0e32" },
            { "kaw", "\u0e01\u0e27\u0e35" },
            { "kbd", "\u0e04\u0e32\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e14\u0e35\u0e22" },
            { "kbl", "\u0e04\u0e32\u0e40\u0e19\u0e21\u0e1a\u0e39" },
            { "kcg", "\u0e17\u0e35\u0e41\u0e22\u0e1b" },
            { "kde", "\u0e21\u0e32\u0e04\u0e2d\u0e19\u0e40\u0e14" },
            { "kea", "\u0e04\u0e32\u0e1a\u0e39\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e40\u0e14\u0e35\u0e22\u0e19\u0e39" },
            { "ken", "\u0e40\u0e01\u0e34\u0e19\u0e22\u0e32\u0e07" },
            { "kfo", "\u0e42\u0e04\u0e42\u0e23" },
            { "kgp", "\u0e40\u0e04\u0e19\u0e01\u0e48\u0e32\u0e07" },
            { "kha", "\u0e01\u0e32\u0e2a\u0e35" },
            { "kho", "\u0e42\u0e04\u0e15\u0e31\u0e19" },
            { "khq", "\u0e42\u0e04\u0e22\u0e4c\u0e23\u0e32\u0e0a\u0e35\u0e19\u0e35" },
            { "khw", "\u0e42\u0e04\u0e27\u0e32\u0e23\u0e4c" },
            { "kiu", "\u0e40\u0e04\u0e2d\u0e23\u0e4c\u0e21\u0e32\u0e19\u0e34\u0e01\u0e34" },
            { "kkj", "\u0e04\u0e32\u0e42\u0e01" },
            { "kln", "\u0e04\u0e32\u0e40\u0e25\u0e19\u0e08\u0e34\u0e19" },
            { "kmb", "\u0e04\u0e34\u0e21\u0e1a\u0e38\u0e19\u0e14\u0e39" },
            { "koi", "\u0e42\u0e04\u0e21\u0e34-\u0e40\u0e1b\u0e35\u0e22\u0e23\u0e4c\u0e40\u0e21\u0e35\u0e22\u0e04" },
            { "kok", "\u0e01\u0e2d\u0e19\u0e01\u0e32\u0e19\u0e35" },
            { "kos", "\u0e04\u0e39\u0e2a\u0e44\u0e23" },
            { "kpe", "\u0e01\u0e32\u0e41\u0e1b\u0e25" },
            { "krc", "\u0e04\u0e32\u0e23\u0e32\u0e44\u0e0a-\u0e1a\u0e31\u0e25\u0e04\u0e32\u0e23\u0e4c" },
            { "kri", "\u0e04\u0e23\u0e34\u0e42\u0e2d" },
            { "krj", "\u0e01\u0e34\u0e19\u0e32\u0e23\u0e32\u0e22\u0e2d\u0e32" },
            { "krl", "\u0e04\u0e32\u0e23\u0e35\u0e40\u0e25\u0e35\u0e22\u0e19" },
            { "kru", "\u0e01\u0e38\u0e23\u0e38\u0e02" },
            { "ksb", "\u0e0a\u0e31\u0e21\u0e1a\u0e32\u0e25\u0e32" },
            { "ksf", "\u0e1a\u0e32\u0e40\u0e1f\u0e35\u0e22" },
            { "ksh", "\u0e42\u0e04\u0e42\u0e25\u0e0d" },
            { "kum", "\u0e04\u0e39\u0e21\u0e37\u0e22\u0e04\u0e4c" },
            { "kut", "\u0e04\u0e39\u0e40\u0e17\u0e44\u0e19" },
            { "kwk", "\u0e04\u0e27\u0e31\u0e01\u0e27\u0e32\u0e25\u0e32" },
            { "kxv", "\u0e01\u0e39\u0e27\u0e35" },
            { "lad", "\u0e25\u0e32\u0e14\u0e34\u0e42\u0e19" },
            { "lag", "\u0e41\u0e25\u0e19\u0e08\u0e35" },
            { "lah", "\u0e25\u0e32\u0e2e\u0e4c\u0e19\u0e14\u0e32" },
            { "lam", "\u0e41\u0e25\u0e21\u0e1a\u0e32" },
            { "lez", "\u0e40\u0e25\u0e0b\u0e40\u0e01\u0e35\u0e22" },
            { "lfn", "\u0e25\u0e34\u0e07\u0e01\u0e31\u0e27\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e32\u0e42\u0e19\u0e27\u0e32" },
            { "lij", "\u0e25\u0e34\u0e01\u0e39\u0e40\u0e23\u0e35\u0e22" },
            { "lil", "\u0e25\u0e34\u0e25\u0e25\u0e39\u0e40\u0e2d\u0e15" },
            { "liv", "\u0e25\u0e34\u0e42\u0e27\u0e40\u0e19\u0e35\u0e22" },
            { "lkt", "\u0e25\u0e32\u0e42\u0e01\u0e15\u0e32" },
            { "lmo", "\u0e25\u0e2d\u0e21\u0e1a\u0e32\u0e23\u0e4c\u0e14" },
            { "lol", "\u0e21\u0e2d\u0e07\u0e42\u0e01" },
            { "lou", "\u0e04\u0e23\u0e35\u0e42\u0e2d\u0e25\u0e38\u0e22\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e32" },
            { "loz", "\u0e42\u0e25\u0e0b\u0e34" },
            { "lrc", "\u0e25\u0e39\u0e23\u0e35\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "lsm", "\u0e0b\u0e32\u0e40\u0e21\u0e35\u0e22" },
            { "ltg", "\u0e25\u0e31\u0e15\u0e40\u0e01\u0e25" },
            { "lua", "\u0e25\u0e39\u0e1a\u0e32-\u0e25\u0e39\u0e25\u0e31\u0e27" },
            { "lui", "\u0e25\u0e38\u0e22\u0e40\u0e0b\u0e42\u0e19" },
            { "lun", "\u0e25\u0e31\u0e19\u0e14\u0e32" },
            { "luo", "\u0e25\u0e31\u0e27" },
            { "lus", "\u0e21\u0e34\u0e42\u0e0b" },
            { "luy", "\u0e25\u0e39\u0e40\u0e22\u0e35\u0e22" },
            { "lzh", "\u0e08\u0e35\u0e19\u0e04\u0e25\u0e32\u0e2a\u0e2a\u0e34\u0e01" },
            { "lzz", "\u0e41\u0e25\u0e0b" },
            { "mad", "\u0e21\u0e32\u0e14\u0e39\u0e23\u0e32" },
            { "maf", "\u0e21\u0e32\u0e1f\u0e32" },
            { "mag", "\u0e21\u0e04\u0e2b\u0e35" },
            { "mai", "\u0e44\u0e21\u0e16\u0e34\u0e25\u0e35" },
            { "mak", "\u0e21\u0e32\u0e01\u0e32\u0e0b\u0e32\u0e23\u0e4c" },
            { "man", "\u0e21\u0e31\u0e19\u0e14\u0e34\u0e07\u0e01\u0e32" },
            { "mas", "\u0e21\u0e32\u0e44\u0e0b" },
            { "mde", "\u0e21\u0e32\u0e1a\u0e32" },
            { "mdf", "\u0e21\u0e2d\u0e04\u0e0a\u0e32" },
            { "mdr", "\u0e21\u0e32\u0e19\u0e14\u0e32\u0e23\u0e4c" },
            { "men", metaValue_men },
            { "mer", "\u0e40\u0e21\u0e23\u0e39" },
            { "mfe", "\u0e21\u0e2d\u0e23\u0e34\u0e2a\u0e40\u0e22\u0e19" },
            { "mga", "\u0e44\u0e2d\u0e23\u0e34\u0e0a\u0e01\u0e25\u0e32\u0e07" },
            { "mgh", "\u0e21\u0e32\u0e01\u0e31\u0e27\u0e27\u0e32-\u0e21\u0e35\u0e17\u0e42\u0e17" },
            { "mgo", "\u0e40\u0e21\u0e15\u0e32" },
            { "mic", "\u0e21\u0e34\u0e01\u0e41\u0e21\u0e01" },
            { "min", "\u0e21\u0e35\u0e19\u0e31\u0e07\u0e01\u0e32\u0e40\u0e1a\u0e32" },
            { "mnc", "\u0e41\u0e21\u0e19\u0e08\u0e39" },
            { "mni", "\u0e21\u0e13\u0e35\u0e1b\u0e38\u0e23\u0e30" },
            { "moe", "\u0e2d\u0e34\u0e19\u0e19\u0e38-\u0e44\u0e2d\u0e21\u0e38\u0e19" },
            { "moh", "\u0e42\u0e21\u0e2e\u0e2d\u0e27\u0e4c\u0e01" },
            { "mos", "\u0e42\u0e21\u0e0b\u0e35" },
            { "mrj", "\u0e21\u0e32\u0e23\u0e35\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "mua", "\u0e21\u0e31\u0e19\u0e14\u0e31\u0e07" },
            { "mul", "\u0e2b\u0e25\u0e32\u0e22\u0e20\u0e32\u0e29\u0e32" },
            { "mus", "\u0e21\u0e31\u0e2a\u0e04\u0e35\u0e01\u0e35" },
            { "mwl", "\u0e21\u0e35\u0e23\u0e31\u0e19\u0e14\u0e32" },
            { "mwr", "\u0e21\u0e32\u0e23\u0e27\u0e32\u0e11\u0e35" },
            { "mwv", "\u0e40\u0e21\u0e47\u0e19\u0e15\u0e32\u0e44\u0e27" },
            { "mye", "\u0e21\u0e22\u0e35\u0e19" },
            { "myv", "\u0e40\u0e2d\u0e35\u0e22\u0e23\u0e4c\u0e0b\u0e22\u0e32" },
            { "mzn", "\u0e21\u0e32\u0e0b\u0e31\u0e19\u0e14\u0e32\u0e23\u0e32\u0e19\u0e35" },
            { "nan", "\u0e08\u0e35\u0e19\u0e21\u0e34\u0e19\u0e2b\u0e19\u0e32\u0e19" },
            { "nap", "\u0e19\u0e32\u0e42\u0e1b\u0e25\u0e35" },
            { "naq", "\u0e19\u0e32\u0e21\u0e32" },
            { "nds", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e15\u0e48\u0e33" },
            { "new", "\u0e40\u0e19\u0e27\u0e32\u0e23\u0e4c" },
            { "nia", "\u0e19\u0e35\u0e2d\u0e31\u0e2a" },
            { "niu", "\u0e19\u0e35\u0e27\u0e40\u0e27" },
            { "njo", "\u0e2d\u0e4b\u0e32\u0e27\u0e19\u0e32\u0e01\u0e32" },
            { "nmg", "\u0e01\u0e27\u0e32\u0e0b\u0e34\u0e42\u0e2d" },
            { "nnh", "\u0e08\u0e35\u0e21\u0e1a\u0e39\u0e19" },
            { "nog", "\u0e42\u0e19\u0e44\u0e01" },
            { "non", "\u0e19\u0e2d\u0e23\u0e4c\u0e2a\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "nov", "\u0e42\u0e19\u0e40\u0e27\u0e35\u0e22\u0e25" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0e42\u0e0b\u0e42\u0e17\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "nus", "\u0e40\u0e19\u0e37\u0e2d\u0e23\u0e4c" },
            { "nwc", "\u0e40\u0e19\u0e27\u0e32\u0e23\u0e4c\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "nym", "\u0e40\u0e19\u0e35\u0e22\u0e21\u0e40\u0e27\u0e0b\u0e35" },
            { "nyn", "\u0e40\u0e19\u0e35\u0e22\u0e19\u0e42\u0e01\u0e40\u0e25" },
            { "nyo", "\u0e19\u0e34\u0e42\u0e2d\u0e42\u0e23" },
            { "nzi", "\u0e19\u0e0b\u0e34\u0e21\u0e32" },
            { "ojb", "\u0e42\u0e2d\u0e08\u0e34\u0e1a\u0e40\u0e27\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01\u0e40\u0e09\u0e35\u0e22\u0e07\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "ojc", "\u0e42\u0e2d\u0e08\u0e34\u0e1a\u0e40\u0e27\u0e15\u0e2d\u0e19\u0e01\u0e25\u0e32\u0e07" },
            { "ojs", "\u0e2d\u0e2d\u0e08\u0e34-\u0e04\u0e23\u0e35" },
            { "ojw", "\u0e42\u0e2d\u0e08\u0e34\u0e1a\u0e40\u0e27\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "oka", "\u0e42\u0e2d\u0e04\u0e32\u0e19\u0e32\u0e01\u0e31\u0e19" },
            { "osa", "\u0e42\u0e2d\u0e0b\u0e32\u0e01\u0e35" },
            { "ota", "\u0e15\u0e38\u0e23\u0e01\u0e35\u0e2d\u0e2d\u0e15\u0e42\u0e15\u0e21\u0e31\u0e19" },
            { "pag", "\u0e1b\u0e31\u0e07\u0e01\u0e32\u0e0b\u0e35\u0e19\u0e31\u0e19" },
            { "pal", "\u0e1b\u0e30\u0e2b\u0e4c\u0e25\u0e32\u0e27\u0e35" },
            { "pam", "\u0e1b\u0e31\u0e21\u0e1b\u0e31\u0e07\u0e01\u0e32" },
            { "pap", "\u0e1b\u0e32\u0e40\u0e1b\u0e35\u0e22\u0e40\u0e21\u0e19\u0e42\u0e15" },
            { "pau", metaValue_PW },
            { "pcd", "\u0e1b\u0e34\u0e01\u0e32\u0e23\u0e4c" },
            { "pcm", "\u0e44\u0e19\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22\u0e19\u0e1e\u0e34\u0e14\u0e08\u0e34\u0e19" },
            { "pdc", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e40\u0e1e\u0e19\u0e0b\u0e34\u0e25\u0e40\u0e27\u0e40\u0e19\u0e35\u0e22" },
            { "pdt", "\u0e40\u0e1e\u0e25\u0e32\u0e17\u0e4c\u0e14\u0e34\u0e0a" },
            { "peo", metaValue_peo },
            { "pfl", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e1e\u0e32\u0e25\u0e32\u0e17\u0e34\u0e40\u0e19\u0e15" },
            { "phn", metaValue_phn },
            { "pis", "\u0e1e\u0e34\u0e14\u0e08\u0e34\u0e19" },
            { "pms", "\u0e1e\u0e35\u0e14\u0e21\u0e2d\u0e19\u0e15\u0e4c" },
            { "pnt", "\u0e1e\u0e2d\u0e19\u0e15\u0e34\u0e01" },
            { "pon", "\u0e1e\u0e2d\u0e2b\u0e4c\u0e19\u0e40\u0e1e" },
            { "pqm", "\u0e21\u0e32\u0e40\u0e25\u0e44\u0e0b\u0e17\u0e4c-\u0e1b\u0e31\u0e2a\u0e21\u0e32\u0e42\u0e04\u0e27\u0e14\u0e35" },
            { "prg", "\u0e1b\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22" },
            { "pro", "\u0e42\u0e1b\u0e23\u0e27\u0e2d\u0e07\u0e0b\u0e32\u0e25\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "quc", "\u0e01\u0e35\u0e40\u0e0a" },
            { "qug", "\u0e04\u0e27\u0e34\u0e0a\u0e31\u0e27\u0e44\u0e2e\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e0a\u0e34\u0e21\u0e42\u0e1a\u0e23\u0e32\u0e42\u0e0b" },
            { "raj", "\u0e23\u0e32\u0e0a\u0e2a\u0e16\u0e32\u0e19" },
            { "rap", "\u0e23\u0e32\u0e1b\u0e32\u0e19\u0e39\u0e2d\u0e35" },
            { "rar", "\u0e23\u0e32\u0e42\u0e23\u0e17\u0e2d\u0e07\u0e01\u0e32" },
            { "rgn", "\u0e42\u0e23\u0e21\u0e31\u0e13\u0e42\u0e0d" },
            { "rhg", "\u0e42\u0e23\u0e2e\u0e34\u0e07\u0e0d\u0e32" },
            { "rif", "\u0e23\u0e34\u0e1f\u0e1f\u0e34\u0e2d\u0e31\u0e19" },
            { "rof", "\u0e23\u0e2d\u0e21\u0e42\u0e1a" },
            { "rom", "\u0e42\u0e23\u0e21\u0e32\u0e19\u0e35" },
            { "rtm", "\u0e42\u0e23\u0e17\u0e39\u0e21\u0e31\u0e19" },
            { "rue", "\u0e23\u0e39\u0e0b\u0e34\u0e19" },
            { "rug", "\u0e42\u0e23\u0e40\u0e27\u0e35\u0e22\u0e19\u0e32" },
            { "rup", "\u0e2d\u0e32\u0e42\u0e23\u0e21\u0e32\u0e40\u0e19\u0e35\u0e22" },
            { "rwk", "\u0e23\u0e27\u0e32" },
            { "sad", "\u0e0b\u0e31\u0e19\u0e14\u0e32\u0e40\u0e27" },
            { "sah", "\u0e0b\u0e32\u0e04\u0e32" },
            { "sam", "\u0e2d\u0e23\u0e32\u0e40\u0e21\u0e2d\u0e34\u0e01\u0e0b\u0e32\u0e21\u0e32\u0e40\u0e23\u0e35\u0e22" },
            { "saq", "\u0e41\u0e0b\u0e21\u0e1a\u0e39\u0e23\u0e39" },
            { "sas", "\u0e0b\u0e32\u0e0b\u0e31\u0e01" },
            { "sat", "\u0e2a\u0e31\u0e19\u0e15\u0e32\u0e25\u0e35" },
            { "saz", "\u0e40\u0e2a\u0e32\u0e23\u0e32\u0e29\u0e0f\u0e23\u0e4c" },
            { "sba", "\u0e01\u0e31\u0e21\u0e40\u0e1a" },
            { "sbp", "\u0e41\u0e0b\u0e07\u0e01\u0e39" },
            { "scn", "\u0e0b\u0e34\u0e0b\u0e34\u0e25\u0e35" },
            { "sco", "\u0e2a\u0e01\u0e2d\u0e15\u0e2a\u0e4c" },
            { "sdc", "\u0e0b\u0e32\u0e23\u0e4c\u0e14\u0e34\u0e40\u0e19\u0e35\u0e22\u0e0b\u0e32\u0e2a\u0e0b\u0e32\u0e23\u0e35" },
            { "sdh", "\u0e40\u0e04\u0e2d\u0e23\u0e4c\u0e14\u0e34\u0e0a\u0e43\u0e15\u0e49" },
            { "see", "\u0e40\u0e0b\u0e19\u0e34\u0e01\u0e32" },
            { "seh", "\u0e40\u0e0b\u0e19\u0e32" },
            { "sei", "\u0e40\u0e0b\u0e23\u0e35" },
            { "sel", "\u0e40\u0e0b\u0e25\u0e04\u0e38\u0e1b" },
            { "ses", "\u0e42\u0e04\u0e22\u0e4c\u0e23\u0e32\u0e42\u0e1a\u0e42\u0e23\u0e40\u0e0b\u0e19\u0e19\u0e35" },
            { "sga", "\u0e44\u0e2d\u0e23\u0e34\u0e0a\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "sgs", "\u0e0b\u0e32\u0e42\u0e21\u0e08\u0e34\u0e40\u0e15\u0e35\u0e22\u0e19" },
            { "shi", "\u0e17\u0e32\u0e40\u0e0a\u0e25\u0e35\u0e2b\u0e4c\u0e17" },
            { "shn", "\u0e44\u0e17\u0e43\u0e2b\u0e0d\u0e48" },
            { "shu", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a-\u0e0a\u0e32\u0e14" },
            { "sid", "\u0e0b\u0e34\u0e14\u0e32\u0e42\u0e21" },
            { "slh", "\u0e25\u0e39\u0e0a\u0e39\u0e15\u0e0b\u0e35\u0e14\u0e43\u0e15\u0e49" },
            { "sli", "\u0e44\u0e0b\u0e25\u0e35\u0e40\u0e0b\u0e35\u0e22\u0e15\u0e2d\u0e19\u0e25\u0e48\u0e32\u0e07" },
            { "sly", "\u0e40\u0e0b\u0e25\u0e32\u0e22\u0e32\u0e23\u0e4c" },
            { "sma", "\u0e0b\u0e32\u0e21\u0e34\u0e43\u0e15\u0e49" },
            { "smj", "\u0e0b\u0e32\u0e21\u0e34\u0e25\u0e39\u0e40\u0e25" },
            { "smn", "\u0e0b\u0e32\u0e21\u0e34\u0e2d\u0e35\u0e19\u0e32\u0e23\u0e35" },
            { "sms", "\u0e0b\u0e32\u0e21\u0e34\u0e2a\u0e04\u0e2d\u0e25\u0e15\u0e4c" },
            { "snk", "\u0e42\u0e0b\u0e19\u0e35\u0e19\u0e40\u0e01" },
            { "sog", "\u0e0b\u0e2d\u0e01\u0e14\u0e35\u0e19" },
            { "srn", "\u0e2a\u0e23\u0e32\u0e19\u0e32\u0e19\u0e15\u0e2d\u0e07\u0e42\u0e01" },
            { "srr", "\u0e40\u0e0b\u0e41\u0e23\u0e23\u0e4c" },
            { "ssy", metaValue_ssy },
            { "stq", "\u0e1f\u0e23\u0e35\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e0b\u0e31\u0e17\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "str", "\u0e2a\u0e40\u0e15\u0e23\u0e15\u0e2a\u0e4c\u0e0b\u0e32\u0e25\u0e34\u0e0a" },
            { "suk", "\u0e0b\u0e39\u0e04\u0e39\u0e21\u0e32" },
            { "sus", "\u0e0b\u0e39\u0e0b\u0e39" },
            { "sux", "\u0e0b\u0e39\u0e40\u0e21\u0e2d" },
            { "swb", "\u0e42\u0e04\u0e40\u0e21\u0e2d\u0e40\u0e23\u0e35\u0e22" },
            { "syc", "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22\u0e41\u0e1a\u0e1a\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "syr", metaValue_SY },
            { "szl", "\u0e44\u0e0b\u0e25\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "tce", "\u0e17\u0e31\u0e0a\u0e42\u0e0a\u0e19\u0e43\u0e15\u0e49" },
            { "tcy", "\u0e15\u0e39\u0e25\u0e39" },
            { "tem", "\u0e17\u0e34\u0e21\u0e40\u0e19" },
            { "teo", "\u0e40\u0e15\u0e42\u0e0b" },
            { "ter", "\u0e40\u0e17\u0e40\u0e23\u0e42\u0e19" },
            { "tet", "\u0e40\u0e15\u0e15\u0e38\u0e21" },
            { "tgx", "\u0e17\u0e32\u0e01\u0e34\u0e0a" },
            { "tht", "\u0e17\u0e32\u0e25\u0e17\u0e32\u0e19" },
            { "tig", "\u0e15\u0e35\u0e40\u0e01\u0e23" },
            { "tiv", "\u0e17\u0e34\u0e1f" },
            { "tkl", metaValue_TK },
            { "tkr", "\u0e41\u0e0b\u0e04\u0e40\u0e0b\u0e2d\u0e23\u0e4c" },
            { "tlh", "\u0e04\u0e25\u0e34\u0e07\u0e07\u0e2d\u0e19" },
            { "tli", "\u0e17\u0e25\u0e34\u0e07\u0e01\u0e34\u0e15" },
            { "tly", "\u0e17\u0e32\u0e25\u0e34\u0e0a" },
            { "tmh", "\u0e17\u0e32\u0e21\u0e32\u0e40\u0e0a\u0e01" },
            { "tog", "\u0e44\u0e19\u0e2d\u0e30\u0e0b\u0e32\u0e15\u0e2d\u0e07\u0e01\u0e32" },
            { "tok", "\u0e42\u0e17\u0e04\u0e34\u0e42\u0e1e\u0e19\u0e32" },
            { "tpi", "\u0e17\u0e47\u0e2d\u0e01\u0e1e\u0e34\u0e0b\u0e34\u0e19" },
            { "tru", "\u0e15\u0e39\u0e42\u0e23\u0e42\u0e22" },
            { "trv", "\u0e17\u0e32\u0e42\u0e23\u0e42\u0e01" },
            { "tsd", "\u0e0b\u0e32\u0e42\u0e04\u0e40\u0e19\u0e35\u0e22" },
            { "tsi", "\u0e0b\u0e34\u0e21\u0e0a\u0e35\u0e41\u0e2d\u0e19" },
            { "ttm", "\u0e17\u0e31\u0e0a\u0e42\u0e0a\u0e19\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "ttt", "\u0e15\u0e31\u0e15\u0e21\u0e38\u0e2a\u0e25\u0e34\u0e21" },
            { "tum", "\u0e17\u0e38\u0e21\u0e1a\u0e39\u0e01\u0e32" },
            { "tvl", metaValue_TV },
            { "twq", "\u0e15\u0e31\u0e2a\u0e0b\u0e32\u0e27\u0e31\u0e04" },
            { "tyv", "\u0e15\u0e39\u0e27\u0e32" },
            { "tzm", "\u0e17\u0e32\u0e21\u0e32\u0e44\u0e0b\u0e15\u0e4c\u0e41\u0e2d\u0e15\u0e25\u0e32\u0e2a\u0e01\u0e25\u0e32\u0e07" },
            { "udm", "\u0e2d\u0e38\u0e14\u0e21\u0e39\u0e23\u0e4c\u0e15" },
            { "uga", metaValue_uga },
            { "umb", "\u0e2d\u0e38\u0e21\u0e1a\u0e38\u0e19\u0e14\u0e39" },
            { "und", "\u0e20\u0e32\u0e29\u0e32\u0e17\u0e35\u0e48\u0e44\u0e21\u0e48\u0e23\u0e39\u0e49\u0e08\u0e31\u0e01" },
            { "vai", metaValue_vai },
            { "vec", "\u0e40\u0e27\u0e40\u0e19\u0e42\u0e15\u0e49" },
            { "vep", "\u0e40\u0e27\u0e1b\u0e2a\u0e4c" },
            { "vls", "\u0e40\u0e1f\u0e25\u0e21\u0e34\u0e0a\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "vmf", "\u0e40\u0e21\u0e19-\u0e1f\u0e23\u0e32\u0e19\u0e42\u0e01\u0e40\u0e19\u0e35\u0e22" },
            { "vmw", "\u0e21\u0e32\u0e01\u0e31\u0e27\u0e27\u0e32" },
            { "vot", "\u0e42\u0e27\u0e17\u0e34\u0e01" },
            { "vro", "\u0e42\u0e27\u0e42\u0e23" },
            { "vun", "\u0e27\u0e38\u0e19\u0e08\u0e39" },
            { "wae", "\u0e27\u0e31\u0e25\u0e40\u0e0b\u0e2d\u0e23\u0e4c" },
            { "wal", "\u0e42\u0e27\u0e41\u0e25\u0e15\u0e15\u0e32" },
            { "war", "\u0e27\u0e32\u0e40\u0e23\u0e22\u0e4c" },
            { "was", "\u0e27\u0e32\u0e42\u0e0a" },
            { "wbp", "\u0e27\u0e2d\u0e25\u0e4c\u0e40\u0e1e\u0e2d\u0e23\u0e4c\u0e23\u0e35" },
            { "wuu", "\u0e08\u0e35\u0e19\u0e2d\u0e39\u0e4b" },
            { "xal", "\u0e04\u0e31\u0e25\u0e21\u0e37\u0e22\u0e04\u0e4c" },
            { "xmf", "\u0e40\u0e21\u0e40\u0e01\u0e23\u0e40\u0e25\u0e35\u0e22" },
            { "xnr", "\u0e01\u0e31\u0e07\u0e01\u0e23\u0e35" },
            { "xog", "\u0e42\u0e0b\u0e01\u0e32" },
            { "yao", "\u0e40\u0e22\u0e49\u0e32" },
            { "yap", "\u0e22\u0e31\u0e1b" },
            { "yav", "\u0e41\u0e22\u0e07\u0e40\u0e1a\u0e19" },
            { "ybb", "\u0e40\u0e22\u0e21\u0e1a\u0e32" },
            { "yrl", "\u0e40\u0e2b\u0e07\u0e07\u0e01\u0e32\u0e15\u0e38" },
            { "yue", "\u0e01\u0e27\u0e32\u0e07\u0e15\u0e38\u0e49\u0e07" },
            { "zap", "\u0e0b\u0e32\u0e42\u0e1b\u0e40\u0e15\u0e01" },
            { "zbl", metaValue_zbl },
            { "zea", "\u0e40\u0e0b\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "zen", "\u0e40\u0e0b\u0e19\u0e32\u0e01\u0e32" },
            { "zgh", "\u0e17\u0e32\u0e21\u0e32\u0e44\u0e0b\u0e15\u0e4c\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19" },
            { "zun", "\u0e0b\u0e39\u0e19\u0e34" },
            { "zxx", "\u0e44\u0e21\u0e48\u0e21\u0e35\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e20\u0e32\u0e29\u0e32" },
            { "zza", "\u0e0b\u0e32\u0e0b\u0e32" },
            { "Adlm", "\u0e2d\u0e31\u0e14\u0e25\u0e31\u0e21" },
            { "Afak", "\u0e2d\u0e30\u0e1f\u0e32\u0e04\u0e32" },
            { "Aghb", "\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22 \u0e04\u0e2d\u0e40\u0e04\u0e40\u0e0b\u0e35\u0e22" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0e19\u0e32\u0e2a\u0e15\u0e32\u0e25\u0e34\u0e01" },
            { "Armi", "\u0e2d\u0e34\u0e21\u0e1e\u0e35\u0e40\u0e23\u0e35\u0e22\u0e25 \u0e2d\u0e23\u0e32\u0e40\u0e21\u0e2d\u0e34\u0e01" },
            { "Armn", metaValue_AM },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", "\u0e1a\u0e32\u0e21\u0e38\u0e21" },
            { "Bass", "\u0e1a\u0e31\u0e2a\u0e0b\u0e32" },
            { "Batk", "\u0e1a\u0e32\u0e15\u0e31\u0e01" },
            { "Beng", "\u0e40\u0e1a\u0e07\u0e01\u0e32\u0e25\u0e35" },
            { "Blis", metaValue_zbl },
            { "Bopo", "\u0e1b\u0e2d\u0e1e\u0e2d\u0e21\u0e2d\u0e1f\u0e2d" },
            { "Brah", "\u0e1e\u0e23\u0e32\u0e2b\u0e21\u0e35" },
            { "Brai", "\u0e40\u0e1a\u0e23\u0e25\u0e25\u0e4c" },
            { "Bugi", metaValue_bug },
            { "Buhd", "\u0e1a\u0e39\u0e2e\u0e34\u0e14" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e1e\u0e22\u0e32\u0e07\u0e04\u0e4c\u0e02\u0e2d\u0e07\u0e0a\u0e32\u0e27\u0e2d\u0e30\u0e1a\u0e2d\u0e23\u0e34\u0e08\u0e34\u0e19\u0e43\u0e19\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32" },
            { "Cari", "\u0e04\u0e32\u0e40\u0e23\u0e35\u0e22" },
            { "Cham", "\u0e08\u0e32\u0e21" },
            { "Cher", metaValue_chr },
            { "Cirt", "\u0e40\u0e0b\u0e34\u0e23\u0e4c\u0e17" },
            { "Copt", metaValue_cop },
            { "Cprt", "\u0e44\u0e0b\u0e40\u0e1b\u0e23\u0e35\u0e22\u0e17" },
            { "Cyrl", "\u0e0b\u0e35\u0e23\u0e34\u0e25\u0e25\u0e34\u0e01" },
            { "Cyrs", "\u0e40\u0e0a\u0e2d\u0e23\u0e4c\u0e0a\u0e2a\u0e25\u0e32\u0e42\u0e27\u0e19\u0e34\u0e01\u0e0b\u0e35\u0e23\u0e34\u0e25\u0e25\u0e34\u0e01\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "Deva", "\u0e40\u0e17\u0e27\u0e19\u0e32\u0e04\u0e23\u0e35" },
            { "Dsrt", "\u0e40\u0e14\u0e40\u0e0b\u0e40\u0e23\u0e17" },
            { "Dupl", "\u0e0a\u0e27\u0e40\u0e25\u0e02\u0e14\u0e31\u0e1b\u0e42\u0e25\u0e22\u0e31\u0e19" },
            { "Egyd", "\u0e14\u0e35\u0e42\u0e21\u0e15\u0e34\u0e01\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "Egyh", "\u0e40\u0e2e\u0e35\u0e22\u0e23\u0e32\u0e15\u0e34\u0e01\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "Egyp", "\u0e40\u0e2e\u0e35\u0e22\u0e42\u0e23\u0e01\u0e25\u0e34\u0e1f\u0e2a\u0e4c\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "Elba", "\u0e40\u0e2d\u0e25\u0e1a\u0e4c\u0e0b\u0e32\u0e19" },
            { "Ethi", "\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e1b\u0e34\u0e01" },
            { "Geok", "\u0e04\u0e31\u0e15\u0e0b\u0e39\u0e23\u0e35\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22" },
            { "Geor", metaValue_GE },
            { "Glag", "\u0e01\u0e25\u0e32\u0e42\u0e01\u0e25\u0e34\u0e15\u0e34\u0e01" },
            { "Goth", metaValue_got },
            { "Gran", "\u0e04\u0e24\u0e13\u0e2b\u0e4c" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0e01\u0e39\u0e23\u0e4c\u0e21\u0e39\u0e04\u0e35" },
            { "Hanb", "\u0e08\u0e35\u0e19\u0e01\u0e25\u0e32\u0e07" },
            { "Hang", "\u0e2e\u0e31\u0e19\u0e01\u0e36\u0e25" },
            { "Hani", "\u0e2e\u0e31\u0e48\u0e19" },
            { "Hano", "\u0e2e\u0e32\u0e19\u0e39\u0e42\u0e19\u0e42\u0e2d" },
            { "Hans", metaValue_Hans },
            { "Hant", metaValue_Hant },
            { "Hebr", "\u0e2e\u0e35\u0e1a\u0e23\u0e39" },
            { "Hira", "\u0e2e\u0e34\u0e23\u0e30\u0e07\u0e30\u0e19\u0e30" },
            { "Hluw", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e30\u0e2d\u0e32\u0e19\u0e32\u0e42\u0e15\u0e40\u0e25\u0e35\u0e22" },
            { "Hmng", "\u0e1b\u0e32\u0e40\u0e2e\u0e32\u0e2b\u0e4c\u0e21\u0e49\u0e07" },
            { "Hrkt", "\u0e04\u0e30\u0e15\u0e30\u0e01\u0e30\u0e19\u0e30\u0e2b\u0e23\u0e37\u0e2d\u0e2e\u0e34\u0e23\u0e30\u0e07\u0e30\u0e19\u0e30" },
            { "Hung", "\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "Inds", "\u0e2d\u0e34\u0e19\u0e14\u0e31\u0e2a" },
            { "Ital", "\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "Jamo", "\u0e08\u0e32\u0e42\u0e21" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_JP },
            { "Jurc", "\u0e08\u0e39\u0e23\u0e4c\u0e40\u0e0a\u0e19" },
            { "Kali", "\u0e04\u0e22\u0e32\u0e2b\u0e4c" },
            { "Kana", "\u0e04\u0e30\u0e15\u0e30\u0e01\u0e30\u0e19\u0e30" },
            { "Khar", "\u0e02\u0e42\u0e23\u0e29\u0e10\u0e35" },
            { "Khmr", metaValue_km },
            { "Khoj", "\u0e04\u0e2d\u0e08\u0e04\u0e35" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", "\u0e40\u0e1b\u0e25\u0e40\u0e25" },
            { "Kthi", "\u0e01\u0e32\u0e22\u0e15\u0e34" },
            { "Lana", "\u0e25\u0e49\u0e32\u0e19\u0e19\u0e32" },
            { "Laoo", metaValue_LA },
            { "Latf", "\u0e25\u0e32\u0e15\u0e34\u0e19 - \u0e1f\u0e23\u0e31\u0e07\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "Latg", "\u0e25\u0e32\u0e15\u0e34\u0e19 - \u0e41\u0e01\u0e25\u0e34\u0e01" },
            { "Latn", metaValue_la },
            { "Lepc", "\u0e40\u0e25\u0e1b\u0e0a\u0e32" },
            { "Limb", "\u0e25\u0e34\u0e21\u0e1a\u0e39" },
            { "Lina", "\u0e25\u0e35\u0e40\u0e19\u0e35\u0e22\u0e23\u0e4c\u0e40\u0e2d" },
            { "Linb", "\u0e25\u0e35\u0e40\u0e19\u0e35\u0e22\u0e23\u0e4c\u0e1a\u0e35" },
            { "Lisu", "\u0e40\u0e1f\u0e23\u0e40\u0e0b\u0e2d\u0e23\u0e4c" },
            { "Loma", "\u0e42\u0e25\u0e21\u0e32" },
            { "Lyci", "\u0e44\u0e25\u0e40\u0e0b\u0e35\u0e22" },
            { "Lydi", "\u0e25\u0e35\u0e40\u0e14\u0e35\u0e22" },
            { "Mahj", "\u0e21\u0e2b\u0e32\u0e0a\u0e19\u0e35" },
            { "Mand", "\u0e41\u0e21\u0e19\u0e40\u0e14\u0e35\u0e22\u0e19" },
            { "Mani", "\u0e21\u0e32\u0e19\u0e34\u0e41\u0e0a\u0e19" },
            { "Maya", "\u0e21\u0e32\u0e22\u0e32\u0e44\u0e2e\u0e42\u0e23\u0e01\u0e25\u0e34\u0e1f\u0e2a\u0e4c" },
            { "Mend", metaValue_men },
            { "Merc", "\u0e40\u0e04\u0e2d\u0e23\u0e4c\u0e0b\u0e35\u0e1f-\u0e40\u0e21\u0e42\u0e23\u0e2d\u0e34\u0e15\u0e34\u0e01" },
            { "Mero", "\u0e40\u0e21\u0e42\u0e23\u0e15\u0e34\u0e01" },
            { "Mlym", metaValue_ml },
            { "Modi", "\u0e42\u0e21\u0e11\u0e35" },
            { "Mong", metaValue_MN },
            { "Moon", "\u0e21\u0e39\u0e19" },
            { "Mroo", "\u0e21\u0e42\u0e23" },
            { "Mtei", "\u0e40\u0e21\u0e40\u0e17\u0e21\u0e32\u0e40\u0e22\u0e01" },
            { "Mymr", metaValue_my },
            { "Narb", "\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22\u0e40\u0e2b\u0e19\u0e37\u0e2d\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "Nbat", "\u0e19\u0e32\u0e1a\u0e32\u0e17\u0e32\u0e40\u0e2d\u0e35\u0e22\u0e19" },
            { "Nkgb", "\u0e01\u0e35\u0e1a\u0e32-\u0e19\u0e32\u0e0b\u0e35" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "\u0e19\u0e38\u0e0b\u0e38" },
            { "Ogam", "\u0e42\u0e2d\u0e04\u0e31\u0e21" },
            { "Olck", "\u0e42\u0e2d\u0e25\u0e0a\u0e34\u0e01\u0e34" },
            { "Orkh", "\u0e2d\u0e2d\u0e23\u0e4c\u0e04\u0e2d\u0e19" },
            { "Orya", "\u0e42\u0e2d\u0e23\u0e34\u0e22\u0e32" },
            { "Osma", "\u0e2d\u0e2d\u0e2a\u0e21\u0e31\u0e19\u0e22\u0e32" },
            { "Palm", "\u0e1e\u0e32\u0e25\u0e44\u0e21\u0e23\u0e35\u0e19" },
            { "Pauc", "\u0e1b\u0e48\u0e2d\u0e08\u0e34\u0e49\u0e07\u0e2e\u0e2d" },
            { "Perm", "\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e21\u0e34\u0e01\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "Phag", "\u0e1f\u0e32\u0e01\u0e2a\u0e4c-\u0e1b\u0e32" },
            { "Phli", "\u0e1b\u0e30\u0e2b\u0e4c\u0e25\u0e32\u0e27\u0e35\u0e2d\u0e34\u0e19\u0e2a\u0e04\u0e23\u0e34\u0e1b\u0e0a\u0e31\u0e19\u0e41\u0e19\u0e25" },
            { "Phlp", "\u0e1b\u0e30\u0e2b\u0e4c\u0e25\u0e32\u0e27\u0e35\u0e0b\u0e2d\u0e25\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "Phlv", "\u0e1b\u0e30\u0e2b\u0e4c\u0e25\u0e32\u0e27\u0e35\u0e1a\u0e38\u0e4a\u0e01" },
            { "Phnx", metaValue_phn },
            { "Plrd", "\u0e2a\u0e31\u0e17\u0e28\u0e32\u0e2a\u0e15\u0e23\u0e4c\u0e1e\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e14" },
            { "Prti", "\u0e1e\u0e32\u0e23\u0e4c\u0e40\u0e17\u0e35\u0e22\u0e2d\u0e34\u0e19\u0e2a\u0e04\u0e23\u0e34\u0e1b\u0e0a\u0e31\u0e19\u0e41\u0e19\u0e25" },
            { "Rjng", "\u0e40\u0e23\u0e08\u0e31\u0e07" },
            { "Rohg", "\u0e2e\u0e30\u0e19\u0e35\u0e1f\u0e35" },
            { "Roro", "\u0e23\u0e2d\u0e07\u0e42\u0e01\u0e23\u0e2d\u0e07\u0e42\u0e01" },
            { "Runr", "\u0e23\u0e39\u0e19\u0e34\u0e01" },
            { "Samr", "\u0e0b\u0e32\u0e21\u0e32\u0e40\u0e23\u0e35\u0e22" },
            { "Sara", "\u0e0b\u0e32\u0e23\u0e32\u0e15\u0e34" },
            { "Sarb", "\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22\u0e43\u0e15\u0e49\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "Saur", "\u0e42\u0e2a\u0e27\u0e23\u0e31\u0e2a\u0e15\u0e23\u0e30" },
            { "Sgnw", "\u0e44\u0e0b\u0e19\u0e4c\u0e44\u0e23\u0e15\u0e34\u0e49\u0e07" },
            { "Shaw", "\u0e0b\u0e2d\u0e40\u0e27\u0e35\u0e22\u0e19" },
            { "Shrd", "\u0e0a\u0e32\u0e23\u0e32\u0e14\u0e32" },
            { "Sidd", "\u0e2a\u0e34\u0e17\u0e18\u0e31\u0e21" },
            { "Sind", "\u0e04\u0e38\u0e14\u0e32\u0e27\u0e32\u0e14\u0e35" },
            { "Sinh", metaValue_si },
            { "Sora", "\u0e42\u0e2a\u0e23\u0e32\u0e2a\u0e21\u0e40\u0e1b\u0e47\u0e07" },
            { "Sund", metaValue_su },
            { "Sylo", "\u0e0b\u0e34\u0e42\u0e25\u0e15\u0e34\u0e19\u0e32\u0e01\u0e23\u0e35" },
            { "Syrc", metaValue_SY },
            { "Syre", "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22\u0e40\u0e2d\u0e2a\u0e17\u0e23\u0e32\u0e19\u0e08\u0e35\u0e42\u0e25" },
            { "Syrj", "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "Syrn", "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "Tagb", "\u0e15\u0e31\u0e01\u0e1a\u0e31\u0e19\u0e27\u0e32" },
            { "Takr", "\u0e17\u0e32\u0e04\u0e23\u0e35" },
            { "Tale", "\u0e44\u0e17\u0e40\u0e25" },
            { "Talu", "\u0e44\u0e17\u0e25\u0e37\u0e49\u0e2d\u0e43\u0e2b\u0e21\u0e48" },
            { "Taml", metaValue_ta },
            { "Tang", "\u0e15\u0e31\u0e19\u0e01\u0e31\u0e17" },
            { "Tavt", "\u0e44\u0e17\u0e40\u0e27\u0e35\u0e22\u0e15" },
            { "Telu", metaValue_te },
            { "Teng", "\u0e40\u0e17\u0e07\u0e01\u0e27\u0e32\u0e23\u0e4c" },
            { "Tfng", "\u0e17\u0e34\u0e1f\u0e34\u0e19\u0e32\u0e01" },
            { "Tglg", metaValue_tl },
            { "Thaa", "\u0e17\u0e32\u0e19\u0e32" },
            { "Thai", metaValue_TH },
            { "Tibt", metaValue_bo },
            { "Tirh", "\u0e40\u0e17\u0e2d\u0e2e\u0e38\u0e17\u0e32" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "\u0e04\u0e33\u0e1e\u0e39\u0e14\u0e17\u0e35\u0e48\u0e21\u0e2d\u0e07\u0e40\u0e2b\u0e47\u0e19\u0e44\u0e14\u0e49" },
            { "Wara", "\u0e27\u0e32\u0e23\u0e31\u0e07\u0e01\u0e2a\u0e34\u0e15\u0e34" },
            { "Wole", "\u0e42\u0e2d\u0e25\u0e35\u0e40\u0e2d" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e23\u0e39\u0e1b\u0e25\u0e34\u0e48\u0e21\u0e2a\u0e38\u0e40\u0e21\u0e40\u0e23\u0e35\u0e22-\u0e2d\u0e31\u0e04\u0e04\u0e32\u0e40\u0e14\u0e35\u0e22" },
            { "Yiii", "\u0e22\u0e34" },
            { "Zinh", "\u0e2d\u0e34\u0e19\u0e40\u0e2e\u0e2d\u0e23\u0e34\u0e15" },
            { "Zmth", "\u0e40\u0e04\u0e23\u0e37\u0e48\u0e2d\u0e07\u0e2b\u0e21\u0e32\u0e22\u0e17\u0e32\u0e07\u0e04\u0e13\u0e34\u0e15\u0e28\u0e32\u0e2a\u0e15\u0e23\u0e4c" },
            { "Zsye", "\u0e2d\u0e35\u0e42\u0e21\u0e08\u0e34" },
            { "Zsym", "\u0e2a\u0e31\u0e0d\u0e25\u0e31\u0e01\u0e29\u0e13\u0e4c" },
            { "Zxxx", "\u0e44\u0e21\u0e48\u0e21\u0e35\u0e20\u0e32\u0e29\u0e32\u0e40\u0e02\u0e35\u0e22\u0e19" },
            { "Zyyy", "\u0e2a\u0e32\u0e21\u0e31\u0e0d" },
            { "Zzzz", "\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e17\u0e35\u0e48\u0e44\u0e21\u0e48\u0e23\u0e39\u0e49\u0e08\u0e31\u0e01" },
            { "de_AT", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19 - \u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e35\u0e22" },
            { "de_CH", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2a\u0e39\u0e07 (\u0e2a\u0e27\u0e34\u0e2a)" },
            { "en_AU", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 - \u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22" },
            { "en_CA", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 - \u0e41\u0e04\u0e19\u0e32\u0e14\u0e32" },
            { "en_GB", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 - \u0e2a\u0e2b\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23" },
            { "en_US", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 - \u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "es_ES", "\u0e2a\u0e40\u0e1b\u0e19 - \u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "es_MX", "\u0e2a\u0e40\u0e1b\u0e19 - \u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01" },
            { "fa_AF", "\u0e14\u0e32\u0e23\u0e35" },
            { "fr_CA", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a - \u0e41\u0e04\u0e19\u0e32\u0e14\u0e32" },
            { "fr_CH", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a - \u0e2a\u0e27\u0e34\u0e2a" },
            { "nl_BE", "\u0e40\u0e1f\u0e25\u0e21\u0e34\u0e0a" },
            { "pt_BR", "\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a - \u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25" },
            { "pt_PT", "\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a - \u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "ro_MD", metaValue_MD },
            { "sw_CD", "\u0e2a\u0e27\u0e32\u0e2e\u0e35\u0e25\u0e35 - \u0e04\u0e2d\u0e07\u0e42\u0e01" },
            { "%%1901", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2d\u0e2d\u0e23\u0e4c\u0e42\u0e18\u0e01\u0e23\u0e32\u0e1f\u0e35\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "%%1994", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e30\u0e40\u0e23\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e21\u0e32\u0e15\u0e23\u0e32\u0e10\u0e32\u0e19" },
            { "%%1996", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2d\u0e2d\u0e23\u0e4c\u0e42\u0e18\u0e01\u0e23\u0e32\u0e1f\u0e35\u0e1b\u0e35 1996" },
            { "ar_001", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e2a\u0e21\u0e31\u0e22\u0e43\u0e2b\u0e21\u0e48" },
            { "es_419", "\u0e2a\u0e40\u0e1b\u0e19 - \u0e25\u0e30\u0e15\u0e34\u0e19\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "key.ca", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19" },
            { "key.cf", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19" },
            { "key.co", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07" },
            { "key.cu", "\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19" },
            { "key.hc", "\u0e27\u0e07\u0e08\u0e23\u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (\u0e40\u0e17\u0e35\u0e22\u0e1a 12 \u0e41\u0e25\u0e30 24)" },
            { "key.lb", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e02\u0e36\u0e49\u0e19\u0e1a\u0e23\u0e23\u0e17\u0e31\u0e14\u0e43\u0e2b\u0e21\u0e48" },
            { "key.ms", "\u0e23\u0e30\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e27\u0e31\u0e14" },
            { "key.nu", metaValue_key_nu },
            { "key.tz", "\u0e40\u0e02\u0e15\u0e40\u0e27\u0e25\u0e32" },
            { "key.va", "\u0e15\u0e31\u0e27\u0e41\u0e1b\u0e23\u0e20\u0e32\u0e29\u0e32\u0e16\u0e34\u0e48\u0e19" },
            { "nds_NL", "\u0e41\u0e0b\u0e01\u0e0b\u0e2d\u0e19\u0e43\u0e15\u0e49" },
            { "%%ALUKU", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e2d\u0e25\u0e39\u0e04\u0e39" },
            { "%%BISKE", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e0b\u0e32\u0e19\u0e08\u0e2d\u0e23\u0e4c\u0e42\u0e08/\u0e1a\u0e34\u0e25\u0e32" },
            { "%%BOONT", "\u0e1a\u0e39\u0e19\u0e17\u0e25\u0e34\u0e48\u0e07" },
            { "%%JAUER", "\u0e40\u0e22\u0e32\u0e40\u0e2d\u0e2d\u0e23\u0e4c" },
            { "%%KKCOR", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e27\u0e34\u0e18\u0e35\u0e2a\u0e32\u0e21\u0e31\u0e0d" },
            { "%%KSCOR", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e27\u0e34\u0e18\u0e35\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19" },
            { "%%LIPAW", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e25\u0e34\u0e42\u0e1e\u0e27\u0e32\u0e0b\u0e02\u0e2d\u0e07\u0e40\u0e23\u0e40\u0e0b\u0e35\u0e22\u0e19" },
            { "%%NEDIS", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e19\u0e32\u0e17\u0e34\u0e42\u0e0b\u0e40\u0e19" },
            { "%%NJIVA", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e08\u0e19\u0e35\u0e27\u0e32/\u0e19\u0e08\u0e35\u0e27\u0e32" },
            { "%%NULIK", "\u0e42\u0e27\u0e25\u0e32\u0e1e\u0e36\u0e04\u0e2a\u0e21\u0e31\u0e22\u0e43\u0e2b\u0e21\u0e48" },
            { "%%OSOJS", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e42\u0e2d\u0e40\u0e0b\u0e35\u0e22\u0e04\u0e42\u0e04/\u0e42\u0e2d\u0e42\u0e0b\u0e22\u0e32\u0e40\u0e19" },
            { "%%POSIX", "\u0e04\u0e2d\u0e21\u0e1e\u0e34\u0e27\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "%%PUTER", "\u0e1e\u0e34\u0e27\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "%%RIGIK", "\u0e42\u0e27\u0e25\u0e32\u0e1e\u0e36\u0e04\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "%%ROZAJ", "\u0e40\u0e23\u0e40\u0e0b\u0e35\u0e22\u0e19" },
            { "%%RUMGR", "\u0e23\u0e31\u0e21\u0e01\u0e23\u0e4c" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e2a\u0e42\u0e15\u0e27\u0e35\u0e0b\u0e0b\u0e32/\u0e42\u0e0b\u0e25\u0e1a\u0e35\u0e01\u0e32" },
            { "%%UCCOR", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e27\u0e34\u0e18\u0e35\u0e41\u0e1a\u0e1a\u0e04\u0e23\u0e1a\u0e27\u0e07\u0e08\u0e23" },
            { "zh_Hans", "\u0e08\u0e35\u0e19\u0e15\u0e31\u0e27\u0e22\u0e48\u0e2d" },
            { "zh_Hant", "\u0e08\u0e35\u0e19\u0e15\u0e31\u0e27\u0e40\u0e15\u0e47\u0e21" },
            { "%%DAJNKO", "\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e14\u0e32\u0e22\u0e19\u0e0a\u0e34\u0e0b\u0e32" },
            { "%%FONIPA", "\u0e2a\u0e31\u0e17\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e2a\u0e32\u0e01\u0e25" },
            { "%%FONUPA", "\u0e2a\u0e31\u0e17\u0e2d\u0e31\u0e01\u0e29\u0e23 UPA" },
            { "%%NDYUKA", "\u0e14\u0e34\u0e27\u0e04\u0e32" },
            { "%%PAMAKA", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e1e\u0e32\u0e21\u0e32\u0e04\u0e32" },
            { "%%PINYIN", "\u0e1e\u0e34\u0e19\u0e2d\u0e34\u0e19" },
            { "%%SCOUSE", "\u0e2a\u0e40\u0e01\u0e32\u0e2a\u0e4c" },
            { "%%TARASK", "\u0e17\u0e32\u0e23\u0e32\u0e0b\u0e40\u0e04\u0e35\u0e22\u0e27\u0e34\u0e0b\u0e32\u0e2d\u0e2d\u0e23\u0e4c\u0e42\u0e18\u0e01\u0e23\u0e32\u0e1f\u0e35" },
            { "%%UCRCOR", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e27\u0e34\u0e18\u0e35\u0e41\u0e1a\u0e1a\u0e1b\u0e23\u0e31\u0e1a\u0e1b\u0e23\u0e38\u0e07\u0e04\u0e23\u0e1a\u0e27\u0e07\u0e08\u0e23" },
            { "%%ULSTER", "\u0e2d\u0e31\u0e25\u0e2a\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "%%ALALC97", "\u0e01\u0e32\u0e23\u0e16\u0e2d\u0e14\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e40\u0e1b\u0e47\u0e19\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e42\u0e23\u0e21\u0e31\u0e19\u0e15\u0e32\u0e21\u0e40\u0e01\u0e13\u0e11\u0e4c\u0e02\u0e2d\u0e07\u0e2a\u0e21\u0e32\u0e04\u0e21\u0e2b\u0e49\u0e2d\u0e07\u0e2a\u0e21\u0e38\u0e14\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19\u0e41\u0e25\u0e30\u0e2b\u0e49\u0e2d\u0e07\u0e2a\u0e21\u0e38\u0e14\u0e23\u0e31\u0e10\u0e2a\u0e20\u0e32 \u0e09\u0e1a\u0e31\u0e1a\u0e1e\u0e34\u0e21\u0e1e\u0e4c\u0e1b\u0e35 1997" },
            { "%%AREVELA", "\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "%%AREVMDA", "\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "%%BAUDDHA", "\u0e1e\u0e23\u0e30\u0e1e\u0e38\u0e17\u0e18\u0e40\u0e08\u0e49\u0e32" },
            { "%%BOHORIC", "\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e42\u0e1a\u0e42\u0e2e\u0e23\u0e34\u0e0a" },
            { "%%EMODENG", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e2a\u0e21\u0e31\u0e22\u0e43\u0e2b\u0e21\u0e48\u0e15\u0e2d\u0e19\u0e15\u0e49\u0e19" },
            { "%%HEPBURN", "\u0e01\u0e32\u0e23\u0e16\u0e2d\u0e14\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e41\u0e1a\u0e1a\u0e40\u0e2e\u0e1b\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e19" },
            { "%%ITIHASA", "\u0e2d\u0e34\u0e15\u0e34\u0e2b\u0e32\u0e2a\u0e30" },
            { "%%LAUKIKA", "\u0e25\u0e31\u0e27\u0e01\u0e34\u0e01\u0e32" },
            { "%%METELKO", "\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e40\u0e21\u0e40\u0e15\u0e27\u0e0a\u0e34\u0e0b\u0e32" },
            { "%%MONOTON", "\u0e42\u0e21\u0e42\u0e19\u0e42\u0e17\u0e19\u0e34\u0e01" },
            { "%%POLYTON", "\u0e42\u0e1e\u0e25\u0e35\u0e42\u0e17\u0e19\u0e34\u0e01" },
            { "%%REVISED", "\u0e2d\u0e2d\u0e23\u0e4c\u0e42\u0e18\u0e01\u0e23\u0e32\u0e1f\u0e34\u0e1b\u0e23\u0e31\u0e1a\u0e1b\u0e23\u0e38\u0e07" },
            { "%%SURSILV", "\u0e0b\u0e39\u0e23\u0e4c\u0e0b\u0e35\u0e25\u0e1f\u0e4c" },
            { "%%SUTSILV", "\u0e0b\u0e38\u0e15\u0e0b\u0e35\u0e25\u0e1f\u0e4c" },
            { "%%VAIDIKA", "\u0e40\u0e27\u0e14\u0e34\u0e04\u0e32" },
            { "%%1606NICT", "\u0e1b\u0e25\u0e32\u0e22\u0e22\u0e38\u0e04\u0e01\u0e25\u0e32\u0e07\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a\u0e16\u0e36\u0e07\u0e1b\u0e35 \u0e04.\u0e28. 1606" },
            { "%%1694ACAD", "\u0e15\u0e2d\u0e19\u0e15\u0e49\u0e19\u0e22\u0e38\u0e04\u0e43\u0e2b\u0e21\u0e48\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a" },
            { "%%1959ACAD", "\u0e27\u0e34\u0e0a\u0e32\u0e01\u0e32\u0e23" },
            { "%%BAKU1926", "\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e25\u0e30\u0e15\u0e34\u0e19\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e01\u0e34\u0e01\u0e41\u0e1a\u0e1a\u0e04\u0e23\u0e1a\u0e27\u0e07\u0e08\u0e23" },
            { "%%BISCAYAN", "\u0e1a\u0e34\u0e2a\u0e04\u0e32\u0e22\u0e31\u0e19" },
            { "%%FONXSAMP", "\u0e1f\u0e2d\u0e19\u0e0b\u0e4c\u0e41\u0e0b\u0e21\u0e1e\u0e4c" },
            { "%%HOGNORSK", "\u0e20\u0e32\u0e29\u0e32\u0e19\u0e2d\u0e23\u0e4c\u0e27\u0e34\u0e40\u0e08\u0e35\u0e22\u0e19\u0e2a\u0e39\u0e07" },
            { "%%JYUTPING", "\u0e23\u0e30\u0e1a\u0e1a\u0e16\u0e2d\u0e14\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e41\u0e1a\u0e1a\u0e22\u0e27\u0e36\u0e14\u0e1e\u0e34\u0e07" },
            { "%%LUNA1918", "\u0e25\u0e39\u0e19\u0e48\u0e32 1918" },
            { "%%PETR1708", "\u0e1e\u0e35\u0e17 1708" },
            { "%%SCOTLAND", "\u0e20\u0e32\u0e29\u0e32\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e21\u0e32\u0e15\u0e23\u0e32\u0e10\u0e32\u0e19\u0e2a\u0e01\u0e4a\u0e2d\u0e15" },
            { "%%SURMIRAN", "\u0e0b\u0e39\u0e23\u0e4c\u0e21\u0e34\u0e23\u0e32\u0e19" },
            { "%%VALENCIA", "\u0e27\u0e32\u0e40\u0e25\u0e19\u0e40\u0e0b\u0e35\u0e22" },
            { "%%VALLADER", "\u0e27\u0e31\u0e25\u0e25\u0e32\u0e40\u0e14\u0e2d\u0e23\u0e4c" },
            { "%%WADEGILE", "\u0e01\u0e32\u0e23\u0e16\u0e2d\u0e14\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e41\u0e1a\u0e1a\u0e40\u0e27\u0e14-\u0e44\u0e08\u0e25\u0e2a\u0e4c" },
            { "type.ca.roc", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e44\u0e15\u0e49\u0e2b\u0e27\u0e31\u0e19" },
            { "type.co.eor", "\u0e01\u0e0e\u0e01\u0e32\u0e23\u0e40\u0e23\u0e35\u0e22\u0e07\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e15\u0e32\u0e21\u0e41\u0e1a\u0e1a\u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "type.hc.h11", "\u0e23\u0e30\u0e1a\u0e1a 12 \u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (0\u201311)" },
            { "type.hc.h12", "\u0e23\u0e30\u0e1a\u0e1a 12 \u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (1\u201312)" },
            { "type.hc.h23", "\u0e23\u0e30\u0e1a\u0e1a 24 \u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (0\u201323)" },
            { "type.hc.h24", "\u0e23\u0e30\u0e1a\u0e1a 24 \u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (1\u201324)" },
            { "type.m0.bgn", "\u0e0a\u0e37\u0e48\u0e2d\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 (BGN)" },
            { "type.nu.arab", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e1a\u0e34\u0e01-\u0e2d\u0e34\u0e19\u0e14\u0e34\u0e01" },
            { "type.nu.armn", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22" },
            { "type.nu.bali", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1a\u0e32\u0e2b\u0e25\u0e35" },
            { "type.nu.beng", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1a\u0e31\u0e07\u0e01\u0e25\u0e32\u0e40\u0e17\u0e28" },
            { "type.nu.brah", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1e\u0e23\u0e32\u0e2b\u0e21\u0e35" },
            { "type.nu.cakm", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e08\u0e31\u0e01\u0e21\u0e48\u0e32" },
            { "type.nu.cham", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0a\u0e32\u0e21" },
            { "type.nu.deva", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e17\u0e27\u0e19\u0e32\u0e04\u0e23\u0e35" },
            { "type.nu.ethi", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22" },
            { "type.nu.geor", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22" },
            { "type.nu.grek", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e01\u0e23\u0e35\u0e01" },
            { "type.nu.gujr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e04\u0e38\u0e0a\u0e23\u0e32\u0e15" },
            { "type.nu.guru", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e01\u0e39\u0e23\u0e4c\u0e21\u0e39\u0e04\u0e35" },
            { "type.nu.hans", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e08\u0e35\u0e19\u0e15\u0e31\u0e27\u0e22\u0e48\u0e2d" },
            { "type.nu.hant", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e08\u0e35\u0e19\u0e15\u0e31\u0e27\u0e40\u0e15\u0e47\u0e21" },
            { "type.nu.hebr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2e\u0e34\u0e1a\u0e23\u0e39" },
            { "type.nu.java", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0a\u0e27\u0e32" },
            { "type.nu.jpan", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19" },
            { "type.nu.kali", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e04\u0e22\u0e32\u0e2b\u0e4c" },
            { "type.nu.khmr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e02\u0e21\u0e23" },
            { "type.nu.knda", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e01\u0e31\u0e19\u0e19\u0e32\u0e14\u0e32" },
            { "type.nu.lana", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e17\u0e17\u0e31\u0e21\u0e42\u0e2e\u0e23\u0e32" },
            { "type.nu.laoo", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e25\u0e32\u0e27" },
            { "type.nu.latn", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e1a\u0e34\u0e01" },
            { "type.nu.lepc", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e25\u0e1b\u0e0a\u0e32" },
            { "type.nu.limb", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e25\u0e34\u0e21\u0e1a\u0e39" },
            { "type.nu.mlym", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e21\u0e32\u0e25\u0e32\u0e22\u0e32\u0e25\u0e31\u0e21" },
            { "type.nu.mong", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22" },
            { "type.nu.mtei", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e21\u0e44\u0e15\u0e21\u0e32\u0e40\u0e22\u0e01" },
            { "type.nu.mymr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1e\u0e21\u0e48\u0e32" },
            { "type.nu.nkoo", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e2d\u0e47\u0e19\u0e42\u0e01" },
            { "type.nu.olck", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e2d\u0e25\u0e08\u0e34\u0e01\u0e34" },
            { "type.nu.orya", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e2d\u0e23\u0e34\u0e22\u0e32" },
            { "type.nu.osma", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e2d\u0e2a\u0e21\u0e31\u0e19\u0e22\u0e32" },
            { "type.nu.saur", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e28\u0e32\u0e23\u0e31\u0e0a\u0e18\u0e23\u0e32" },
            { "type.nu.shrd", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0a\u0e32\u0e23\u0e32\u0e14\u0e32" },
            { "type.nu.sora", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e2a\u0e23\u0e32\u0e2a\u0e21\u0e40\u0e1b\u0e47\u0e07" },
            { "type.nu.sund", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0b\u0e38\u0e19\u0e14\u0e32" },
            { "type.nu.takr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e04\u0e23\u0e35" },
            { "type.nu.talu", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e17\u0e25\u0e37\u0e49\u0e2d\u0e43\u0e2b\u0e21\u0e48" },
            { "type.nu.taml", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e21\u0e34\u0e2c\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "type.nu.telu", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e15\u0e25\u0e39\u0e01\u0e39" },
            { "type.nu.thai", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e17\u0e22" },
            { "type.nu.tibt", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e34\u0e40\u0e1a\u0e15" },
            { "type.nu.vaii", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e27" },
            { "type.ca.dangi", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35" },
            { "type.co.ducet", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21 Unicode \u0e40\u0e23\u0e34\u0e48\u0e21\u0e15\u0e49\u0e19" },
            { "type.lb.loose", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e17\u0e35\u0e48\u0e22\u0e37\u0e14\u0e2b\u0e22\u0e38\u0e48\u0e19\u0e02\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e02\u0e36\u0e49\u0e19\u0e1a\u0e23\u0e23\u0e17\u0e31\u0e14\u0e43\u0e2b\u0e21\u0e48" },
            { "type.nu.roman", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e23\u0e21\u0e31\u0e19" },
            { "type.ca.coptic", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e04\u0e2d\u0e1b\u0e15\u0e34\u0e01" },
            { "type.ca.hebrew", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2e\u0e34\u0e1a\u0e23\u0e39" },
            { "type.ca.indian", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e41\u0e2b\u0e48\u0e07\u0e0a\u0e32\u0e15\u0e34\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22" },
            { "type.co.compat", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e01\u0e48\u0e2d\u0e19\u0e2b\u0e19\u0e49\u0e32\u0e19\u0e35\u0e49 \u0e15\u0e32\u0e21\u0e04\u0e27\u0e32\u0e21\u0e40\u0e2b\u0e21\u0e32\u0e30\u0e2a\u0e21" },
            { "type.co.pinyin", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e01\u0e32\u0e23\u0e16\u0e2d\u0e14\u0e40\u0e2a\u0e35\u0e22\u0e07\u0e20\u0e32\u0e29\u0e32\u0e08\u0e35\u0e19" },
            { "type.co.search", "\u0e01\u0e32\u0e23\u0e04\u0e49\u0e19\u0e2b\u0e32\u0e17\u0e31\u0e48\u0e27\u0e44\u0e1b" },
            { "type.co.stroke", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e01\u0e32\u0e23\u0e25\u0e32\u0e01\u0e40\u0e2a\u0e49\u0e19" },
            { "type.co.unihan", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e08\u0e33\u0e19\u0e27\u0e19\u0e02\u0e35\u0e14" },
            { "type.co.zhuyin", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e01\u0e32\u0e23\u0e2a\u0e30\u0e01\u0e14\u0e41\u0e1a\u0e1a\u0e08\u0e39\u0e49\u0e2d\u0e34\u0e19" },
            { "type.d0.fwidth", metaValue_Hant },
            { "type.d0.hwidth", metaValue_Hans },
            { "type.lb.normal", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e1b\u0e01\u0e15\u0e34\u0e02\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e02\u0e36\u0e49\u0e19\u0e1a\u0e23\u0e23\u0e17\u0e31\u0e14\u0e43\u0e2b\u0e21\u0e48" },
            { "type.lb.strict", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e17\u0e35\u0e48\u0e40\u0e04\u0e23\u0e48\u0e07\u0e04\u0e23\u0e31\u0e14\u0e02\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e02\u0e36\u0e49\u0e19\u0e1a\u0e23\u0e23\u0e17\u0e31\u0e14\u0e43\u0e2b\u0e21\u0e48" },
            { "type.m0.ungegn", "\u0e0a\u0e37\u0e48\u0e2d\u0e20\u0e39\u0e21\u0e34\u0e28\u0e32\u0e2a\u0e15\u0e23\u0e4c\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19 UN (UNGEGN)" },
            { "type.ms.metric", "\u0e23\u0e30\u0e1a\u0e1a\u0e40\u0e21\u0e15\u0e23\u0e34\u0e01" },
            { "type.nu.native", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07" },
            { "type.ca.chinese", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e08\u0e35\u0e19" },
            { "type.ca.islamic", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2d\u0e34\u0e2a\u0e25\u0e32\u0e21" },
            { "type.ca.iso8601", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19 ISO-8601" },
            { "type.ca.persian", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e40\u0e0a\u0e35\u0e22" },
            { "type.cf.account", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19\u0e1a\u0e31\u0e0d\u0e0a\u0e35" },
            { "type.co.big5han", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e08\u0e35\u0e19\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "type.nu.arabext", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e1a\u0e34\u0e01-\u0e2d\u0e34\u0e19\u0e14\u0e34\u0e01\u0e41\u0e1a\u0e1a\u0e02\u0e22\u0e32\u0e22" },
            { "type.nu.armnlow", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22\u0e1e\u0e34\u0e21\u0e1e\u0e4c\u0e40\u0e25\u0e47\u0e01" },
            { "type.nu.finance", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e07\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19" },
            { "type.nu.greklow", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e01\u0e23\u0e35\u0e01\u0e1e\u0e34\u0e21\u0e1e\u0e4c\u0e40\u0e25\u0e47\u0e01" },
            { "type.nu.hanidec", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e28\u0e19\u0e34\u0e22\u0e21\u0e08\u0e35\u0e19" },
            { "type.nu.hansfin", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e07\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19\u0e41\u0e1a\u0e1a\u0e15\u0e31\u0e27\u0e22\u0e48\u0e2d\u0e02\u0e2d\u0e07\u0e08\u0e35\u0e19" },
            { "type.nu.hantfin", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e07\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19\u0e41\u0e1a\u0e1a\u0e15\u0e31\u0e27\u0e40\u0e15\u0e47\u0e21\u0e02\u0e2d\u0e07\u0e08\u0e35\u0e19" },
            { "type.nu.jpanfin", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e07\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19\u0e02\u0e2d\u0e07\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19" },
            { "type.nu.tamldec", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e21\u0e34\u0e2c" },
            { "type.ca.buddhist", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e1e\u0e38\u0e17\u0e18" },
            { "type.ca.ethiopic", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22" },
            { "type.ca.japanese", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19" },
            { "type.cf.standard", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19" },
            { "type.co.phonetic", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e01\u0e32\u0e23\u0e2d\u0e2d\u0e01\u0e40\u0e2a\u0e35\u0e22\u0e07" },
            { "type.co.searchjl", "\u0e04\u0e49\u0e19\u0e2b\u0e32\u0e15\u0e32\u0e21\u0e1e\u0e22\u0e31\u0e0d\u0e0a\u0e19\u0e30\u0e02\u0e36\u0e49\u0e19\u0e15\u0e49\u0e19\u0e17\u0e35\u0e48\u0e40\u0e1b\u0e47\u0e19\u0e2e\u0e31\u0e19\u0e01\u0e36\u0e25" },
            { "type.co.standard", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e41\u0e1a\u0e1a\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19" },
            { "type.ms.uksystem", "\u0e23\u0e30\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e27\u0e31\u0e14\u0e2d\u0e34\u0e21\u0e1e\u0e35\u0e40\u0e23\u0e35\u0e22\u0e25" },
            { "type.ms.ussystem", "\u0e23\u0e30\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e27\u0e31\u0e14\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19" },
            { "type.nu.fullwide", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e41\u0e1a\u0e1a\u0e40\u0e15\u0e47\u0e21\u0e02\u0e19\u0e32\u0e14" },
            { "type.nu.lanatham", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e17\u0e17\u0e31\u0e21\u0e17\u0e31\u0e21" },
            { "type.nu.mymrshan", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0a\u0e32\u0e19\u0e1e\u0e21\u0e48\u0e32" },
            { "type.nu.romanlow", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e23\u0e21\u0e31\u0e19\u0e1e\u0e34\u0e21\u0e1e\u0e4c\u0e40\u0e25\u0e47\u0e01" },
            { "type.ca.gregorian", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e40\u0e01\u0e23\u0e01\u0e2d\u0e40\u0e23\u0e35\u0e22\u0e19" },
            { "type.co.gb2312han", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e08\u0e35\u0e19\u0e1b\u0e23\u0e30\u0e22\u0e38\u0e01\u0e15\u0e4c" },
            { "type.co.phonebook", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e2a\u0e21\u0e38\u0e14\u0e42\u0e17\u0e23\u0e28\u0e31\u0e1e\u0e17\u0e4c" },
            { "type.co.dictionary", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e1e\u0e08\u0e19\u0e32\u0e19\u0e38\u0e01\u0e23\u0e21" },
            { "type.co.traditional", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e41\u0e1a\u0e1a\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "type.nu.traditional", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e41\u0e1a\u0e1a\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "type.ca.islamic-civil", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2d\u0e34\u0e2a\u0e25\u0e32\u0e21\u0e0b\u0e35\u0e27\u0e34\u0e25" },
            { "type.ca.islamic-umalqura", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2d\u0e34\u0e2a\u0e25\u0e32\u0e21 (\u0e2d\u0e38\u0e21\u0e21\u0e4c\u0e2d\u0e31\u0e25\u0e01\u0e38\u0e23\u0e32)" },
            { "type.ca.ethiopic-amete-alem", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e1b\u0e35\u0e42\u0e25\u0e01\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22" },
        };
        return data;
    }
}
