/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal.model;

/**
 * Details of Linux DEB package.
 */
public interface LinuxDebPackageMixin {

    /**
     * Gets the email of the maintainer of this DEB package.
     *
     * @return the email of the maintainer of this DEB package
     */
    String maintainerEmail();

    /**
     * Default implementation of {@link LinuxDebPackageMixin} interface.
     */
    record Stub(String maintainerEmail) implements LinuxDebPackageMixin {
    }
}
