/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jfr.events;

import jdk.jfr.Category;
import jdk.jfr.Contextual;
import jdk.jfr.Label;
import jdk.jfr.Name;
import jdk.jfr.StackTrace;

@Name("jdk.MethodTrace")
@Label("Method Trace")
@Category({ "Java Virtual Machine", "Method Tracing" })
@StackTrace(true)
public final class MethodTraceEvent extends AbstractJDKEvent {

    @Contextual
    @Label("Method")
    private long method;

    public static void commit(long start, long duration, long method) {
        // Generated by JFR
    }

    public static long timestamp() {
        // Generated by JFR
        return 0;
    }

    public static boolean shouldCommit(long duration) {
        // Generated by JFR
        return false;
    }
}
