/*
 * Copyright (c) 2022, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;

abstract class UnixDispatcher extends NativeDispatcher {

    @Override
    void close(FileDescriptor fd) throws IOException {
        close0(fd);
    }

    @Override
    void implPreClose(FileDescriptor fd, long reader, long writer) throws IOException {
        preClose0(fd);
        if (NativeThread.isNativeThread(reader))
            NativeThread.signal(reader);
        if (NativeThread.isNativeThread(writer))
            NativeThread.signal(writer);
    }

    private static native void close0(FileDescriptor fd) throws IOException;

    private static native void preClose0(FileDescriptor fd) throws IOException;

    static native void init();

    static {
        IOUtil.load();
        init();
    }
}
