/*
 * Copyright (c) 1998, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Provides classes and interfaces for handling text, dates, numbers,
 * and messages in a manner independent of natural languages.  This
 * means an application or library can be written to be
 * language-independent, and it can rely upon separate,
 * dynamically-linked localized resources. This allows the flexibility
 * of adding localizations for new localizations at any time.
 *
 * <p>These classes are capable of formatting dates, numbers, and
 * messages, parsing; searching and sorting strings; and iterating
 * over characters, words, sentences, and line breaks.  This package
 * contains three main groups of classes and interfaces:
 *
 * <ul>
 * <li>Classes for iteration over text
 * <li>Classes for formatting and parsing
 * <li>Classes for string collation
 * </ul>
 *
 * @since 1.1
 */
package java.text;
