/*
 * Copyright (c) 2006, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package java.lang;

abstract sealed class CharacterData
    permits CharacterData00, CharacterData01, CharacterData02, CharacterData03,
        CharacterData0E, CharacterDataLatin1, CharacterDataPrivateUse, CharacterDataUndefined {
    abstract int getProperties(int ch);
    abstract int getType(int ch);
    abstract boolean isDigit(int ch);
    abstract boolean isLowerCase(int ch);
    abstract boolean isUpperCase(int ch);
    abstract boolean isWhitespace(int ch);
    abstract boolean isMirrored(int ch);
    abstract boolean isJavaIdentifierStart(int ch);
    abstract boolean isJavaIdentifierPart(int ch);
    abstract boolean isUnicodeIdentifierStart(int ch);
    abstract boolean isUnicodeIdentifierPart(int ch);
    abstract boolean isIdentifierIgnorable(int ch);
    abstract boolean isEmoji(int ch);
    abstract boolean isEmojiPresentation(int ch);
    abstract boolean isEmojiModifier(int ch);
    abstract boolean isEmojiModifierBase(int ch);
    abstract boolean isEmojiComponent(int ch);
    abstract boolean isExtendedPictographic(int ch);
    abstract int toLowerCase(int ch);
    abstract int toUpperCase(int ch);
    abstract int toTitleCase(int ch);
    abstract int digit(int ch, int radix);
    abstract int getNumericValue(int ch);
    abstract byte getDirectionality(int ch);

    //need to implement for JSR204
    int toUpperCaseEx(int ch) {
        return toUpperCase(ch);
    }

    char[] toUpperCaseCharArray(int ch) {
        return null;
    }

    boolean isOtherAlphabetic(int ch) {
        return false;
    }

    boolean isIdeographic(int ch) {
        return false;
    }

    // Character <= 0xff (basic latin) is handled by internal fast-path
    // to avoid initializing large tables.
    // Note: performance of this "fast-path" code may be sub-optimal
    // in negative cases for some accessors due to complicated ranges.
    // Should revisit after optimization of table initialization.

    static final CharacterData of(int ch) {
        if (ch >>> 8 == 0) {     // fast-path
            return CharacterDataLatin1.instance;
        } else {
            return switch (ch >>> 16) {  //plane 00-16
                case 0 -> CharacterData00.instance;
                case 1 -> CharacterData01.instance;
                case 2 -> CharacterData02.instance;
                case 3 -> CharacterData03.instance;
                case 14 -> CharacterData0E.instance;
                case 15, 16 -> CharacterDataPrivateUse.instance; // Both cases Private Use
                default -> CharacterDataUndefined.instance;
            };
        }
    }
}
