# Copyright (c) 2018-2019 VMware, Inc.  All Rights Reserved.
# SPDX-License-Identifier: MIT

# DO NOT MODIFY. THIS CODE IS GENERATED. CHANGES WILL BE OVERWRITTEN.

# vcenter - VMware vCenter Server provides a centralized platform for managing your VMware vSphere environments


# Common files
require 'vsphere-automation-runtime/api_client'
require 'vsphere-automation-runtime/api_error'
require 'vsphere-automation-runtime/configuration'
require 'vsphere-automation-vcenter/version'

# Models
require 'vsphere-automation-vcenter/models/cis_task_progress'
require 'vsphere-automation-vcenter/models/cis_task_status'
require 'vsphere-automation-vcenter/models/vapi_std_dynamic_id'
require 'vsphere-automation-vcenter/models/vapi_std_errors_already_exists'
require 'vsphere-automation-vcenter/models/vapi_std_errors_already_exists_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_already_in_desired_state'
require 'vsphere-automation-vcenter/models/vapi_std_errors_already_in_desired_state_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_error_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_internal_server_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_internal_server_error_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_invalid_argument'
require 'vsphere-automation-vcenter/models/vapi_std_errors_invalid_argument_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_invalid_element_configuration'
require 'vsphere-automation-vcenter/models/vapi_std_errors_invalid_element_configuration_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_invalid_element_type'
require 'vsphere-automation-vcenter/models/vapi_std_errors_invalid_element_type_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_not_allowed_in_current_state'
require 'vsphere-automation-vcenter/models/vapi_std_errors_not_allowed_in_current_state_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_not_found'
require 'vsphere-automation-vcenter/models/vapi_std_errors_not_found_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_resource_busy'
require 'vsphere-automation-vcenter/models/vapi_std_errors_resource_busy_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_resource_in_use'
require 'vsphere-automation-vcenter/models/vapi_std_errors_resource_in_use_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_resource_inaccessible'
require 'vsphere-automation-vcenter/models/vapi_std_errors_resource_inaccessible_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_service_unavailable'
require 'vsphere-automation-vcenter/models/vapi_std_errors_service_unavailable_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_timed_out'
require 'vsphere-automation-vcenter/models/vapi_std_errors_timed_out_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unable_to_allocate_resource'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unable_to_allocate_resource_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unauthenticated'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unauthenticated_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unauthorized'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unauthorized_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unsupported'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unsupported_error'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unverified_peer'
require 'vsphere-automation-vcenter/models/vapi_std_errors_unverified_peer_error'
require 'vsphere-automation-vcenter/models/vapi_std_localizable_message'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_tls_csr_create'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_tls_csr_create_result'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_tls_csr_info'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_tls_csr_spec'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_tls_info'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_tls_renew'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_tls_result'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_tls_set'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_tls_spec'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_trusted_root_chains_create'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_trusted_root_chains_create_result'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_trusted_root_chains_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_trusted_root_chains_info'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_trusted_root_chains_list_result'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_trusted_root_chains_result'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_vcenter_trusted_root_chains_summary'
require 'vsphere-automation-vcenter/models/vcenter_certificate_management_x509_cert_chain'
require 'vsphere-automation-vcenter/models/vcenter_cluster_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_cluster_info'
require 'vsphere-automation-vcenter/models/vcenter_cluster_list_result'
require 'vsphere-automation-vcenter/models/vcenter_cluster_result'
require 'vsphere-automation-vcenter/models/vcenter_cluster_summary'
require 'vsphere-automation-vcenter/models/vcenter_datacenter_create'
require 'vsphere-automation-vcenter/models/vcenter_datacenter_create_result'
require 'vsphere-automation-vcenter/models/vcenter_datacenter_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_datacenter_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_datacenter_info'
require 'vsphere-automation-vcenter/models/vcenter_datacenter_list_result'
require 'vsphere-automation-vcenter/models/vcenter_datacenter_result'
require 'vsphere-automation-vcenter/models/vcenter_datacenter_summary'
require 'vsphere-automation-vcenter/models/vcenter_datastore_default_policy_result'
require 'vsphere-automation-vcenter/models/vcenter_datastore_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_datastore_info'
require 'vsphere-automation-vcenter/models/vcenter_datastore_list_result'
require 'vsphere-automation-vcenter/models/vcenter_datastore_result'
require 'vsphere-automation-vcenter/models/vcenter_datastore_summary'
require 'vsphere-automation-vcenter/models/vcenter_datastore_type'
require 'vsphere-automation-vcenter/models/vcenter_deployment_appliance_state'
require 'vsphere-automation-vcenter/models/vcenter_deployment_appliance_type'
require 'vsphere-automation-vcenter/models/vcenter_deployment_check_info'
require 'vsphere-automation-vcenter/models/vcenter_deployment_check_status'
require 'vsphere-automation-vcenter/models/vcenter_deployment_history_migration_option'
require 'vsphere-automation-vcenter/models/vcenter_deployment_history_migration_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_import_history_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_import_history_info'
require 'vsphere-automation-vcenter/models/vcenter_deployment_import_history_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_import_history_start'
require 'vsphere-automation-vcenter/models/vcenter_deployment_info'
require 'vsphere-automation-vcenter/models/vcenter_deployment_info_subtasks'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_check'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_check_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_initial_config_remote_psc_thumbprint_remote_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_initial_config_remote_psc_thumbprint_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_install_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_psc_replicated_check'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_psc_replicated_check_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_psc_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_psc_standalone_check'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_psc_standalone_check_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_remote_psc_check'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_remote_psc_check_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_start'
require 'vsphere-automation-vcenter/models/vcenter_deployment_install_vcsa_embedded_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_location_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_notification'
require 'vsphere-automation-vcenter/models/vcenter_deployment_notifications'
require 'vsphere-automation-vcenter/models/vcenter_deployment_question_answer'
require 'vsphere-automation-vcenter/models/vcenter_deployment_question_answer_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_question_info'
require 'vsphere-automation-vcenter/models/vcenter_deployment_question_question'
require 'vsphere-automation-vcenter/models/vcenter_deployment_question_question_type'
require 'vsphere-automation-vcenter/models/vcenter_deployment_question_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_remote_psc_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_replicated_psc_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_replicated_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_standalone_psc_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_standalone_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_task'
require 'vsphere-automation-vcenter/models/vcenter_deployment_upgrade_check'
require 'vsphere-automation-vcenter/models/vcenter_deployment_upgrade_check_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_upgrade_psc_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_upgrade_result'
require 'vsphere-automation-vcenter/models/vcenter_deployment_upgrade_source_appliance_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_upgrade_start'
require 'vsphere-automation-vcenter/models/vcenter_deployment_upgrade_upgrade_spec'
require 'vsphere-automation-vcenter/models/vcenter_deployment_upgrade_vcsa_embedded_spec'
require 'vsphere-automation-vcenter/models/vcenter_folder_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_folder_list_result'
require 'vsphere-automation-vcenter/models/vcenter_folder_summary'
require 'vsphere-automation-vcenter/models/vcenter_folder_type'
require 'vsphere-automation-vcenter/models/vcenter_guest_customization_specs_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_guest_customization_specs_list_result'
require 'vsphere-automation-vcenter/models/vcenter_guest_customization_specs_os_type'
require 'vsphere-automation-vcenter/models/vcenter_guest_customization_specs_summary'
require 'vsphere-automation-vcenter/models/vcenter_host_connection_state'
require 'vsphere-automation-vcenter/models/vcenter_host_create'
require 'vsphere-automation-vcenter/models/vcenter_host_create_result'
require 'vsphere-automation-vcenter/models/vcenter_host_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_host_create_spec_thumbprint_verification'
require 'vsphere-automation-vcenter/models/vcenter_host_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_host_list_result'
require 'vsphere-automation-vcenter/models/vcenter_host_power_state'
require 'vsphere-automation-vcenter/models/vcenter_host_summary'
require 'vsphere-automation-vcenter/models/vcenter_inventory_datastore_find'
require 'vsphere-automation-vcenter/models/vcenter_inventory_datastore_find_result'
require 'vsphere-automation-vcenter/models/vcenter_inventory_datastore_find_result_value'
require 'vsphere-automation-vcenter/models/vcenter_inventory_datastore_info'
require 'vsphere-automation-vcenter/models/vcenter_inventory_network_find'
require 'vsphere-automation-vcenter/models/vcenter_inventory_network_find_result'
require 'vsphere-automation-vcenter/models/vcenter_inventory_network_find_result_value'
require 'vsphere-automation-vcenter/models/vcenter_inventory_network_info'
require 'vsphere-automation-vcenter/models/vcenter_iso_image_mount'
require 'vsphere-automation-vcenter/models/vcenter_iso_image_mount_result'
require 'vsphere-automation-vcenter/models/vcenter_iso_image_unmount'
require 'vsphere-automation-vcenter/models/vcenter_network_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_network_list_result'
require 'vsphere-automation-vcenter/models/vcenter_network_summary'
require 'vsphere-automation-vcenter/models/vcenter_network_type'
require 'vsphere-automation-vcenter/models/vcenter_ovf_capability_capability_info'
require 'vsphere-automation-vcenter/models/vcenter_ovf_capability_result'
require 'vsphere-automation-vcenter/models/vcenter_ovf_disk_provisioning_type'
require 'vsphere-automation-vcenter/models/vcenter_ovf_export_flag_info'
require 'vsphere-automation-vcenter/models/vcenter_ovf_export_flag_list_result'
require 'vsphere-automation-vcenter/models/vcenter_ovf_import_flag_info'
require 'vsphere-automation-vcenter/models/vcenter_ovf_import_flag_list_result'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_create'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_create_result'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_create_target'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_deploy'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_deploy_result'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_deployable_identity'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_deployment_result'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_deployment_target'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_filter'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_filter_result'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_ovf_summary'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_resource_pool_deployment_spec'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_resource_pool_deployment_spec_network_mappings'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_resource_pool_deployment_spec_storage_mappings'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_result_info'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_storage_group_mapping'
require 'vsphere-automation-vcenter/models/vcenter_ovf_library_item_storage_group_mapping_type'
require 'vsphere-automation-vcenter/models/vcenter_ovf_ovf_error'
require 'vsphere-automation-vcenter/models/vcenter_ovf_ovf_info'
require 'vsphere-automation-vcenter/models/vcenter_ovf_ovf_message_category'
require 'vsphere-automation-vcenter/models/vcenter_ovf_ovf_warning'
require 'vsphere-automation-vcenter/models/vcenter_ovf_parse_issue'
require 'vsphere-automation-vcenter/models/vcenter_ovf_parse_issue_category'
require 'vsphere-automation-vcenter/models/vcenter_resource_pool_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_resource_pool_info'
require 'vsphere-automation-vcenter/models/vcenter_resource_pool_list_result'
require 'vsphere-automation-vcenter/models/vcenter_resource_pool_result'
require 'vsphere-automation-vcenter/models/vcenter_resource_pool_summary'
require 'vsphere-automation-vcenter/models/vcenter_services_service_health'
require 'vsphere-automation-vcenter/models/vcenter_services_service_info'
require 'vsphere-automation-vcenter/models/vcenter_services_service_list_details_result'
require 'vsphere-automation-vcenter/models/vcenter_services_service_list_details_result_value'
require 'vsphere-automation-vcenter/models/vcenter_services_service_result'
require 'vsphere-automation-vcenter/models/vcenter_services_service_startup_type'
require 'vsphere-automation-vcenter/models/vcenter_services_service_state'
require 'vsphere-automation-vcenter/models/vcenter_services_service_update'
require 'vsphere-automation-vcenter/models/vcenter_services_service_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_check_compatibility'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_check_compatibility_result'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compatibility_info'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compatible_datastore_info'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_list_result'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_status'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_summary'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_summary_disks'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_vm_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_vm_info'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_vm_info_disks'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_vm_list_result'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_vm_list_result_value'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_compliance_vm_status'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_list_result'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_summary'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_vm_info'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_vm_list_result'
require 'vsphere-automation-vcenter/models/vcenter_storage_policies_vm_list_result_value'
require 'vsphere-automation-vcenter/models/vcenter_system_config_deployment_type_convergence_spec'
require 'vsphere-automation-vcenter/models/vcenter_system_config_deployment_type_convert_to_vcsa_embedded_task'
require 'vsphere-automation-vcenter/models/vcenter_system_config_deployment_type_convert_to_vcsa_embedded_task_result'
require 'vsphere-automation-vcenter/models/vcenter_system_config_deployment_type_domain_info'
require 'vsphere-automation-vcenter/models/vcenter_system_config_deployment_type_info'
require 'vsphere-automation-vcenter/models/vcenter_system_config_deployment_type_psc_info'
require 'vsphere-automation-vcenter/models/vcenter_system_config_deployment_type_reconfigure'
require 'vsphere-automation-vcenter/models/vcenter_system_config_deployment_type_reconfigure_spec'
require 'vsphere-automation-vcenter/models/vcenter_system_config_deployment_type_result'
require 'vsphere-automation-vcenter/models/vcenter_system_config_psc_registration_info'
require 'vsphere-automation-vcenter/models/vcenter_system_config_psc_registration_repoint'
require 'vsphere-automation-vcenter/models/vcenter_system_config_psc_registration_result'
require 'vsphere-automation-vcenter/models/vcenter_topology_pscs_decommission_spec'
require 'vsphere-automation-vcenter/models/vcenter_topology_pscs_decommission_task'
require 'vsphere-automation-vcenter/models/vcenter_topology_pscs_decommission_task_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_filter_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_info_cdroms'
require 'vsphere-automation-vcenter/models/vcenter_vm_info_disks'
require 'vsphere-automation-vcenter/models/vcenter_vm_info_floppies'
require 'vsphere-automation-vcenter/models/vcenter_vm_info_nics'
require 'vsphere-automation-vcenter/models/vcenter_vm_info_parallel_ports'
require 'vsphere-automation-vcenter/models/vcenter_vm_info_sata_adapters'
require 'vsphere-automation-vcenter/models/vcenter_vm_info_scsi_adapters'
require 'vsphere-automation-vcenter/models/vcenter_vm_info_serial_ports'
require 'vsphere-automation-vcenter/models/vcenter_vm_list_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_placement_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_summary'
require 'vsphere-automation-vcenter/models/vcenter_vcha_capabilities_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_capabilities_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_active_get'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_active_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_active_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_active_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_cluster_mode'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_cluster_state'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_config_state'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_deploy_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_deploy_task'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_deploy_task_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_deployment_type_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_deployment_type_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_deployment_type_type'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_error_condition'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_failover_task'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_failover_task_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_get'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_ip_family'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_ip_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_ipv4_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_ipv6_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_mode_cluster_mode'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_mode_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_mode_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_mode_set_task'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_mode_set_task_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_node_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_node_role'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_node_runtime_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_node_state'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_node_vm_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_passive_check'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_passive_check_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_passive_check_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_passive_redeploy_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_passive_redeploy_task'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_passive_redeploy_task_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_passive_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_type'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_undeploy_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_undeploy_task'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_undeploy_task_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_vm_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_witness_check'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_witness_check_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_witness_check_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_witness_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_witness_redeploy_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_witness_redeploy_task'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_witness_redeploy_task_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_cluster_witness_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_connection_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_credentials_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_disk_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_disk_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_ip_family'
require 'vsphere-automation-vcenter/models/vcenter_vcha_ip_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_ipv4_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_ipv6_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_network_type'
require 'vsphere-automation-vcenter/models/vcenter_vcha_operations_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_operations_result'
require 'vsphere-automation-vcenter/models/vcenter_vcha_placement_info'
require 'vsphere-automation-vcenter/models/vcenter_vcha_placement_spec'
require 'vsphere-automation-vcenter/models/vcenter_vcha_vc_credentials_validate'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_identity_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_identity_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_local_filesystem_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_local_filesystem_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_local_filesystem_result_value'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_os'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_os_family'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_power_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_power_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_guest_power_state'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_sata_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_sata_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_sata_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_sata_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_sata_list_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_sata_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_sata_summary'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_sata_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_list_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_sharing'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_summary'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_adapter_scsi_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_device_entry'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_device_entry_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_device_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_device_set'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_device_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_network_protocol'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_boot_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_backing_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_backing_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_backing_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_device_access_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_host_bus_adapter_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_list_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_summary'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cdrom_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_connection_state'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cpu_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cpu_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cpu_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_cpu_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_backing_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_backing_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_backing_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_host_bus_adapter_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_list_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_storage_policy_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_summary'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_disk_vmdk_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_backing_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_backing_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_backing_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_emulation_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_list_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_mac_address_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_summary'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ethernet_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_backing_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_backing_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_backing_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_list_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_summary'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_floppy_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ide_address_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_ide_address_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_memory_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_memory_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_memory_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_memory_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_backing_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_backing_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_backing_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_list_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_summary'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_parallel_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_sata_address_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_sata_address_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_scsi_address_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_scsi_address_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_backing_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_backing_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_backing_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_list_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_summary'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_serial_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_upgrade'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_upgrade_policy'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_upgrade_status'
require 'vsphere-automation-vcenter/models/vcenter_vm_hardware_version'
require 'vsphere-automation-vcenter/models/vcenter_vm_power_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_power_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_power_state'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_compliance_check'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_compliance_check_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_compliance_check_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_compliance_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_compliance_info_disks'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_compliance_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_compliance_status'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_compliance_vm_compliance_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_disk_policy_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_disk_policy_spec_policy_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_update_spec_disks'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_vm_home_policy_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_storage_policy_vm_home_policy_spec_policy_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_cpu_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_cpu_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_placement_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_spec_disk_storage'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_spec_disk_storage_overrides'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_spec_disk_storage_policy'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_spec_disk_storage_policy_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_spec_vm_home_storage'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_spec_vm_home_storage_policy'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_create_spec_vm_home_storage_policy_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_placement_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_spec_disk_storage'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_spec_disk_storage_overrides'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_spec_disk_storage_policy'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_spec_disk_storage_policy_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_spec_vm_home_storage'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_spec_vm_home_storage_policy'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_deploy_spec_vm_home_storage_policy_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_disk_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_disk_storage_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_disk_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_ethernet_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_ethernet_info_mac_address_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_ethernet_info_network_backing_type'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_ethernet_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_guest_customization_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_hardware_customization_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_hardware_customization_spec_disks_to_update'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_hardware_customization_spec_nics'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_info_disks'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_info_nics'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_memory_info'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_memory_update_spec'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_result'
require 'vsphere-automation-vcenter/models/vcenter_vm_template_library_items_vm_home_storage_info'

# APIs
require 'vsphere-automation-vcenter/api/certificate_management_vcenter_tls_api'
require 'vsphere-automation-vcenter/api/certificate_management_vcenter_tls_csr_api'
require 'vsphere-automation-vcenter/api/certificate_management_vcenter_trusted_root_chains_api'
require 'vsphere-automation-vcenter/api/cluster_api'
require 'vsphere-automation-vcenter/api/datacenter_api'
require 'vsphere-automation-vcenter/api/datastore_api'
require 'vsphere-automation-vcenter/api/datastore_default_policy_api'
require 'vsphere-automation-vcenter/api/deployment_api'
require 'vsphere-automation-vcenter/api/deployment_import_history_api'
require 'vsphere-automation-vcenter/api/deployment_install_api'
require 'vsphere-automation-vcenter/api/deployment_install_initial_config_remote_psc_thumbprint_api'
require 'vsphere-automation-vcenter/api/deployment_install_psc_replicated_api'
require 'vsphere-automation-vcenter/api/deployment_install_psc_standalone_api'
require 'vsphere-automation-vcenter/api/deployment_install_remote_psc_api'
require 'vsphere-automation-vcenter/api/deployment_question_api'
require 'vsphere-automation-vcenter/api/deployment_upgrade_api'
require 'vsphere-automation-vcenter/api/folder_api'
require 'vsphere-automation-vcenter/api/guest_customization_specs_api'
require 'vsphere-automation-vcenter/api/host_api'
require 'vsphere-automation-vcenter/api/inventory_datastore_api'
require 'vsphere-automation-vcenter/api/inventory_network_api'
require 'vsphere-automation-vcenter/api/iso_image_api'
require 'vsphere-automation-vcenter/api/network_api'
require 'vsphere-automation-vcenter/api/ovf_capability_api'
require 'vsphere-automation-vcenter/api/ovf_export_flag_api'
require 'vsphere-automation-vcenter/api/ovf_import_flag_api'
require 'vsphere-automation-vcenter/api/ovf_library_item_api'
require 'vsphere-automation-vcenter/api/resource_pool_api'
require 'vsphere-automation-vcenter/api/services_service_api'
require 'vsphere-automation-vcenter/api/storage_policies_api'
require 'vsphere-automation-vcenter/api/storage_policies_compliance_api'
require 'vsphere-automation-vcenter/api/storage_policies_compliance_vm_api'
require 'vsphere-automation-vcenter/api/storage_policies_vm_api'
require 'vsphere-automation-vcenter/api/system_config_deployment_type_api'
require 'vsphere-automation-vcenter/api/system_config_psc_registration_api'
require 'vsphere-automation-vcenter/api/topology_pscs_api'
require 'vsphere-automation-vcenter/api/vm_api'
require 'vsphere-automation-vcenter/api/vcha_capabilities_api'
require 'vsphere-automation-vcenter/api/vcha_cluster_api'
require 'vsphere-automation-vcenter/api/vcha_cluster_active_api'
require 'vsphere-automation-vcenter/api/vcha_cluster_deployment_type_api'
require 'vsphere-automation-vcenter/api/vcha_cluster_mode_api'
require 'vsphere-automation-vcenter/api/vcha_cluster_passive_api'
require 'vsphere-automation-vcenter/api/vcha_cluster_witness_api'
require 'vsphere-automation-vcenter/api/vcha_operations_api'
require 'vsphere-automation-vcenter/api/vcha_vc_credentials_api'
require 'vsphere-automation-vcenter/api/vm_guest_identity_api'
require 'vsphere-automation-vcenter/api/vm_guest_local_filesystem_api'
require 'vsphere-automation-vcenter/api/vm_guest_power_api'
require 'vsphere-automation-vcenter/api/vm_hardware_api'
require 'vsphere-automation-vcenter/api/vm_hardware_adapter_sata_api'
require 'vsphere-automation-vcenter/api/vm_hardware_adapter_scsi_api'
require 'vsphere-automation-vcenter/api/vm_hardware_boot_api'
require 'vsphere-automation-vcenter/api/vm_hardware_boot_device_api'
require 'vsphere-automation-vcenter/api/vm_hardware_cdrom_api'
require 'vsphere-automation-vcenter/api/vm_hardware_cpu_api'
require 'vsphere-automation-vcenter/api/vm_hardware_disk_api'
require 'vsphere-automation-vcenter/api/vm_hardware_ethernet_api'
require 'vsphere-automation-vcenter/api/vm_hardware_floppy_api'
require 'vsphere-automation-vcenter/api/vm_hardware_memory_api'
require 'vsphere-automation-vcenter/api/vm_hardware_parallel_api'
require 'vsphere-automation-vcenter/api/vm_hardware_serial_api'
require 'vsphere-automation-vcenter/api/vm_power_api'
require 'vsphere-automation-vcenter/api/vm_storage_policy_api'
require 'vsphere-automation-vcenter/api/vm_storage_policy_compliance_api'
require 'vsphere-automation-vcenter/api/vm_template_library_items_api'

module VSphereAutomation
  class << self
    # Customize default settings for the SDK using block.
    #   VSphereAutomation.configure do |config|
    #     config.username = "xxx"
    #     config.password = "xxx"
    #   end
    # If no block given, return the default Configuration object.
    def configure
      if block_given?
        yield(Configuration.default)
      else
        Configuration.default
      end
    end
  end
end
