# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2021_01_01
  module Models
    #
    # The ImmutabilityPolicy property of a blob container, including Id,
    # resource name, resource type, Etag.
    #
    class ImmutabilityPolicy < AzureEntityResource

      include MsRestAzure

      # @return [Integer] The immutability period for the blobs in the
      # container since the policy creation, in days.
      attr_accessor :immutability_period_since_creation_in_days

      # @return [ImmutabilityPolicyState] The ImmutabilityPolicy state of a
      # blob container, possible values include: Locked and Unlocked. Possible
      # values include: 'Locked', 'Unlocked'
      attr_accessor :state

      # @return [Boolean] This property can only be changed for unlocked
      # time-based retention policies. When enabled, new blocks can be written
      # to an append blob while maintaining immutability protection and
      # compliance. Only new blocks can be added and any existing blocks cannot
      # be modified or deleted. This property cannot be changed with
      # ExtendImmutabilityPolicy API
      attr_accessor :allow_protected_append_writes


      #
      # Mapper for ImmutabilityPolicy class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'ImmutabilityPolicy',
          type: {
            name: 'Composite',
            class_name: 'ImmutabilityPolicy',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              },
              immutability_period_since_creation_in_days: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.immutabilityPeriodSinceCreationInDays',
                type: {
                  name: 'Number'
                }
              },
              state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.state',
                type: {
                  name: 'String'
                }
              },
              allow_protected_append_writes: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.allowProtectedAppendWrites',
                type: {
                  name: 'Boolean'
                }
              }
            }
          }
        }
      end
    end
  end
end
