# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2019_04_01
  module Models
    #
    # The LegalHold property of a blob container.
    #
    class LegalHold

      include MsRestAzure

      # @return [Boolean] The hasLegalHold public property is set to true by
      # SRP if there are at least one existing tag. The hasLegalHold public
      # property is set to false by SRP if all existing legal hold tags are
      # cleared out. There can be a maximum of 1000 blob containers with
      # hasLegalHold=true for a given account.
      attr_accessor :has_legal_hold

      # @return [Array<String>] Each tag should be 3 to 23 alphanumeric
      # characters and is normalized to lower case at SRP.
      attr_accessor :tags


      #
      # Mapper for LegalHold class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'LegalHold',
          type: {
            name: 'Composite',
            class_name: 'LegalHold',
            model_properties: {
              has_legal_hold: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'hasLegalHold',
                type: {
                  name: 'Boolean'
                }
              },
              tags: {
                client_side_validation: true,
                required: true,
                serialized_name: 'tags',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
