# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2019_04_01
  module Models
    #
    # Properties of the file share, including Id, resource name, resource type,
    # Etag.
    #
    class FileShare < AzureEntityResource

      include MsRestAzure

      # @return [DateTime] Returns the date and time the share was last
      # modified.
      attr_accessor :last_modified_time

      # @return [Hash{String => String}] A name-value pair to associate with
      # the share as metadata.
      attr_accessor :metadata

      # @return [Integer] The maximum size of the share, in gigabytes. Must be
      # greater than 0, and less than or equal to 5TB (5120).
      attr_accessor :share_quota


      #
      # Mapper for FileShare class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'FileShare',
          type: {
            name: 'Composite',
            class_name: 'FileShare',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              },
              last_modified_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.lastModifiedTime',
                type: {
                  name: 'DateTime'
                }
              },
              metadata: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.metadata',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              share_quota: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.shareQuota',
                constraints: {
                  InclusiveMaximum: 5120,
                  InclusiveMinimum: 1
                },
                type: {
                  name: 'Number'
                }
              }
            }
          }
        }
      end
    end
  end
end
