# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2019_04_01
  module Models
    #
    # Specifies a CORS rule for the Blob service.
    #
    class CorsRule

      include MsRestAzure

      # @return [Array<String>] Required if CorsRule element is present. A list
      # of origin domains that will be allowed via CORS, or "*" to allow all
      # domains
      attr_accessor :allowed_origins

      # @return [Array<Enum>] Required if CorsRule element is present. A list
      # of HTTP methods that are allowed to be executed by the origin.
      attr_accessor :allowed_methods

      # @return [Integer] Required if CorsRule element is present. The number
      # of seconds that the client/browser should cache a preflight response.
      attr_accessor :max_age_in_seconds

      # @return [Array<String>] Required if CorsRule element is present. A list
      # of response headers to expose to CORS clients.
      attr_accessor :exposed_headers

      # @return [Array<String>] Required if CorsRule element is present. A list
      # of headers allowed to be part of the cross-origin request.
      attr_accessor :allowed_headers


      #
      # Mapper for CorsRule class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'CorsRule',
          type: {
            name: 'Composite',
            class_name: 'CorsRule',
            model_properties: {
              allowed_origins: {
                client_side_validation: true,
                required: true,
                serialized_name: 'allowedOrigins',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              allowed_methods: {
                client_side_validation: true,
                required: true,
                serialized_name: 'allowedMethods',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'enumElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              max_age_in_seconds: {
                client_side_validation: true,
                required: true,
                serialized_name: 'maxAgeInSeconds',
                type: {
                  name: 'Number'
                }
              },
              exposed_headers: {
                client_side_validation: true,
                required: true,
                serialized_name: 'exposedHeaders',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              allowed_headers: {
                client_side_validation: true,
                required: true,
                serialized_name: 'allowedHeaders',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
