# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2018_07_01
  #
  # The Azure Storage Management API.
  #
  class BlobContainers
    include MsRestAzure

    #
    # Creates and initializes a new instance of the BlobContainers class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [StorageManagementClient] reference to the StorageManagementClient
    attr_reader :client

    #
    # Lists all containers and does not support a prefix like data plane. Also SRP
    # today does not return continuation token.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ListContainerItems] operation results.
    #
    def list(resource_group_name, account_name, custom_headers:nil)
      response = list_async(resource_group_name, account_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all containers and does not support a prefix like data plane. Also SRP
    # today does not return continuation token.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, account_name, custom_headers:nil)
      list_async(resource_group_name, account_name, custom_headers:custom_headers).value!
    end

    #
    # Lists all containers and does not support a prefix like data plane. Also SRP
    # today does not return continuation token.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, account_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::ListContainerItems.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new container under the specified account as described by request
    # body. The container resource includes metadata and properties for that
    # container. It does not include a list of the blobs contained by the
    # container.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param blob_container [BlobContainer] Properties of the blob container to
    # create.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BlobContainer] operation results.
    #
    def create(resource_group_name, account_name, container_name, blob_container, custom_headers:nil)
      response = create_async(resource_group_name, account_name, container_name, blob_container, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new container under the specified account as described by request
    # body. The container resource includes metadata and properties for that
    # container. It does not include a list of the blobs contained by the
    # container.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param blob_container [BlobContainer] Properties of the blob container to
    # create.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_with_http_info(resource_group_name, account_name, container_name, blob_container, custom_headers:nil)
      create_async(resource_group_name, account_name, container_name, blob_container, custom_headers:custom_headers).value!
    end

    #
    # Creates a new container under the specified account as described by request
    # body. The container resource includes metadata and properties for that
    # container. It does not include a list of the blobs contained by the
    # container.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param blob_container [BlobContainer] Properties of the blob container to
    # create.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_async(resource_group_name, account_name, container_name, blob_container, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      fail ArgumentError, 'blob_container is nil' if blob_container.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::BlobContainer.mapper()
      request_content = @client.serialize(request_mapper,  blob_container)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::BlobContainer.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates container properties as specified in request body. Properties not
    # mentioned in the request will be unchanged. Update fails if the specified
    # container doesn't already exist.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param blob_container [BlobContainer] Properties to update for the blob
    # container.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BlobContainer] operation results.
    #
    def update(resource_group_name, account_name, container_name, blob_container, custom_headers:nil)
      response = update_async(resource_group_name, account_name, container_name, blob_container, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates container properties as specified in request body. Properties not
    # mentioned in the request will be unchanged. Update fails if the specified
    # container doesn't already exist.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param blob_container [BlobContainer] Properties to update for the blob
    # container.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(resource_group_name, account_name, container_name, blob_container, custom_headers:nil)
      update_async(resource_group_name, account_name, container_name, blob_container, custom_headers:custom_headers).value!
    end

    #
    # Updates container properties as specified in request body. Properties not
    # mentioned in the request will be unchanged. Update fails if the specified
    # container doesn't already exist.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param blob_container [BlobContainer] Properties to update for the blob
    # container.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(resource_group_name, account_name, container_name, blob_container, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      fail ArgumentError, 'blob_container is nil' if blob_container.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::BlobContainer.mapper()
      request_content = @client.serialize(request_mapper,  blob_container)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::BlobContainer.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets properties of a specified container.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BlobContainer] operation results.
    #
    def get(resource_group_name, account_name, container_name, custom_headers:nil)
      response = get_async(resource_group_name, account_name, container_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets properties of a specified container.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, account_name, container_name, custom_headers:nil)
      get_async(resource_group_name, account_name, container_name, custom_headers:custom_headers).value!
    end

    #
    # Gets properties of a specified container.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, account_name, container_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::BlobContainer.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes specified container under its account.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, account_name, container_name, custom_headers:nil)
      response = delete_async(resource_group_name, account_name, container_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes specified container under its account.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, account_name, container_name, custom_headers:nil)
      delete_async(resource_group_name, account_name, container_name, custom_headers:custom_headers).value!
    end

    #
    # Deletes specified container under its account.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, account_name, container_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Sets legal hold tags. Setting the same tag results in an idempotent
    # operation. SetLegalHold follows an append pattern and does not clear out the
    # existing tags that are not specified in the request.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param legal_hold [LegalHold] The LegalHold property that will be set to a
    # blob container.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [LegalHold] operation results.
    #
    def set_legal_hold(resource_group_name, account_name, container_name, legal_hold, custom_headers:nil)
      response = set_legal_hold_async(resource_group_name, account_name, container_name, legal_hold, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Sets legal hold tags. Setting the same tag results in an idempotent
    # operation. SetLegalHold follows an append pattern and does not clear out the
    # existing tags that are not specified in the request.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param legal_hold [LegalHold] The LegalHold property that will be set to a
    # blob container.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def set_legal_hold_with_http_info(resource_group_name, account_name, container_name, legal_hold, custom_headers:nil)
      set_legal_hold_async(resource_group_name, account_name, container_name, legal_hold, custom_headers:custom_headers).value!
    end

    #
    # Sets legal hold tags. Setting the same tag results in an idempotent
    # operation. SetLegalHold follows an append pattern and does not clear out the
    # existing tags that are not specified in the request.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param legal_hold [LegalHold] The LegalHold property that will be set to a
    # blob container.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def set_legal_hold_async(resource_group_name, account_name, container_name, legal_hold, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1
      fail ArgumentError, 'legal_hold is nil' if legal_hold.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::LegalHold.mapper()
      request_content = @client.serialize(request_mapper,  legal_hold)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/setLegalHold'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::LegalHold.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Clears legal hold tags. Clearing the same or non-existent tag results in an
    # idempotent operation. ClearLegalHold clears out only the specified tags in
    # the request.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param legal_hold [LegalHold] The LegalHold property that will be clear from
    # a blob container.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [LegalHold] operation results.
    #
    def clear_legal_hold(resource_group_name, account_name, container_name, legal_hold, custom_headers:nil)
      response = clear_legal_hold_async(resource_group_name, account_name, container_name, legal_hold, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Clears legal hold tags. Clearing the same or non-existent tag results in an
    # idempotent operation. ClearLegalHold clears out only the specified tags in
    # the request.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param legal_hold [LegalHold] The LegalHold property that will be clear from
    # a blob container.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def clear_legal_hold_with_http_info(resource_group_name, account_name, container_name, legal_hold, custom_headers:nil)
      clear_legal_hold_async(resource_group_name, account_name, container_name, legal_hold, custom_headers:custom_headers).value!
    end

    #
    # Clears legal hold tags. Clearing the same or non-existent tag results in an
    # idempotent operation. ClearLegalHold clears out only the specified tags in
    # the request.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param legal_hold [LegalHold] The LegalHold property that will be clear from
    # a blob container.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def clear_legal_hold_async(resource_group_name, account_name, container_name, legal_hold, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1
      fail ArgumentError, 'legal_hold is nil' if legal_hold.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::LegalHold.mapper()
      request_content = @client.serialize(request_mapper,  legal_hold)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/clearLegalHold'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::LegalHold.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates or updates an unlocked immutability policy. ETag in If-Match is
    # honored if given but not required for this operation.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param parameters [ImmutabilityPolicy] The ImmutabilityPolicy Properties that
    # will be created or updated to a blob container.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ImmutabilityPolicy] operation results.
    #
    def create_or_update_immutability_policy(resource_group_name, account_name, container_name, parameters:nil, if_match:nil, custom_headers:nil)
      response = create_or_update_immutability_policy_async(resource_group_name, account_name, container_name, parameters:parameters, if_match:if_match, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates an unlocked immutability policy. ETag in If-Match is
    # honored if given but not required for this operation.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param parameters [ImmutabilityPolicy] The ImmutabilityPolicy Properties that
    # will be created or updated to a blob container.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_immutability_policy_with_http_info(resource_group_name, account_name, container_name, parameters:nil, if_match:nil, custom_headers:nil)
      create_or_update_immutability_policy_async(resource_group_name, account_name, container_name, parameters:parameters, if_match:if_match, custom_headers:custom_headers).value!
    end

    #
    # Creates or updates an unlocked immutability policy. ETag in If-Match is
    # honored if given but not required for this operation.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param parameters [ImmutabilityPolicy] The ImmutabilityPolicy Properties that
    # will be created or updated to a blob container.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_immutability_policy_async(resource_group_name, account_name, container_name, parameters:nil, if_match:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      immutability_policy_name = 'default'
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::ImmutabilityPolicy.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'immutabilityPolicyName' => immutability_policy_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::ImmutabilityPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the existing immutability policy along with the corresponding ETag in
    # response headers and body.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ImmutabilityPolicy] operation results.
    #
    def get_immutability_policy(resource_group_name, account_name, container_name, if_match:nil, custom_headers:nil)
      response = get_immutability_policy_async(resource_group_name, account_name, container_name, if_match:if_match, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the existing immutability policy along with the corresponding ETag in
    # response headers and body.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_immutability_policy_with_http_info(resource_group_name, account_name, container_name, if_match:nil, custom_headers:nil)
      get_immutability_policy_async(resource_group_name, account_name, container_name, if_match:if_match, custom_headers:custom_headers).value!
    end

    #
    # Gets the existing immutability policy along with the corresponding ETag in
    # response headers and body.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_immutability_policy_async(resource_group_name, account_name, container_name, if_match:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      immutability_policy_name = 'default'
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'immutabilityPolicyName' => immutability_policy_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::ImmutabilityPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Aborts an unlocked immutability policy. The response of delete has
    # immutabilityPeriodSinceCreationInDays set to 0. ETag in If-Match is required
    # for this operation. Deleting a locked immutability policy is not allowed,
    # only way is to delete the container after deleting all blobs inside the
    # container.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ImmutabilityPolicy] operation results.
    #
    def delete_immutability_policy(resource_group_name, account_name, container_name, if_match, custom_headers:nil)
      response = delete_immutability_policy_async(resource_group_name, account_name, container_name, if_match, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Aborts an unlocked immutability policy. The response of delete has
    # immutabilityPeriodSinceCreationInDays set to 0. ETag in If-Match is required
    # for this operation. Deleting a locked immutability policy is not allowed,
    # only way is to delete the container after deleting all blobs inside the
    # container.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_immutability_policy_with_http_info(resource_group_name, account_name, container_name, if_match, custom_headers:nil)
      delete_immutability_policy_async(resource_group_name, account_name, container_name, if_match, custom_headers:custom_headers).value!
    end

    #
    # Aborts an unlocked immutability policy. The response of delete has
    # immutabilityPeriodSinceCreationInDays set to 0. ETag in If-Match is required
    # for this operation. Deleting a locked immutability policy is not allowed,
    # only way is to delete the container after deleting all blobs inside the
    # container.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_immutability_policy_async(resource_group_name, account_name, container_name, if_match, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      immutability_policy_name = 'default'
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1
      fail ArgumentError, 'if_match is nil' if if_match.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'immutabilityPolicyName' => immutability_policy_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::ImmutabilityPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Sets the ImmutabilityPolicy to Locked state. The only action allowed on a
    # Locked policy is ExtendImmutabilityPolicy action. ETag in If-Match is
    # required for this operation.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ImmutabilityPolicy] operation results.
    #
    def lock_immutability_policy(resource_group_name, account_name, container_name, if_match, custom_headers:nil)
      response = lock_immutability_policy_async(resource_group_name, account_name, container_name, if_match, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Sets the ImmutabilityPolicy to Locked state. The only action allowed on a
    # Locked policy is ExtendImmutabilityPolicy action. ETag in If-Match is
    # required for this operation.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def lock_immutability_policy_with_http_info(resource_group_name, account_name, container_name, if_match, custom_headers:nil)
      lock_immutability_policy_async(resource_group_name, account_name, container_name, if_match, custom_headers:custom_headers).value!
    end

    #
    # Sets the ImmutabilityPolicy to Locked state. The only action allowed on a
    # Locked policy is ExtendImmutabilityPolicy action. ETag in If-Match is
    # required for this operation.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def lock_immutability_policy_async(resource_group_name, account_name, container_name, if_match, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1
      fail ArgumentError, 'if_match is nil' if if_match.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/lock'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::ImmutabilityPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Extends the immutabilityPeriodSinceCreationInDays of a locked
    # immutabilityPolicy. The only action allowed on a Locked policy will be this
    # action. ETag in If-Match is required for this operation.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param parameters [ImmutabilityPolicy] The ImmutabilityPolicy Properties that
    # will be extended for a blob container.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ImmutabilityPolicy] operation results.
    #
    def extend_immutability_policy(resource_group_name, account_name, container_name, if_match, parameters:nil, custom_headers:nil)
      response = extend_immutability_policy_async(resource_group_name, account_name, container_name, if_match, parameters:parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Extends the immutabilityPeriodSinceCreationInDays of a locked
    # immutabilityPolicy. The only action allowed on a Locked policy will be this
    # action. ETag in If-Match is required for this operation.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param parameters [ImmutabilityPolicy] The ImmutabilityPolicy Properties that
    # will be extended for a blob container.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def extend_immutability_policy_with_http_info(resource_group_name, account_name, container_name, if_match, parameters:nil, custom_headers:nil)
      extend_immutability_policy_async(resource_group_name, account_name, container_name, if_match, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # Extends the immutabilityPeriodSinceCreationInDays of a locked
    # immutabilityPolicy. The only action allowed on a Locked policy will be this
    # action. ETag in If-Match is required for this operation.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param if_match [String] The entity state (ETag) version of the immutability
    # policy to update. A value of "*" can be used to apply the operation only if
    # the immutability policy already exists. If omitted, this operation will
    # always be applied.
    # @param parameters [ImmutabilityPolicy] The ImmutabilityPolicy Properties that
    # will be extended for a blob container.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def extend_immutability_policy_async(resource_group_name, account_name, container_name, if_match, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1
      fail ArgumentError, 'if_match is nil' if if_match.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::ImmutabilityPolicy.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/extend'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::ImmutabilityPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The Lease Container operation establishes and manages a lock on a container
    # for delete operations. The lock duration can be 15 to 60 seconds, or can be
    # infinite.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param parameters [LeaseContainerRequest] Lease Container request body.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [LeaseContainerResponse] operation results.
    #
    def lease(resource_group_name, account_name, container_name, parameters:nil, custom_headers:nil)
      response = lease_async(resource_group_name, account_name, container_name, parameters:parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The Lease Container operation establishes and manages a lock on a container
    # for delete operations. The lock duration can be 15 to 60 seconds, or can be
    # infinite.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param parameters [LeaseContainerRequest] Lease Container request body.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def lease_with_http_info(resource_group_name, account_name, container_name, parameters:nil, custom_headers:nil)
      lease_async(resource_group_name, account_name, container_name, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # The Lease Container operation establishes and manages a lock on a container
    # for delete operations. The lock duration can be 15 to 60 seconds, or can be
    # infinite.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # user's subscription. The name is case insensitive.
    # @param account_name [String] The name of the storage account within the
    # specified resource group. Storage account names must be between 3 and 24
    # characters in length and use numbers and lower-case letters only.
    # @param container_name [String] The name of the blob container within the
    # specified storage account. Blob container names must be between 3 and 63
    # characters in length and use numbers, lower-case letters and dash (-) only.
    # Every dash (-) character must be immediately preceded and followed by a
    # letter or number.
    # @param parameters [LeaseContainerRequest] Lease Container request body.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def lease_async(resource_group_name, account_name, container_name, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MaxLength': '90'" if !resource_group_name.nil? && resource_group_name.length > 90
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'MinLength': '1'" if !resource_group_name.nil? && resource_group_name.length < 1
      fail ArgumentError, "'resource_group_name' should satisfy the constraint - 'Pattern': '^[-\w\._\(\)]+$'" if !resource_group_name.nil? && resource_group_name.match(Regexp.new('^^[-\w\._\(\)]+$$')).nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MaxLength': '24'" if !account_name.nil? && account_name.length > 24
      fail ArgumentError, "'account_name' should satisfy the constraint - 'MinLength': '3'" if !account_name.nil? && account_name.length < 3
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MaxLength': '63'" if !container_name.nil? && container_name.length > 63
      fail ArgumentError, "'container_name' should satisfy the constraint - 'MinLength': '3'" if !container_name.nil? && container_name.length < 3
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, "'@client.api_version' should satisfy the constraint - 'MinLength': '1'" if !@client.api_version.nil? && @client.api_version.length < 1
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, "'@client.subscription_id' should satisfy the constraint - 'MinLength': '1'" if !@client.subscription_id.nil? && @client.subscription_id.length < 1


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::LeaseContainerRequest.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/lease'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Storage::Mgmt::V2018_07_01::Models::LeaseContainerResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
