# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_08_06_preview
  module Models
    #
    # IoT recommendation type.
    #
    class IotRecommendationType < Resource

      include MsRestAzure

      # @return [String] The display name of the recommendation
      attr_accessor :recommendation_display_name

      # @return [RecommendationSeverity] The severity of the recommendation.
      # Possible values include: 'Unknown', 'NotApplicable', 'Healthy',
      # 'OffByPolicy', 'Low', 'Medium', 'High'
      attr_accessor :severity

      # @return [String] Description of the suspected vulnerability and
      # meaning.
      attr_accessor :description

      # @return [String] The name of the product which published this
      # recommendation
      attr_accessor :product_name

      # @return [String] The name of a component inside the product which
      # generated the recommendation
      attr_accessor :product_component_name

      # @return [String] The name of the vendor that raised the recommendation
      attr_accessor :vendor_name

      # @return [String] The name of the recommendation's control category
      attr_accessor :control

      # @return [Array<String>] Manual action items to take to resolve the
      # recommendation
      attr_accessor :remediation_steps

      # @return [String] The alert's data source
      attr_accessor :data_source


      #
      # Mapper for IotRecommendationType class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'IotRecommendationType',
          type: {
            name: 'Composite',
            class_name: 'IotRecommendationType',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              recommendation_display_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.recommendationDisplayName',
                type: {
                  name: 'String'
                }
              },
              severity: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.severity',
                type: {
                  name: 'String'
                }
              },
              description: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.description',
                type: {
                  name: 'String'
                }
              },
              product_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.productName',
                type: {
                  name: 'String'
                }
              },
              product_component_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.productComponentName',
                type: {
                  name: 'String'
                }
              },
              vendor_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.vendorName',
                type: {
                  name: 'String'
                }
              },
              control: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.control',
                type: {
                  name: 'String'
                }
              },
              remediation_steps: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.remediationSteps',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              data_source: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.dataSource',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
