# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_08_06_preview
  module Models
    #
    # Device model
    #
    class Device < Resource

      include MsRestAzure

      # @return [String] Device display name given by the collector
      attr_accessor :display_name

      # @return [String] Device type.
      attr_accessor :device_type

      # @return [String] The source that created the device
      attr_accessor :source_name

      # @return [Array<NetworkInterface>] List of network interfaces.
      attr_accessor :network_interfaces

      # @return [String] Device vendor
      attr_accessor :vendor

      # @return [String] Device operating system name.
      attr_accessor :os_name

      # @return [Array<Protocol>] List of protocols.
      attr_accessor :protocols

      # @return [DateTime] last time the device was active in the network
      attr_accessor :last_active_time

      # @return [DateTime] last time the device was updated
      attr_accessor :last_update_time

      # @return [ManagementState] Managed state of the device. Possible values
      # include: 'Managed', 'Unmanaged'
      attr_accessor :management_state

      # @return [AuthorizationState] Authorized state of the device. Possible
      # values include: 'Authorized', 'Unauthorized'. Default value:
      # 'Unauthorized' .
      attr_accessor :authorization_state

      # @return [DeviceCriticality] Device criticality. Possible values
      # include: 'Important', 'Standard'. Default value: 'Standard' .
      attr_accessor :device_criticality

      # @return [PurdueLevel] Purdue level of the device. Possible values
      # include: 'ProcessControl', 'Supervisory', 'Enterprise'. Default value:
      # 'ProcessControl' .
      attr_accessor :purdue_level

      # @return [String] user notes for the device, up to 300 characters.
      attr_accessor :notes

      # @return [Array<Firmware>] List of device firmwares.
      attr_accessor :firmwares

      # @return [DateTime] Discovered time of the device.
      attr_accessor :discovery_time

      # @return [ProgrammingState] Indicates whether this device is
      # programming. Possible values include: 'ProgrammingDevice',
      # 'NotProgrammingDevice'
      attr_accessor :programming_state

      # @return [DateTime] last time the device was programming or programed.
      attr_accessor :last_programming_time

      # @return [ScanningFunctionality] Indicates whether the device is a
      # scanner. Possible values include: 'ScannerDevice', 'NotScannerDevice'
      attr_accessor :scanning_functionality

      # @return [DateTime] last time the device was scanning.
      attr_accessor :last_scan_time

      # @return [Integer] risk score of the device.
      attr_accessor :risk_score

      # @return [Array<Sensor>] List of sensors that scanned this device.
      attr_accessor :sensors

      # @return [Site]
      attr_accessor :site

      # @return [DeviceStatus] Device status. Possible values include:
      # 'Active', 'Removed'
      attr_accessor :device_status


      #
      # Mapper for Device class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'Device',
          type: {
            name: 'Composite',
            class_name: 'Device',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              display_name: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.displayName',
                type: {
                  name: 'String'
                }
              },
              device_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.deviceType',
                type: {
                  name: 'String'
                }
              },
              source_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.sourceName',
                type: {
                  name: 'String'
                }
              },
              network_interfaces: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.networkInterfaces',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'NetworkInterfaceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'NetworkInterface'
                      }
                  }
                }
              },
              vendor: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.vendor',
                type: {
                  name: 'String'
                }
              },
              os_name: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.osName',
                type: {
                  name: 'String'
                }
              },
              protocols: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.protocols',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'ProtocolElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'Protocol'
                      }
                  }
                }
              },
              last_active_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.lastActiveTime',
                type: {
                  name: 'DateTime'
                }
              },
              last_update_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.lastUpdateTime',
                type: {
                  name: 'DateTime'
                }
              },
              management_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.managementState',
                type: {
                  name: 'String'
                }
              },
              authorization_state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.authorizationState',
                default_value: 'Unauthorized',
                type: {
                  name: 'String'
                }
              },
              device_criticality: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.deviceCriticality',
                default_value: 'Standard',
                type: {
                  name: 'String'
                }
              },
              purdue_level: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.purdueLevel',
                default_value: 'ProcessControl',
                type: {
                  name: 'String'
                }
              },
              notes: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.notes',
                type: {
                  name: 'String'
                }
              },
              firmwares: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.firmwares',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'FirmwareElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'Firmware'
                      }
                  }
                }
              },
              discovery_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.discoveryTime',
                type: {
                  name: 'DateTime'
                }
              },
              programming_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.programmingState',
                type: {
                  name: 'String'
                }
              },
              last_programming_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.lastProgrammingTime',
                type: {
                  name: 'DateTime'
                }
              },
              scanning_functionality: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.scanningFunctionality',
                type: {
                  name: 'String'
                }
              },
              last_scan_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.lastScanTime',
                type: {
                  name: 'DateTime'
                }
              },
              risk_score: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.riskScore',
                constraints: {
                  InclusiveMaximum: 100,
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Number'
                }
              },
              sensors: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.sensors',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SensorElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'Sensor'
                      }
                  }
                }
              },
              site: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.site',
                type: {
                  name: 'Composite',
                  class_name: 'Site'
                }
              },
              device_status: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.deviceStatus',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
