# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_07_01_preview
  #
  # API spec for Microsoft.Security (Azure Security Center) resource provider
  #
  class SqlVulnerabilityAssessmentBaselineRules
    include MsRestAzure

    #
    # Creates and initializes a new instance of the SqlVulnerabilityAssessmentBaselineRules class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SecurityCenter] reference to the SecurityCenter
    attr_reader :client

    #
    # Creates a Baseline for a rule in a database. Will overwrite any previously
    # existing results.
    #
    # @param rule_id [String] The rule Id.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param body [RuleResultsInput] The baseline results for this rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RuleResults] operation results.
    #
    def create_or_update(rule_id, workspace_id, api_version, resource_id, body:nil, custom_headers:nil)
      response = create_or_update_async(rule_id, workspace_id, api_version, resource_id, body:body, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a Baseline for a rule in a database. Will overwrite any previously
    # existing results.
    #
    # @param rule_id [String] The rule Id.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param body [RuleResultsInput] The baseline results for this rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(rule_id, workspace_id, api_version, resource_id, body:nil, custom_headers:nil)
      create_or_update_async(rule_id, workspace_id, api_version, resource_id, body:body, custom_headers:custom_headers).value!
    end

    #
    # Creates a Baseline for a rule in a database. Will overwrite any previously
    # existing results.
    #
    # @param rule_id [String] The rule Id.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param body [RuleResultsInput] The baseline results for this rule.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(rule_id, workspace_id, api_version, resource_id, body:nil, custom_headers:nil)
      fail ArgumentError, 'rule_id is nil' if rule_id.nil?
      fail ArgumentError, 'workspace_id is nil' if workspace_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Security::Mgmt::V2020_07_01_preview::Models::RuleResultsInput.mapper()
      request_content = @client.serialize(request_mapper,  body)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'ruleId' => rule_id},
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'workspaceId' => workspace_id,'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_07_01_preview::Models::RuleResults.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the results for a given rule in the Baseline.
    #
    # @param rule_id [String] The rule Id.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RuleResults] operation results.
    #
    def get(rule_id, workspace_id, api_version, resource_id, custom_headers:nil)
      response = get_async(rule_id, workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the results for a given rule in the Baseline.
    #
    # @param rule_id [String] The rule Id.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(rule_id, workspace_id, api_version, resource_id, custom_headers:nil)
      get_async(rule_id, workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
    end

    #
    # Gets the results for a given rule in the Baseline.
    #
    # @param rule_id [String] The rule Id.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(rule_id, workspace_id, api_version, resource_id, custom_headers:nil)
      fail ArgumentError, 'rule_id is nil' if rule_id.nil?
      fail ArgumentError, 'workspace_id is nil' if workspace_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'ruleId' => rule_id},
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'workspaceId' => workspace_id,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_07_01_preview::Models::RuleResults.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a rule from the Baseline of a given database.
    #
    # @param rule_id [String] The rule Id.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(rule_id, workspace_id, api_version, resource_id, custom_headers:nil)
      response = delete_async(rule_id, workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes a rule from the Baseline of a given database.
    #
    # @param rule_id [String] The rule Id.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(rule_id, workspace_id, api_version, resource_id, custom_headers:nil)
      delete_async(rule_id, workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
    end

    #
    # Deletes a rule from the Baseline of a given database.
    #
    # @param rule_id [String] The rule Id.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(rule_id, workspace_id, api_version, resource_id, custom_headers:nil)
      fail ArgumentError, 'rule_id is nil' if rule_id.nil?
      fail ArgumentError, 'workspace_id is nil' if workspace_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'ruleId' => rule_id},
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'workspaceId' => workspace_id,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the results for all rules in the Baseline.
    #
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RulesResults] operation results.
    #
    def list(workspace_id, api_version, resource_id, custom_headers:nil)
      response = list_async(workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the results for all rules in the Baseline.
    #
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(workspace_id, api_version, resource_id, custom_headers:nil)
      list_async(workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
    end

    #
    # Gets the results for all rules in the Baseline.
    #
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(workspace_id, api_version, resource_id, custom_headers:nil)
      fail ArgumentError, 'workspace_id is nil' if workspace_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'workspaceId' => workspace_id,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_07_01_preview::Models::RulesResults.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Add a list of baseline rules. Will overwrite any previously existing results
    # (for all rules).
    #
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param body [RulesResultsInput] The baseline rules.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RulesResults] operation results.
    #
    def add(workspace_id, api_version, resource_id, body:nil, custom_headers:nil)
      response = add_async(workspace_id, api_version, resource_id, body:body, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Add a list of baseline rules. Will overwrite any previously existing results
    # (for all rules).
    #
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param body [RulesResultsInput] The baseline rules.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_with_http_info(workspace_id, api_version, resource_id, body:nil, custom_headers:nil)
      add_async(workspace_id, api_version, resource_id, body:body, custom_headers:custom_headers).value!
    end

    #
    # Add a list of baseline rules. Will overwrite any previously existing results
    # (for all rules).
    #
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param body [RulesResultsInput] The baseline rules.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_async(workspace_id, api_version, resource_id, body:nil, custom_headers:nil)
      fail ArgumentError, 'workspace_id is nil' if workspace_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Security::Mgmt::V2020_07_01_preview::Models::RulesResultsInput.mapper()
      request_content = @client.serialize(request_mapper,  body)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'workspaceId' => workspace_id,'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_07_01_preview::Models::RulesResults.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
