# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_07_01_preview
  module Models
    #
    # A vulnerability assessment scan record properties.
    #
    class ScanProperties

      include MsRestAzure

      # @return [ScanTriggerType] Possible values include: 'OnDemand',
      # 'Recurring'
      attr_accessor :trigger_type

      # @return [ScanState] Possible values include: 'Failed', 'FailedToRun',
      # 'InProgress', 'Passed'
      attr_accessor :state

      # @return [String] The server name.
      attr_accessor :server

      # @return [String] The database name.
      attr_accessor :database

      # @return [String] The SQL version.
      attr_accessor :sql_version

      # @return [DateTime] The scan start time (UTC).
      attr_accessor :start_time

      # @return [DateTime] Scan results are valid until end time (UTC).
      attr_accessor :end_time

      # @return [Integer] The number of failed rules with high severity.
      attr_accessor :high_severity_failed_rules_count

      # @return [Integer] The number of failed rules with medium severity.
      attr_accessor :medium_severity_failed_rules_count

      # @return [Integer] The number of failed rules with low severity.
      attr_accessor :low_severity_failed_rules_count

      # @return [Integer] The number of total passed rules.
      attr_accessor :total_passed_rules_count

      # @return [Integer] The number of total failed rules.
      attr_accessor :total_failed_rules_count

      # @return [Integer] The number of total rules assessed.
      attr_accessor :total_rules_count

      # @return [Boolean] Baseline created for this database, and has one or
      # more rules.
      attr_accessor :is_baseline_applied


      #
      # Mapper for ScanProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'ScanProperties',
          type: {
            name: 'Composite',
            class_name: 'ScanProperties',
            model_properties: {
              trigger_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'triggerType',
                type: {
                  name: 'String'
                }
              },
              state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'state',
                type: {
                  name: 'String'
                }
              },
              server: {
                client_side_validation: true,
                required: false,
                serialized_name: 'server',
                type: {
                  name: 'String'
                }
              },
              database: {
                client_side_validation: true,
                required: false,
                serialized_name: 'database',
                type: {
                  name: 'String'
                }
              },
              sql_version: {
                client_side_validation: true,
                required: false,
                serialized_name: 'sqlVersion',
                type: {
                  name: 'String'
                }
              },
              start_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'startTime',
                type: {
                  name: 'DateTime'
                }
              },
              end_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'endTime',
                type: {
                  name: 'DateTime'
                }
              },
              high_severity_failed_rules_count: {
                client_side_validation: true,
                required: false,
                serialized_name: 'highSeverityFailedRulesCount',
                type: {
                  name: 'Number'
                }
              },
              medium_severity_failed_rules_count: {
                client_side_validation: true,
                required: false,
                serialized_name: 'mediumSeverityFailedRulesCount',
                type: {
                  name: 'Number'
                }
              },
              low_severity_failed_rules_count: {
                client_side_validation: true,
                required: false,
                serialized_name: 'lowSeverityFailedRulesCount',
                type: {
                  name: 'Number'
                }
              },
              total_passed_rules_count: {
                client_side_validation: true,
                required: false,
                serialized_name: 'totalPassedRulesCount',
                type: {
                  name: 'Number'
                }
              },
              total_failed_rules_count: {
                client_side_validation: true,
                required: false,
                serialized_name: 'totalFailedRulesCount',
                type: {
                  name: 'Number'
                }
              },
              total_rules_count: {
                client_side_validation: true,
                required: false,
                serialized_name: 'totalRulesCount',
                type: {
                  name: 'Number'
                }
              },
              is_baseline_applied: {
                client_side_validation: true,
                required: false,
                serialized_name: 'isBaselineApplied',
                type: {
                  name: 'Boolean'
                }
              }
            }
          }
        }
      end
    end
  end
end
